/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BufferConsumer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public abstract class AbstractBodyAdapter<B, S extends BaseSharedBuffer<?, ?>>
implements BufferConsumer.Upstream,
Subscriber<B> {
    protected S sharedBuffer;
    protected volatile Subscription subscription;
    protected final AtomicLong demand = new AtomicLong(1L);
    private final Publisher<B> source;
    @Nullable
    private final Runnable onDiscard;
    private volatile boolean cancelled;

    public AbstractBodyAdapter(@NonNull Publisher<B> source, @Nullable Runnable onDiscard) {
        this.source = source;
        this.onDiscard = onDiscard;
    }

    @Override
    public final void start() {
        this.source.subscribe(this);
    }

    @Override
    public final void onBytesConsumed(long bytesConsumed) {
        if (bytesConsumed < 0L) {
            throw new IllegalArgumentException("Negative bytes consumed");
        }
        LongUnaryOperator add = l -> l + bytesConsumed < l ? Long.MAX_VALUE : l + bytesConsumed;
        long oldDemand = this.demand.getAndUpdate(add);
        long newDemand = add.applyAsLong(oldDemand);
        if (oldDemand <= 0L && newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public final void allowDiscard() {
        this.cancelled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (this.onDiscard != null) {
            this.onDiscard.run();
        }
    }

    @Override
    public final void disregardBackpressure() {
        this.demand.set(Long.MAX_VALUE);
        if (this.subscription != null) {
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        this.subscription = s2;
        if (this.cancelled) {
            s2.cancel();
        } else {
            s2.request(1L);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ((BaseSharedBuffer)this.sharedBuffer).error(t2);
    }

    @Override
    public void onComplete() {
        ((BaseSharedBuffer)this.sharedBuffer).complete();
    }
}

