/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.body.AbstractBodyAdapter;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ReactiveByteBufferByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import java.nio.ByteBuffer;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;

public final class ByteBufferBodyAdapter
extends AbstractBodyAdapter<ByteBuffer, ReactiveByteBufferByteBody.SharedBuffer> {
    private ByteBufferBodyAdapter(Publisher<ByteBuffer> source, @Nullable Runnable onDiscard) {
        super(source, onDiscard);
    }

    @NonNull
    static ReactiveByteBufferByteBody adapt(@NonNull Publisher<ByteBuffer> source) {
        return ByteBufferBodyAdapter.adapt(source, null, null);
    }

    @NonNull
    static ReactiveByteBufferByteBody adapt(@NonNull Publisher<ByteBuffer> publisher, @Nullable HttpHeaders headersForLength, @Nullable Runnable onDiscard) {
        ByteBufferBodyAdapter adapter = new ByteBufferBodyAdapter(publisher, onDiscard);
        adapter.sharedBuffer = new ReactiveByteBufferByteBody.SharedBuffer(BodySizeLimits.UNLIMITED, adapter);
        if (headersForLength != null) {
            ((ReactiveByteBufferByteBody.SharedBuffer)adapter.sharedBuffer).setExpectedLengthFrom((String)headersForLength.get("Content-Length"));
        }
        return new ReactiveByteBufferByteBody((ReactiveByteBufferByteBody.SharedBuffer)adapter.sharedBuffer);
    }

    public static CloseableByteBody adapt(@NonNull Publisher<ByteBuffer> publisher, @NonNull OptionalLong contentLength) {
        ByteBufferBodyAdapter adapter = new ByteBufferBodyAdapter(publisher, null);
        adapter.sharedBuffer = new ReactiveByteBufferByteBody.SharedBuffer(BodySizeLimits.UNLIMITED, adapter);
        contentLength.ifPresent(((ReactiveByteBufferByteBody.SharedBuffer)adapter.sharedBuffer)::setExpectedLength);
        return new ReactiveByteBufferByteBody((ReactiveByteBufferByteBody.SharedBuffer)adapter.sharedBuffer);
    }

    @Override
    public void onNext(ByteBuffer buffer) {
        long newDemand = this.demand.addAndGet(-buffer.remaining());
        ((ReactiveByteBufferByteBody.SharedBuffer)this.sharedBuffer).add(buffer);
        if (newDemand > 0L) {
            this.subscription.request(1L);
        }
    }
}

