/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import java.io.OutputStream;

@Internal
final class ResponseBodyWriterWrapper<T>
implements ResponseBodyWriter<T> {
    private final MessageBodyWriter<T> wrapped;

    ResponseBodyWriterWrapper(MessageBodyWriter<T> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.wrapped.isWriteable(type, mediaType);
    }

    @Override
    public MessageBodyWriter<T> createSpecific(@NonNull Argument<T> type) {
        return this.wrapped.createSpecific(type);
    }

    @Override
    public boolean isBlocking() {
        return this.wrapped.isBlocking();
    }

    @Override
    public void writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        this.wrapped.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    @Override
    @NonNull
    public ByteBuffer<?> writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return this.wrapped.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }

    @Override
    @NonNull
    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<T> httpResponse, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) throws CodecException {
        return ByteBodyHttpResponseWrapper.wrap(httpResponse, this.writePiece(bodyFactory, (MutableHttpHeaders)httpResponse.getHeaders(), type, mediaType, object));
    }

    @Override
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return this.writePiece(bodyFactory, (MutableHttpHeaders)response.toMutableResponse().getHeaders(), type, mediaType, object);
    }

    @NonNull
    private CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, MutableHttpHeaders headers, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return bodyFactory.buffer(s2 -> this.writeTo(type, mediaType, object, (MutableHeaders)headers, (OutputStream)s2));
    }
}

