/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.TypedMessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Singleton
@BootstrapContextCompatible
public final class StringBodyReader
implements TypedMessageBodyReader<String>,
ChunkedMessageBodyReader<String> {
    private final Charset defaultCharset;

    StringBodyReader(ApplicationConfiguration applicationConfiguration) {
        this.defaultCharset = applicationConfiguration.getDefaultCharset();
    }

    @Override
    public Argument<String> getType() {
        return Argument.STRING;
    }

    @Override
    public String read(Argument<String> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return this.read0(byteBuffer, this.getCharset(mediaType, httpHeaders));
    }

    private String read0(ByteBuffer<?> byteBuffer, Charset charset) {
        String s2 = byteBuffer.toString(charset);
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)((Object)byteBuffer);
            rc.release();
        }
        return s2;
    }

    @Override
    public String read(Argument<String> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            return new String(inputStream.readAllBytes(), this.getCharset(mediaType, httpHeaders));
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
    }

    @Override
    public Publisher<String> readChunked(Argument<String> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return Flux.from(input).map(byteBuffer -> this.read0((ByteBuffer<?>)byteBuffer, this.getCharset(mediaType, httpHeaders)));
    }

    private Charset getCharset(MediaType mediaType, Headers httpHeaders) {
        return MessageBodyWriter.findCharset(mediaType, httpHeaders).orElse(this.defaultCharset);
    }
}

