/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.ExtendedInputStream;
import io.micronaut.http.body.stream.StreamPair;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public final class InputStreamByteBody
implements CloseableByteBody,
InternalByteBody {
    private final Context context;
    private ExtendedInputStream stream;

    private InputStreamByteBody(Context context, ExtendedInputStream stream) {
        this.context = context;
        this.stream = stream;
    }

    @NonNull
    public static CloseableByteBody create(@NonNull InputStream stream, @NonNull OptionalLong length, @NonNull Executor ioExecutor, @NonNull ByteBufferFactory<?, ?> bufferFactory) {
        ArgumentUtils.requireNonNull("bufferFactory", bufferFactory);
        return InputStreamByteBody.create(stream, length, ioExecutor, ByteBodyFactory.createDefault(bufferFactory));
    }

    @NonNull
    public static CloseableByteBody create(@NonNull InputStream stream, @NonNull OptionalLong length, @NonNull Executor ioExecutor, @NonNull ByteBodyFactory bodyFactory) {
        ArgumentUtils.requireNonNull("stream", stream);
        ArgumentUtils.requireNonNull("length", length);
        ArgumentUtils.requireNonNull("ioExecutor", ioExecutor);
        ArgumentUtils.requireNonNull("bodyFactory", bodyFactory);
        return new InputStreamByteBody(new Context(length, ioExecutor, bodyFactory), ExtendedInputStream.wrap(stream));
    }

    @Override
    @NonNull
    public CloseableByteBody allowDiscard() {
        if (this.stream == null) {
            BaseSharedBuffer.failClaim();
        }
        this.stream.allowDiscard();
        return this;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    @NonNull
    public CloseableByteBody split(ByteBody.SplitBackpressureMode backpressureMode) {
        if (this.stream == null) {
            BaseSharedBuffer.failClaim();
        }
        StreamPair.Pair pair = StreamPair.createStreamPair(this.stream, backpressureMode);
        this.stream = pair.left();
        return new InputStreamByteBody(this.context, pair.right());
    }

    @Override
    @NonNull
    public OptionalLong expectedLength() {
        return this.context.expectedLength();
    }

    @Override
    @NonNull
    public ExtendedInputStream toInputStream() {
        ExtendedInputStream s2 = this.stream;
        if (s2 == null) {
            BaseSharedBuffer.failClaim();
        }
        this.stream = null;
        BaseSharedBuffer.logClaim();
        return s2;
    }

    @NonNull
    public Flux<byte[]> toByteArrayPublisher() {
        ExtendedInputStream s2 = this.toInputStream();
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnRequest(req -> {
            for (long remaining = req; remaining > 0L; --remaining) {
                byte[] arr;
                try {
                    arr = s2.readSome();
                }
                catch (IOException e) {
                    sink.tryEmitError(e);
                    break;
                }
                if (arr == null) {
                    sink.tryEmitComplete();
                    break;
                }
                sink.tryEmitNext(arr);
            }
        }).doOnTerminate(s2::close).doOnCancel(s2::close).subscribeOn(Schedulers.fromExecutor(this.context.ioExecutor()));
    }

    @Override
    @NonNull
    public Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return ((Flux)this.toByteArrayPublisher()).map(this.context.bodyFactory.byteBufferFactory()::wrap);
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        ExtendedInputStream s2 = this.toInputStream();
        return ExecutionFlow.async(this.context.ioExecutor, () -> {
            ExtendedInputStream t2 = s2;
            try {
                ExecutionFlow<CloseableAvailableByteBody> executionFlow = ExecutionFlow.just(this.context.bodyFactory().copyOf(t2));
                if (t2 != null) {
                    t2.close();
                }
                return executionFlow;
            }
            catch (Throwable throwable) {
                try {
                    if (t2 != null) {
                        try {
                            t2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ExecutionFlow.error(e);
                }
            }
        });
    }

    @Override
    @NonNull
    public CloseableByteBody move() {
        return new InputStreamByteBody(this.context, this.toInputStream());
    }

    private record Context(OptionalLong expectedLength, Executor ioExecutor, ByteBodyFactory bodyFactory) {
    }
}

