/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import java.io.Closeable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.scheduler.NonBlocking;

@Internal
public class PublisherAsBlocking<T>
implements Subscriber<T>,
Closeable {
    private final Lock lock = new ReentrantLock();
    private final Condition newDataCondition = this.lock.newCondition();
    private boolean pendingDemand;
    private T swap;
    private Subscription subscription;
    private boolean done;
    private boolean closed;
    private Throwable failure;

    protected void release(T item) {
    }

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Subscription s2) {
        boolean closed;
        boolean pendingDemand;
        this.lock.lock();
        try {
            this.subscription = s2;
            pendingDemand = this.pendingDemand;
            closed = this.closed;
        }
        finally {
            this.lock.unlock();
        }
        if (closed) {
            s2.cancel();
        } else if (pendingDemand) {
            s2.request(1L);
        }
    }

    @Override
    public void onNext(T o) {
        this.lock.lock();
        try {
            if (this.closed) {
                this.release(o);
                return;
            }
            this.swap = o;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.lock.lock();
        try {
            if (this.swap != null) {
                this.release(this.swap);
                this.swap = null;
            }
            this.failure = t2;
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onComplete() {
        this.lock.lock();
        try {
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T take() throws InterruptedException {
        boolean demanded = false;
        while (true) {
            Subscription subscription;
            this.lock.lock();
            try {
                T swap = this.swap;
                if (swap != null) {
                    this.swap = null;
                    T t2 = swap;
                    return t2;
                }
                if (this.done) {
                    T t3 = null;
                    return t3;
                }
                if (demanded) {
                    if (Thread.currentThread() instanceof NonBlocking) {
                        throw new IllegalStateException("Attempted to do blocking operation on a thread marked as NonBlocking. (Maybe the netty event loop?) Please only run blocking operations on IO or virtual threads, for example by marking your controller with @ExecuteOn(TaskExecutors.BLOCKING).");
                    }
                    this.newDataCondition.await();
                }
                if ((subscription = this.subscription) == null) {
                    this.pendingDemand = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (demanded) continue;
            demanded = true;
            if (subscription == null) continue;
            subscription.request(1L);
        }
    }

    @Override
    public void close() {
        Subscription subscription;
        this.lock.lock();
        try {
            this.closed = true;
            subscription = this.subscription;
            if (this.swap != null) {
                this.release(this.swap);
                this.swap = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }
}

