/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.converters;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.Readable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.net.URL;
import java.util.Optional;

@Prototype
public class HttpConverterRegistrar
implements TypeConverterRegistrar {
    private final BeanProvider<ResourceResolver> resourceResolver;

    @Inject
    protected HttpConverterRegistrar(BeanProvider<ResourceResolver> resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Deprecated(forRemoval=true)
    protected HttpConverterRegistrar(final Provider<ResourceResolver> resourceResolver) {
        this.resourceResolver = new BeanProvider<ResourceResolver>(){

            @Override
            public ResourceResolver get() {
                return (ResourceResolver)resourceResolver.get();
            }
        };
    }

    @Override
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, Readable.class, (object, targetType, context) -> {
            String pathStr = object.toString();
            Optional<ResourceLoader> supportingLoader = this.resourceResolver.get().getSupportingLoader(pathStr);
            if (supportingLoader.isEmpty()) {
                context.reject(pathStr, new ConfigurationException("No supported resource loader for path [" + pathStr + "]. Prefix the path with a supported prefix such as 'classpath:' or 'file:'"));
                return Optional.empty();
            }
            Optional<URL> resource = this.resourceResolver.get().getResource(pathStr);
            if (resource.isPresent()) {
                return Optional.of(Readable.of(resource.get()));
            }
            context.reject(object, new ConfigurationException("No resource exists for value: " + String.valueOf(object)));
            return Optional.empty();
        });
    }
}

