/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieSizeExceededException;
import io.micronaut.http.cookie.ServerCookieEncoder;

@Internal
public final class CookieUtils {
    private static final int COOKIE_BYTE_LIMIT = 4096;
    private static final String SET_COOKIE = "Set-Cookie";

    private CookieUtils() {
    }

    public static void verifyCookieSize(@NonNull Cookie cookie, @NonNull String cookieEncoded) {
        CookieUtils.verifyCookieSize(cookie, cookieEncoded, 4096);
    }

    public static void verifyCookieSize(@NonNull Cookie cookie, @NonNull String cookieEncoded, @NonNull Integer cookieByteLimit) {
        int byteCount = StringUtils.utf8Bytes(cookieEncoded);
        if (byteCount > cookieByteLimit) {
            throw new CookieSizeExceededException(cookie.getName(), cookieByteLimit, byteCount);
        }
    }

    public static void setCookieHeader(@NonNull MutableHttpHeaders headers, @NonNull Cookie cookie, @NonNull Integer cookieByteLimit) {
        ServerCookieEncoder.INSTANCE.encode(cookie).forEach(cookieEncoded -> {
            CookieUtils.verifyCookieSize(cookie, cookieEncoded, cookieByteLimit);
            headers.add((CharSequence)SET_COOKIE, (CharSequence)cookieEncoded);
        });
    }

    public static void setCookieHeader(@NonNull MutableHttpHeaders headers, @NonNull Cookie cookie) {
        CookieUtils.setCookieHeader(headers, cookie, 4096);
    }
}

