/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactivePropagation;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.CompletableFutureExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.type.UnsafeExecutable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.filter.BaseFilterProcessor;
import io.micronaut.http.filter.ConditionalFilter;
import io.micronaut.http.filter.FilterArgumentBinderPredicate;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.InternalHttpFilter;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.inject.ExecutableMethod;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.scheduler.NonBlocking;

@Internal
record MethodFilter<T>(FilterOrder order, T bean, Executable<T, ?> method, @Nullable UnsafeExecutable<T, ?> unsafeExecutable, boolean isResponseFilter, @Nullable FilterArgBinder @NonNull [] argBinders, @Nullable @Nullable AsyncFilterArgBinder @Nullable [] asyncArgBinders, @Nullable Predicate<FilterMethodContext> filterCondition, @Nullable ContinuationCreator continuationCreator, boolean filtersException, FilterReturnHandler returnHandler, boolean isConditional, Executor executor) implements InternalHttpFilter
{
    private static final Predicate<FilterMethodContext> FILTER_CONDITION_ALWAYS_TRUE = runner -> true;

    static <T> MethodFilter<T> prepareFilterMethod(ConversionService conversionService, T bean, ExecutableMethod<T, ?> method, boolean isResponseFilter, FilterOrder order, RequestBinderRegistry argumentBinderRegistry, @Nullable Executor executor) throws IllegalArgumentException {
        return MethodFilter.prepareFilterMethod(conversionService, bean, method, method.getArguments(), method.getReturnType().asArgument(), isResponseFilter, order, argumentBinderRegistry, executor);
    }

    static <T> MethodFilter<T> prepareFilterMethod(ConversionService conversionService, @Nullable T bean, @Nullable ExecutableMethod<T, ?> method, Argument<?>[] arguments, Argument<?> returnType, boolean isResponseFilter, FilterOrder order, RequestBinderRegistry argumentBinderRegistry, @Nullable Executor executor) throws IllegalArgumentException {
        UnsafeExecutable unsafeExecutable;
        FilterArgBinder[] fulfilled = new FilterArgBinder[arguments.length];
        AsyncFilterArgBinder[] asyncArgBinders = null;
        Predicate<FilterMethodContext> filterCondition = FILTER_CONDITION_ALWAYS_TRUE;
        boolean skipOnError = isResponseFilter;
        boolean filtersException = false;
        ContinuationCreator continuationCreator = null;
        for (int i = 0; i < arguments.length; ++i) {
            Argument<?> argument = arguments[i];
            Class argumentType = argument.getType();
            if (argumentType.isAssignableFrom(HttpRequest.class)) {
                fulfilled[i] = ctx -> ctx.request;
                continue;
            }
            if (argumentType.isAssignableFrom(ServerHttpRequest.class)) {
                fulfilled[i] = ctx -> (ServerHttpRequest)ctx.request;
                continue;
            }
            if (argumentType.isAssignableFrom(MutableHttpRequest.class)) {
                fulfilled[i] = ctx -> {
                    HttpRequest<?> request = ctx.request;
                    if (!(ctx.request instanceof MutableHttpRequest)) {
                        request = ctx.request.mutate();
                    }
                    return request;
                };
                continue;
            }
            if (argumentType.isAssignableFrom(MutableHttpResponse.class)) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Filter is called before the response is known, can't have a response argument");
                }
                fulfilled[i] = ctx -> ctx.response;
                continue;
            }
            if (Throwable.class.isAssignableFrom(argumentType)) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Request filters cannot handle exceptions");
                }
                if (!argument.isNullable()) {
                    filterCondition = filterCondition.and(ctx -> ctx.failure != null && argument.isInstance(ctx.failure));
                    fulfilled[i] = ctx -> ctx.failure;
                } else {
                    fulfilled[i] = ctx -> {
                        if (ctx.failure != null && argument.isInstance(ctx.failure)) {
                            return ctx.failure;
                        }
                        return null;
                    };
                }
                filtersException = true;
                skipOnError = false;
                continue;
            }
            if (argumentType == FilterContinuation.class) {
                if (isResponseFilter) {
                    throw new IllegalArgumentException("Response filters cannot use filter continuations");
                }
                if (continuationCreator != null) {
                    throw new IllegalArgumentException("Only one continuation per filter is allowed");
                }
                Argument<?> continuationReturnType = argument.getFirstTypeVariable().orElseThrow(() -> new IllegalArgumentException("Continuations must specify generic type"));
                if (MethodFilter.isReactive(continuationReturnType) && continuationReturnType.getWrappedType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = MethodFilter.isReactive(returnType) ? ResultAwareReactiveContinuationImpl::new : ReactiveContinuationImpl::new;
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                if (continuationReturnType.getType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = BlockingContinuationImpl::new;
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported continuation type: " + String.valueOf(continuationReturnType));
            }
            if (argumentType == MutablePropagatedContext.class) {
                fulfilled[i] = ctx -> ctx.mutablePropagatedContext;
                continue;
            }
            ArgumentBinder argumentBinder = argumentBinderRegistry.findArgumentBinder(argument).orElse(null);
            if (argumentBinder != null) {
                if (argumentBinder instanceof BaseFilterProcessor.AsyncBodyBinder) {
                    BaseFilterProcessor.AsyncBodyBinder async = (BaseFilterProcessor.AsyncBodyBinder)argumentBinder;
                    if (isResponseFilter) {
                        throw new IllegalArgumentException("Cannot bind @Body in response filter method [" + method.getDescription(true) + "]");
                    }
                    if (asyncArgBinders == null) {
                        asyncArgBinders = new AsyncFilterArgBinder[arguments.length];
                    }
                    asyncArgBinders[i] = ctx -> {
                        HttpRequest<?> request = ctx.request;
                        ArgumentConversionContext conversionContext = ConversionContext.of(argument);
                        return async.bindAsync(conversionContext, request).map(result -> MethodFilter.convertResult(method, argument, result));
                    };
                    continue;
                }
                fulfilled[i] = ctx -> {
                    HttpRequest<?> request = ctx.request;
                    ArgumentConversionContext conversionContext = ConversionContext.of(argument);
                    ArgumentBinder.BindingResult<Object> result = argumentBinder.bind(conversionContext, request);
                    return MethodFilter.convertResult(method, argument, result);
                };
                if (!(argumentBinder instanceof FilterArgumentBinderPredicate)) continue;
                FilterArgumentBinderPredicate pred = (FilterArgumentBinderPredicate)((Object)argumentBinder);
                filterCondition = filterCondition.and(ctx -> pred.test(argument, ctx.mutablePropagatedContext, ctx.request, ctx.response, ctx.failure));
                continue;
            }
            throw new IllegalArgumentException("Unsupported filter argument type: " + String.valueOf(argument));
        }
        if (skipOnError) {
            filterCondition = filterCondition.and(ctx -> ctx.failure == null);
        } else if (filterCondition == FILTER_CONDITION_ALWAYS_TRUE) {
            filterCondition = null;
        }
        FilterReturnHandler returnHandler = MethodFilter.prepareReturnHandler(conversionService, returnType, isResponseFilter, continuationCreator != null, false);
        return new MethodFilter<T>(order, bean, method, method instanceof UnsafeExecutable ? (unsafeExecutable = (UnsafeExecutable)((Object)method)) : null, isResponseFilter, fulfilled, asyncArgBinders, filterCondition, continuationCreator, filtersException, returnHandler, bean instanceof ConditionalFilter, executor);
    }

    private static <T> Object convertResult(@Nullable ExecutableMethod<T, ?> method, Argument<?> argument, ArgumentBinder.BindingResult<Object> result) {
        if (result.isPresentAndSatisfied() || argument.isNullable() && result.isSatisfied()) {
            return result.getValue().orElse(null);
        }
        List<ConversionError> conversionErrors = result.getConversionErrors();
        if (!conversionErrors.isEmpty()) {
            throw new ConversionErrorException(argument, conversionErrors.get(0));
        }
        throw new IllegalArgumentException("Unbindable argument [" + String.valueOf(argument) + "] to method [" + method.getDescription(true) + "]");
    }

    private static boolean isReactive(Argument<?> continuationReturnType) {
        return continuationReturnType.isReactive() || continuationReturnType.getType() == Publisher.class;
    }

    @Override
    public boolean isEnabled(HttpRequest<?> request) {
        if (this.isConditional) {
            return ((ConditionalFilter)this.bean).isEnabled(request);
        }
        return true;
    }

    @Override
    public boolean isFiltersRequest() {
        return !this.isResponseFilter;
    }

    @Override
    public boolean isFiltersResponse() {
        return this.isResponseFilter;
    }

    @Override
    public boolean hasContinuation() {
        return this.continuationCreator != null;
    }

    @Override
    public ExecutionFlow<FilterContext> processRequestFilter(FilterContext context) {
        if (this.continuationCreator != null) {
            throw new IllegalStateException("Downstream callback is required for filters with a continuation");
        }
        FilterMethodContext filterMethodContext = new FilterMethodContext(MutablePropagatedContext.of(context.propagatedContext()), context.request(), context.response(), null, null);
        return this.filter(context, filterMethodContext, null, false);
    }

    @Override
    public ExecutionFlow<FilterContext> processRequestFilter(FilterContext context, Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        if (this.continuationCreator == null) {
            throw new IllegalStateException("Downstream method shouldn't be called when continuation is missing!");
        }
        MutablePropagatedContext mutablePropagatedContext = MutablePropagatedContext.of(context.propagatedContext());
        FilterMethodContext filterMethodContext = new FilterMethodContext(mutablePropagatedContext, context.request(), context.response(), null, this.createContinuation(downstream, context, mutablePropagatedContext));
        return this.filter(context, filterMethodContext, null, false);
    }

    @Override
    public ExecutionFlow<FilterContext> processResponseFilter(FilterContext context, Throwable exceptionToFilter) {
        if (exceptionToFilter != null && !this.filtersException) {
            return ExecutionFlow.just(context);
        }
        if (this.continuationCreator != null) {
            return ExecutionFlow.error(new IllegalStateException("Response filter cannot have a continuation!"));
        }
        FilterMethodContext filterMethodContext = new FilterMethodContext(MutablePropagatedContext.of(context.propagatedContext()), context.request(), context.response(), exceptionToFilter, null);
        return this.filter(context, filterMethodContext, null, false);
    }

    @Override
    public int getOrder() {
        return this.order.getOrder(this.bean);
    }

    private InternalFilterContinuation<?> createContinuation(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
        return this.continuationCreator.create(downstream, filterContext, mutablePropagatedContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExecutionFlow<FilterContext> filter(FilterContext filterContext, FilterMethodContext methodContext, Object[] args, boolean onExecutor) {
        try (PropagatedContext.Scope ignore = filterContext.propagatedContext().propagate();){
            if (args == null) {
                if (this.filterCondition != null && !this.filterCondition.test(methodContext)) {
                    ExecutionFlow<FilterContext> executionFlow = ExecutionFlow.just(filterContext);
                    return executionFlow;
                }
                if (this.asyncArgBinders != null) {
                    ExecutionFlow<FilterContext> executionFlow = this.bindArgsAsync(methodContext).flatMap(a -> this.filter(filterContext, methodContext, (Object[])a, onExecutor));
                    return executionFlow;
                }
                try {
                    args = this.bindArgsSync(methodContext);
                }
                catch (Throwable e) {
                    ExecutionFlow<FilterContext> executionFlow = ExecutionFlow.error(e);
                    if (ignore == null) return executionFlow;
                    ignore.close();
                    return executionFlow;
                }
            }
            if (!onExecutor && this.executor != null) {
                Object[] finalArgs = args;
                ExecutionFlow<FilterContext> executionFlow = ExecutionFlow.async(this.executor, () -> this.filter(filterContext, methodContext, finalArgs, true));
                return executionFlow;
            }
            Object returnValue = this.unsafeExecutable != null ? this.unsafeExecutable.invokeUnsafe(this.bean, args) : this.method.invoke(this.bean, args);
            ExecutionFlow<FilterContext> executionFlow = this.returnHandler.handle(filterContext, returnValue, methodContext.continuation);
            PropagatedContext mutatedPropagatedContext = methodContext.mutablePropagatedContext.getContext();
            if (mutatedPropagatedContext != filterContext.propagatedContext()) {
                executionFlow = executionFlow.map(fc -> fc.withPropagatedContext(mutatedPropagatedContext));
            }
            ExecutionFlow<FilterContext> executionFlow2 = executionFlow;
            return executionFlow2;
        }
        catch (Throwable e) {
            return ExecutionFlow.error(e);
        }
    }

    private Object[] bindArgsSync(FilterMethodContext context) {
        Object[] args = new Object[this.argBinders.length];
        for (int i = 0; i < args.length; ++i) {
            FilterArgBinder binder = this.argBinders[i];
            if (binder == null) continue;
            args[i] = binder.bind(context);
        }
        return args;
    }

    private ExecutionFlow<Object[]> bindArgsAsync(FilterMethodContext context) {
        Object[] args;
        assert (this.asyncArgBinders != null);
        try {
            args = this.bindArgsSync(context);
        }
        catch (Throwable e) {
            return ExecutionFlow.error(e);
        }
        ExecutionFlow<Object> result = ExecutionFlow.just(args);
        for (int i = 0; i < this.asyncArgBinders.length; ++i) {
            AsyncFilterArgBinder binder = this.asyncArgBinders[i];
            if (binder == null) continue;
            int position = i;
            result = result.flatMap(a -> binder.bind(context).map(arg -> {
                args[position] = arg;
                return args;
            }));
        }
        return result.map(o -> args);
    }

    private static FilterReturnHandler prepareReturnHandler(ConversionService conversionService, Argument<?> type, boolean isResponseFilter, boolean hasContinuation, boolean fromOptional) throws IllegalArgumentException {
        boolean nullable;
        if (type.isOptional()) {
            FilterReturnHandler next = MethodFilter.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, true);
            return (r, o, c) -> next.handle(r, o == null ? null : ((Optional)o).orElse(null), c);
        }
        if (type.isVoid()) {
            if (hasContinuation) {
                return FilterReturnHandler.VOID_WITH_CONTINUATION;
            }
            return FilterReturnHandler.VOID;
        }
        boolean bl = nullable = type.isNullable() || fromOptional;
        if (!isResponseFilter) {
            if (type.getType() == HttpRequest.class || type.getType() == MutableHttpRequest.class) {
                if (hasContinuation) {
                    throw new IllegalArgumentException("Filter method that accepts a continuation cannot return an HttpRequest");
                }
                if (nullable) {
                    return FilterReturnHandler.REQUEST_NULLABLE;
                }
                return FilterReturnHandler.REQUEST;
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (nullable) {
                    return FilterReturnHandler.FROM_REQUEST_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_REQUEST_RESPONSE;
            }
        } else {
            if (hasContinuation) {
                throw new AssertionError();
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (nullable) {
                    return FilterReturnHandler.FROM_RESPONSE_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_RESPONSE_RESPONSE;
            }
        }
        if (MethodFilter.isReactive(type)) {
            FilterReturnHandler next = MethodFilter.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return (context, returnValue, continuation) -> {
                if (returnValue == null && !nullable) {
                    return next.handle(context, null, continuation);
                }
                Publisher converted = Publishers.convertToPublisher(conversionService, returnValue);
                if (continuation instanceof ResultAwareContinuation) {
                    ResultAwareContinuation resultAwareContinuation = (ResultAwareContinuation)continuation;
                    return resultAwareContinuation.processResult(ReactivePropagation.propagate(context.propagatedContext(), converted));
                }
                return ReactiveExecutionFlow.fromPublisherEager(converted, context.propagatedContext()).flatMap(v -> {
                    try {
                        return next.handle(context, v, continuation);
                    }
                    catch (Throwable e) {
                        return ExecutionFlow.error(e);
                    }
                });
            };
        }
        if (type.isAsync()) {
            FilterReturnHandler next = MethodFilter.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return new DelayedFilterReturnHandler(isResponseFilter, next, nullable){

                @Override
                protected ExecutionFlow<?> toFlow(FilterContext context, Object returnValue, InternalFilterContinuation<?> continuation) {
                    return CompletableFutureExecutionFlow.just(((CompletionStage)returnValue).toCompletableFuture());
                }
            };
        }
        throw new IllegalArgumentException("Unsupported filter return type " + type.getType().getName());
    }

    private static interface FilterArgBinder {
        public Object bind(FilterMethodContext var1);
    }

    private static interface AsyncFilterArgBinder {
        public ExecutionFlow<Object> bind(FilterMethodContext var1);
    }

    private static interface ContinuationCreator {
        public InternalFilterContinuation<?> create(Function<FilterContext, ExecutionFlow<FilterContext>> var1, FilterContext var2, MutablePropagatedContext var3);
    }

    private static interface FilterReturnHandler {
        public static final FilterReturnHandler VOID_WITH_CONTINUATION = (filterContext, returnValue, continuation) -> ExecutionFlow.just(continuation.afterMethodContext());
        public static final FilterReturnHandler VOID = (filterContext, returnValue, continuation) -> ExecutionFlow.just(filterContext);
        public static final FilterReturnHandler REQUEST = (filterContext, returnValue, continuation) -> ExecutionFlow.just(filterContext.withRequest((HttpRequest)Objects.requireNonNull(returnValue, "Returned request must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler REQUEST_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just(filterContext);
            }
            return ExecutionFlow.just(filterContext.withRequest((HttpRequest)returnValue));
        };
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just(filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just(filterContext);
            }
            return ExecutionFlow.just(filterContext.withResponse((HttpResponse)returnValue));
        };
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just(filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just(filterContext);
            }
            return ExecutionFlow.just(filterContext.withResponse((HttpResponse)returnValue));
        };

        public ExecutionFlow<FilterContext> handle(FilterContext var1, @Nullable Object var2, @Nullable InternalFilterContinuation<?> var3) throws Throwable;
    }

    private record FilterMethodContext(MutablePropagatedContext mutablePropagatedContext, HttpRequest<?> request, @Nullable HttpResponse<?> response, @Nullable Throwable failure, @Nullable InternalFilterContinuation<?> continuation) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface InternalFilterContinuation<R>
    extends FilterContinuation<R> {
        public FilterContext afterMethodContext();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ResultAwareContinuation<T>
    extends InternalFilterContinuation<T> {
        public ExecutionFlow<FilterContext> processResult(T var1);
    }

    private static final class BlockingContinuationImpl
    implements FilterContinuation<HttpResponse<?>>,
    InternalFilterContinuation<HttpResponse<?>> {
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private FilterContext filterContext;
        private final MutablePropagatedContext mutablePropagatedContext;

        private BlockingContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
            this.mutablePropagatedContext = mutablePropagatedContext;
        }

        @Override
        public FilterContinuation<HttpResponse<?>> request(HttpRequest<?> request) {
            PropagatedContext mutatedPropagatedContext;
            this.filterContext = this.filterContext.withRequest(request);
            PropagatedContext propagatedContext = this.filterContext.propagatedContext();
            this.filterContext = propagatedContext != (mutatedPropagatedContext = this.mutablePropagatedContext.getContext()) ? this.filterContext.withPropagatedContext(mutatedPropagatedContext) : this.filterContext.withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext()));
            return new BlockingContinuationImpl(this.downstream, this.filterContext, this.mutablePropagatedContext);
        }

        @Override
        public HttpResponse<?> proceed() {
            if (Thread.currentThread() instanceof NonBlocking) {
                throw new IllegalStateException("Cannot use blocking continuation on non-blocking thread. Please mark the filter to run on another thread with @ExecuteOn, or use a reactive continuation.");
            }
            boolean interrupted = false;
            while (true) {
                try {
                    this.filterContext = this.downstream.apply(this.filterContext).toCompletableFuture().get();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.filterContext.response();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)cause;
                        throw re;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }

        @Override
        public FilterContext afterMethodContext() {
            return this.filterContext;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static class ReactiveContinuationImpl
    implements FilterContinuation<Publisher<HttpResponse<?>>>,
    InternalFilterContinuation<Publisher<HttpResponse<?>>> {
        protected FilterContext filterContext;
        private final Function<FilterContext, ExecutionFlow<FilterContext>> downstream;
        private final MutablePropagatedContext mutablePropagatedContext;

        private ReactiveContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> downstream, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            this.downstream = downstream;
            this.filterContext = filterContext;
            this.mutablePropagatedContext = mutablePropagatedContext;
        }

        @Override
        public FilterContinuation<Publisher<HttpResponse<?>>> request(HttpRequest<?> request) {
            return new ReactiveContinuationImpl(this.downstream, this.filterContext.withRequest(request), this.mutablePropagatedContext);
        }

        @Override
        public Publisher<HttpResponse<?>> proceed() {
            PropagatedContext mutatedPropagatedContext;
            PropagatedContext propagatedContext = this.filterContext.propagatedContext();
            this.filterContext = propagatedContext != (mutatedPropagatedContext = this.mutablePropagatedContext.getContext()) ? this.filterContext.withPropagatedContext(mutatedPropagatedContext) : this.filterContext.withPropagatedContext(PropagatedContext.find().orElse(this.filterContext.propagatedContext()));
            return ReactiveExecutionFlow.fromFlow(this.downstream.apply(this.filterContext).map(newFilterContext -> {
                this.filterContext = newFilterContext;
                return newFilterContext.response();
            })).toPublisher();
        }

        @Override
        public FilterContext afterMethodContext() {
            return this.filterContext;
        }
    }

    private static final class ResultAwareReactiveContinuationImpl
    extends ReactiveContinuationImpl
    implements ResultAwareContinuation<Publisher<HttpResponse<?>>> {
        private ResultAwareReactiveContinuationImpl(Function<FilterContext, ExecutionFlow<FilterContext>> next, FilterContext filterContext, MutablePropagatedContext mutablePropagatedContext) {
            super(next, filterContext, mutablePropagatedContext);
        }

        @Override
        public ExecutionFlow<FilterContext> processResult(Publisher<HttpResponse<?>> publisher) {
            return ReactiveExecutionFlow.fromPublisher(publisher).map(httpResponse -> this.filterContext.withResponse((HttpResponse<?>)httpResponse));
        }
    }

    private static abstract class DelayedFilterReturnHandler
    implements FilterReturnHandler {
        final boolean isResponseFilter;
        final FilterReturnHandler next;
        final boolean nullable;

        private DelayedFilterReturnHandler(boolean isResponseFilter, FilterReturnHandler next, boolean nullable) {
            this.isResponseFilter = isResponseFilter;
            this.next = next;
            this.nullable = nullable;
        }

        protected abstract ExecutionFlow<?> toFlow(FilterContext var1, Object var2, @Nullable InternalFilterContinuation<?> var3);

        @Override
        public ExecutionFlow<FilterContext> handle(FilterContext context, @Nullable Object returnValue, InternalFilterContinuation<?> continuation) throws Throwable {
            if (returnValue == null && this.nullable) {
                return this.next.handle(context, null, continuation);
            }
            ExecutionFlow<?> delayedFlow = this.toFlow(context, Objects.requireNonNull(returnValue, "Returned value must not be null, or mark the method as @Nullable"), continuation);
            ImperativeExecutionFlow<?> doneFlow = delayedFlow.tryComplete();
            if (doneFlow != null) {
                if (doneFlow.getError() != null) {
                    throw doneFlow.getError();
                }
                return this.next.handle(context, doneFlow.getValue(), continuation);
            }
            return delayedFlow.flatMap(v -> {
                try {
                    return this.next.handle(context, v, continuation);
                }
                catch (Throwable e) {
                    return ExecutionFlow.error(e);
                }
            });
        }
    }
}

