/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieUtils;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Internal
@TypeHint(value={NettyMutableHttpResponse.class})
public final class NettyMutableHttpResponse<B>
implements MutableHttpResponse<B>,
NettyHttpResponseBuilder {
    private final HttpVersion httpVersion;
    private HttpResponseStatus httpResponseStatus;
    private final NettyHttpHeaders headers;
    private Object body;
    private Optional<Object> optionalBody;
    private final io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private final io.netty.handler.codec.http.HttpHeaders trailingNettyHeaders;
    private final DecoderResult decoderResult;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();
    private MessageBodyWriter<B> messageBodyWriter;

    public NettyMutableHttpResponse(FullHttpResponse nettyResponse, ConversionService conversionService) {
        this(nettyResponse.protocolVersion(), nettyResponse.status(), nettyResponse.headers(), nettyResponse.trailingHeaders(), nettyResponse.content(), nettyResponse.decoderResult(), conversionService);
    }

    public NettyMutableHttpResponse(ConversionService conversionService) {
        this(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, null, body, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, io.netty.handler.codec.http.HttpHeaders nettyHeaders, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, nettyHeaders, EmptyHttpHeaders.INSTANCE, body, null, conversionService);
    }

    private NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, io.netty.handler.codec.http.HttpHeaders nettyHeaders, io.netty.handler.codec.http.HttpHeaders trailingNettyHeaders, Object body, DecoderResult decoderResult, ConversionService conversionService) {
        boolean hasHeaders;
        this.httpVersion = httpVersion;
        this.httpResponseStatus = httpResponseStatus;
        this.trailingNettyHeaders = trailingNettyHeaders;
        this.decoderResult = decoderResult;
        this.conversionService = conversionService;
        boolean bl = hasHeaders = nettyHeaders != null;
        if (!hasHeaders) {
            nettyHeaders = new DefaultHttpHeaders(false);
        }
        this.nettyHeaders = nettyHeaders;
        this.headers = new NettyHttpHeaders(nettyHeaders, conversionService);
        if (body == null) {
            this.body = null;
            this.optionalBody = Optional.empty();
        } else {
            this.body = body;
            this.optionalBody = Optional.of(body);
            Optional<MediaType> mediaType = MediaType.fromType(body.getClass());
            if (!(!mediaType.isPresent() || hasHeaders && nettyHeaders.contains(HttpHeaderNames.CONTENT_TYPE))) {
                this.contentType(mediaType.get());
            }
        }
    }

    @NonNull
    public static io.netty.handler.codec.http.HttpResponse toNoBodyResponse(@NonNull HttpResponse<?> response) {
        io.netty.handler.codec.http.HttpHeaders nettyHeaders;
        HttpResponseStatus status;
        HttpVersion version;
        Objects.requireNonNull(response, "The response cannot be null");
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        if (response instanceof NettyMutableHttpResponse) {
            NettyMutableHttpResponse nmhr = (NettyMutableHttpResponse)response;
            version = nmhr.getNettyHttpVersion();
            status = nmhr.getNettyHttpStatus();
        } else {
            version = HttpVersion.HTTP_1_1;
            status = new HttpResponseStatus(response.code(), response.reason());
        }
        HttpHeaders mnHeaders = response.getHeaders();
        if (mnHeaders instanceof NettyHttpHeaders) {
            NettyHttpHeaders nhh = (NettyHttpHeaders)mnHeaders;
            nettyHeaders = nhh.getNettyHeaders();
        } else {
            nettyHeaders = new DefaultHttpHeaders();
            response.getHeaders().forEach((s2, strings) -> nettyHeaders.add((String)s2, (Iterable<?>)strings));
        }
        return new DefaultHttpResponse(version, status, nettyHeaders);
    }

    @Override
    public Optional<MessageBodyWriter<B>> getBodyWriter() {
        return Optional.ofNullable(this.messageBodyWriter);
    }

    @Override
    public MutableHttpMessage<B> bodyWriter(MessageBodyWriter<B> messageBodyWriter) {
        this.messageBodyWriter = messageBodyWriter;
        return this;
    }

    public HttpVersion getNettyHttpVersion() {
        return this.httpVersion;
    }

    public HttpResponseStatus getNettyHttpStatus() {
        return this.httpResponseStatus;
    }

    public io.netty.handler.codec.http.HttpHeaders getNettyHeaders() {
        return this.nettyHeaders;
    }

    public String toString() {
        return this.code() + " " + this.reason();
    }

    @Override
    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues<Object> attributes = this.attributes;
        if (attributes == null) {
            NettyMutableHttpResponse nettyMutableHttpResponse = this;
            synchronized (nettyMutableHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap<Object>(new HashMap(4));
                }
            }
        }
        return attributes;
    }

    @Override
    public HttpResponse<B> setAttribute(CharSequence name, Object value) {
        if (StringUtils.isNotEmpty(name)) {
            if (value == null) {
                this.getAttributes().remove(name.toString());
            } else {
                this.getAttributes().put(name.toString(), value);
            }
        }
        return this;
    }

    @Override
    public int code() {
        return this.httpResponseStatus.code();
    }

    @Override
    public String reason() {
        return this.httpResponseStatus.reasonPhrase();
    }

    @Override
    public MutableHttpResponse<B> cookie(Cookie cookie) {
        CookieUtils.setCookieHeader(this.headers, cookie);
        return this;
    }

    @Override
    public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return this;
        }
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    @Override
    public Cookies getCookies() {
        return new NettyCookies(this.nettyHeaders, this.conversionService);
    }

    @Override
    public Optional<Cookie> getCookie(String name) {
        return this.getCookies().findCookie(name);
    }

    @Override
    public Optional<B> getBody() {
        return this.optionalBody;
    }

    @Override
    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    @Override
    public <T> Optional<T> getBody(ArgumentConversionContext<T> conversionContext) {
        return this.bodyConvertor.convert(conversionContext, this.body);
    }

    @Override
    public MutableHttpResponse<B> status(int status, CharSequence message) {
        if (message == null) {
            message = HttpStatus.getDefaultReason(status);
        }
        this.httpResponseStatus = new HttpResponseStatus(status, message.toString());
        return this;
    }

    @Override
    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (this.body != body) {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)object;
                buf.release();
            }
            this.setBody(body);
            this.bodyConvertor.cleanup();
        }
        return this;
    }

    @Override
    public MutableHttpResponse<B> contentType(MediaType mediaType) {
        this.headers.contentType(mediaType);
        return this;
    }

    @Override
    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf;
                content = buf = (ByteBuf)object;
            } else {
                throw new IllegalStateException("Body needs to be converted to ByteBuf from " + String.valueOf(this.body.getClass()));
            }
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.httpVersion, this.httpResponseStatus, content, this.nettyHeaders, this.trailingNettyHeaders);
        if (this.decoderResult != null) {
            defaultFullHttpResponse.setDecoderResult(this.decoderResult);
        }
        return defaultFullHttpResponse;
    }

    @Override
    @NonNull
    public StreamedHttpResponse toStreamHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf;
                content = buf = (ByteBuf)object;
            } else {
                throw new IllegalStateException("Body needs to be converted to ByteBuf from " + String.valueOf(this.body.getClass()));
            }
        }
        DefaultStreamedHttpResponse streamedHttpResponse = new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, this.httpResponseStatus, true, Publishers.just(new DefaultLastHttpContent(content)));
        streamedHttpResponse.headers().setAll(this.nettyHeaders);
        return streamedHttpResponse;
    }

    @Override
    @NonNull
    public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        return this.toFullHttpResponse();
    }

    @Override
    public boolean isStream() {
        return false;
    }

    private void setBody(Object body) {
        this.body = body;
        this.optionalBody = Optional.ofNullable(body);
        Optional<MediaType> contentType = this.getContentType();
        if (!contentType.isPresent() && body != null) {
            MediaType.fromType(body.getClass()).ifPresent(mediaType -> this.contentType((MediaType)mediaType));
        }
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(ArgumentConversionContext conversionContext, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(conversionContext.getArgument())) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyMutableHttpResponse.this.conversionService, conversionContext, value);
            }
        };
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(ArgumentConversionContext<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final ArgumentConversionContext<T> conversionContext, T value) {
            if (this.nextConvertor == null) {
                Optional<T> conversion;
                if (value instanceof ByteBuffer) {
                    ByteBuffer buffer = (ByteBuffer)value;
                    conversion = conversionService.convert(buffer.asNativeBuffer(), conversionContext);
                } else {
                    conversion = conversionService.convert(value, conversionContext);
                }
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(ArgumentConversionContext<T> currentConversionContext, T value) {
                        if (currentConversionContext == conversionContext) {
                            return conversion;
                        }
                        if (currentConversionContext.getArgument().equalsType(conversionContext.getArgument())) {
                            conversionContext.getLastError().ifPresent(error -> error.getOriginalValue().ifPresentOrElse(originalValue -> currentConversionContext.reject(originalValue, error.getCause()), () -> currentConversionContext.reject(error.getCause())));
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, currentConversionContext, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionContext, value);
        }

        public void cleanup() {
            this.nextConvertor = null;
        }
    }
}

