/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.body.stream.PublisherAsBlocking;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

@Internal
public final class PublisherAsStream
extends InputStream {
    private final PublisherAsBlocking<ByteBuf> publisherAsBlocking;
    private ByteBuf buffer;

    public PublisherAsStream(PublisherAsBlocking<ByteBuf> publisherAsBlocking) {
        this.publisherAsBlocking = publisherAsBlocking;
    }

    @Override
    public int read() throws IOException {
        byte[] arr = new byte[1];
        int n = this.read(arr);
        return n == -1 ? -1 : arr[0] & 0xFF;
    }

    @Override
    public int read(byte @NonNull [] b, int off, int len) throws IOException {
        while (this.buffer == null) {
            try {
                ByteBuf o = this.publisherAsBlocking.take();
                if (o == null) {
                    Throwable failure = this.publisherAsBlocking.getFailure();
                    if (failure == null) {
                        return -1;
                    }
                    throw new IOException(failure);
                }
                if (o.readableBytes() == 0) {
                    o.release();
                    continue;
                }
                this.buffer = o;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        int toRead = Math.min(len, this.buffer.readableBytes());
        this.buffer.readBytes(b, off, toRead);
        if (this.buffer.readableBytes() == 0) {
            this.buffer.release();
            this.buffer = null;
        }
        return toRead;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
        this.publisherAsBlocking.close();
    }
}

