/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.core.publisher.Flux;

@Internal
public final class AvailableNettyByteBody
extends NettyByteBody
implements CloseableAvailableByteBody {
    private final long length;
    @Nullable
    private ByteBuf buffer;

    public AvailableNettyByteBody(@NonNull ByteBuf buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        this.length = buffer.readableBytes();
    }

    public static CloseableAvailableByteBody empty() {
        return new AvailableNettyByteBody(Unpooled.EMPTY_BUFFER);
    }

    @NonNull
    public static ByteBuf toByteBuf(@NonNull AvailableByteBody body) {
        if (body instanceof AvailableNettyByteBody) {
            AvailableNettyByteBody net = (AvailableNettyByteBody)body;
            return net.claim();
        }
        return Unpooled.wrappedBuffer(body.toByteArray());
    }

    @NonNull
    public static CloseableByteBody createChecked(@NonNull EventLoop loop, @NonNull BodySizeLimits bodySizeLimits, @NonNull ByteBuf buf) {
        int readable = buf.readableBytes();
        if ((long)readable > bodySizeLimits.maxBodySize() || (long)readable > bodySizeLimits.maxBufferSize()) {
            BufferConsumer.Upstream upstream = bytesConsumed -> {};
            StreamingNettyByteBody.SharedBuffer mockBuffer = new StreamingNettyByteBody.SharedBuffer(loop, bodySizeLimits, upstream);
            mockBuffer.add(buf);
            return new StreamingNettyByteBody(mockBuffer);
        }
        return new AvailableNettyByteBody(buf);
    }

    public ByteBuf peek() {
        ByteBuf b = this.buffer;
        if (b == null) {
            throw new IllegalStateException("Body already claimed.");
        }
        return b;
    }

    @Override
    @NonNull
    public InputStream toInputStream() {
        return new ByteBufInputStream(this.claim(), true);
    }

    @Override
    public long length() {
        return this.length;
    }

    @NonNull
    private ByteBuf claim() {
        ByteBuf b = this.buffer;
        if (b == null) {
            BaseSharedBuffer.failClaim();
        }
        this.buffer = null;
        BaseSharedBuffer.logClaim();
        return b;
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        return ExecutionFlow.just(new AvailableNettyByteBody(this.claim()));
    }

    @Override
    public void close() {
        ByteBuf b = this.buffer;
        this.buffer = null;
        if (b != null) {
            b.release();
        }
    }

    @Override
    protected Flux<ByteBuf> toByteBufPublisher() {
        return Flux.just(this.claim());
    }

    @Override
    public byte @NonNull [] toByteArray() {
        ByteBuf b = this.claim();
        try {
            byte[] byArray = ByteBufUtil.getBytes(b);
            return byArray;
        }
        finally {
            b.release();
        }
    }

    @Override
    @NonNull
    public ByteBuffer<?> toByteBuffer() {
        return NettyByteBufferFactory.DEFAULT.wrap(this.claim());
    }

    @Override
    @NonNull
    public CloseableByteBody move() {
        return new AvailableNettyByteBody(this.claim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String toString(Charset charset) {
        ByteBuf b = this.claim();
        try {
            String string = b.toString(charset);
            return string;
        }
        finally {
            b.release();
        }
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody split() {
        ByteBuf b = this.buffer;
        if (b == null) {
            BaseSharedBuffer.failClaim();
        }
        return new AvailableNettyByteBody(b.retainedSlice());
    }
}

