/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class NettyByteBody
implements ByteBody,
InternalByteBody {
    protected static final Logger LOG = LoggerFactory.getLogger(ByteBody.class);

    public static Flux<ByteBuf> toByteBufs(ByteBody body) {
        if (body instanceof NettyByteBody) {
            NettyByteBody net = (NettyByteBody)body;
            return net.toByteBufPublisher();
        }
        return Flux.from(body.toByteArrayPublisher()).map(Unpooled::wrappedBuffer);
    }

    @Override
    @NonNull
    public Publisher<byte[]> toByteArrayPublisher() {
        return this.toByteBufPublisher().map(bb -> {
            try {
                byte[] byArray = ByteBufUtil.getBytes(bb);
                return byArray;
            }
            finally {
                bb.release();
            }
        });
    }

    @Override
    @NonNull
    public Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return this.toByteBufPublisher().map(NettyByteBufferFactory.DEFAULT::wrap);
    }

    @Override
    @NonNull
    public abstract ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow();

    abstract Flux<ByteBuf> toByteBufPublisher();
}

