/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.util.functional.ThrowingConsumer;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Internal
public final class NettyByteBodyFactory
extends ByteBodyFactory {
    public NettyByteBodyFactory(@NonNull Channel channel) {
        super(new NettyByteBufferFactory(channel.alloc()));
    }

    private ByteBufAllocator alloc() {
        return (ByteBufAllocator)this.byteBufferFactory().getNativeAllocator();
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody adapt(@NonNull ByteBuffer<?> buffer) {
        Object obj = buffer.asNativeBuffer();
        if (obj instanceof ByteBuf) {
            ByteBuf bb = (ByteBuf)obj;
            return new AvailableNettyByteBody(bb);
        }
        return super.adapt(buffer);
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody adapt(byte @NonNull [] array) {
        return new AvailableNettyByteBody(Unpooled.wrappedBuffer(array));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T extends Throwable> CloseableAvailableByteBody buffer(@NonNull ThrowingConsumer<? super OutputStream, T> writer) throws T {
        ByteBuf buf = this.alloc().buffer();
        boolean release = true;
        try {
            ByteBufOutputStream s2 = new ByteBufOutputStream(buf);
            writer.accept(s2);
            try {
                s2.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close buffer stream", e);
            }
            release = false;
            AvailableNettyByteBody availableNettyByteBody = new AvailableNettyByteBody(buf);
            return availableNettyByteBody;
        }
        finally {
            if (release) {
                buf.release();
            }
        }
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody createEmpty() {
        return AvailableNettyByteBody.empty();
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        ByteBuf byteBuf = charset == StandardCharsets.UTF_8 ? ByteBufUtil.writeUtf8(this.alloc(), cs) : ByteBufUtil.encodeString(this.alloc(), CharBuffer.wrap(cs), charset);
        return new AvailableNettyByteBody(byteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull InputStream stream) throws IOException {
        ByteBuf buffer = this.alloc().buffer();
        boolean free = true;
        try {
            while (buffer.writeBytes(stream, 4096) != -1) {
            }
            free = false;
            AvailableNettyByteBody availableNettyByteBody = new AvailableNettyByteBody(buffer);
            return availableNettyByteBody;
        }
        finally {
            if (free) {
                buffer.release();
            }
        }
    }
}

