/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.channel.loom.PrivateLoomSupport;
import io.micronaut.scheduling.LoomSupport;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorFactory;
import io.netty.util.concurrent.FastThreadLocal;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;

@Internal
@Factory
@Requirements(value={@Requires(condition=LoomSupport.LoomCondition.class), @Requires(condition=PrivateLoomSupport.PrivateLoomCondition.class)})
final class EventLoopLoomFactory {
    final FastThreadLocal<ThreadFactory> targetScheduler = new FastThreadLocal();

    EventLoopLoomFactory() {
    }

    @Named(value="virtual")
    @Singleton
    @Replaces(value=ThreadFactory.class, factory=ExecutorFactory.class, named="virtual")
    ThreadFactory eventLoopGroupThreadFactory(@Named(value="virtual") ExecutorConfiguration configuration) {
        if (!configuration.isVirtual()) {
            throw new IllegalStateException("Virtual executor should be virtual");
        }
        ThreadFactory delegate = LoomSupport.newVirtualThreadFactory("virtual-executor-");
        return r -> {
            ThreadFactory targetScheduler = this.targetScheduler.get();
            if (targetScheduler == null) {
                return delegate.newThread(r);
            }
            return targetScheduler.newThread(r);
        };
    }
}

