/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.loom.DelegateIoHandler;
import io.micronaut.http.netty.channel.loom.EventLoopLoomFactory;
import io.micronaut.http.netty.channel.loom.EventLoopVirtualThreadScheduler;
import io.micronaut.http.netty.channel.loom.LoomCarrierConfiguration;
import io.micronaut.http.netty.channel.loom.PrivateLoomSupport;
import io.micronaut.scheduling.LoomSupport;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ManualIoEventLoop;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.util.AttributeMap;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import jakarta.inject.Singleton;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.StackTrace;

@Internal
public final class LoomCarrierGroup
extends MultiThreadIoEventLoopGroup {
    private List<Runner> runners;

    private LoomCarrierGroup(Factory factory, int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory) {
        super(nThreads, executor, ioHandlerFactory, factory);
    }

    @Override
    protected IoEventLoop newChild(Executor executor, IoHandlerFactory ioHandlerFactory, Object ... args) {
        if (this.runners == null) {
            this.runners = new ArrayList<Runner>();
        }
        Runner runner = new Runner(this.runners.size(), (Factory)args[0], ioHandlerFactory);
        this.runners.add(runner);
        executor.execute(runner);
        return runner.delegate;
    }

    final class Runner
    implements Runnable,
    EventLoopVirtualThreadScheduler,
    ThreadFactory {
        final int id;
        final Factory factory;
        final ManualIoEventLoop delegate;
        final AttributeMap attributeMap = new DefaultAttributeMap();
        IoHandler backingHandler;
        Thread carrier;
        Runnable ioContinuation;
        volatile boolean ioContinuationScheduled;
        final Queue<Runnable> globalLoomQueue = new MpscUnboundedArrayQueue<Runnable>(4096);
        final Deque<ScheduledTask> localLoomQueue = new ArrayDeque<ScheduledTask>();
        volatile boolean loomNested;
        volatile boolean expediteWrite = false;
        volatile boolean block;
        boolean continuationsFifo = false;
        long continuationTime = 0L;
        boolean throughputMode = false;
        boolean idle = false;
        volatile int activeThreadsLocal = 0;
        final AtomicInteger activeThreadsExternal = new AtomicInteger();
        int warmupTasks;

        Runner(int id, Factory factory, IoHandlerFactory ioHandlerFactory) {
            this.id = id;
            this.factory = factory;
            this.warmupTasks = factory.configuration.normalWarmupTasks();
            IoHandlerFactory proxied = ioExecutor -> {
                this.backingHandler = ioHandlerFactory.newHandler(ioExecutor);
                return new DelegateIoHandler(this.backingHandler){

                    @Override
                    public void wakeup() {
                        Thread thread;
                        if (Runner.this.block) {
                            Runner.this.block = false;
                            super.wakeup();
                        }
                        if (Runner.this.isOnRunner(thread = Thread.currentThread()) && !Runner.this.throughputMode) {
                            Runner.this.expediteWrite = true;
                            Thread.yield();
                        }
                    }
                };
            };
            this.delegate = new ManualIoEventLoop(null, proxied);
        }

        @Override
        @NonNull
        public AttributeMap attributeMap() {
            return this.attributeMap;
        }

        @Override
        public EventExecutor eventLoop() {
            return this.delegate;
        }

        private boolean isOnRunner(Thread thread) {
            return LoomSupport.isVirtual(thread) && PrivateLoomSupport.getScheduler(thread) == this;
        }

        int activeThreads() {
            return this.activeThreadsLocal + this.activeThreadsExternal.get();
        }

        @Override
        public Thread newThread(Runnable r) {
            return LoomSupport.unstarted("loom-on-netty-" + this.id + "-" + Long.toHexString(ThreadLocalRandom.current().nextLong()), b -> {
                if (this.warmupTasks > 0) {
                    --this.warmupTasks;
                    PrivateLoomSupport.setScheduler(b, PrivateLoomSupport.getDefaultScheduler());
                    return;
                }
                Runner dst = this;
                int active = this.activeThreads();
                if (active >= this.factory.configuration.workSpillThreshold()) {
                    for (Runner runner : LoomCarrierGroup.this.runners) {
                        int a = runner.activeThreads();
                        if (a >= active) continue;
                        dst = runner;
                        active = a;
                    }
                }
                PrivateLoomSupport.setScheduler(b, new StickyScheduler(dst));
            }, r);
        }

        @Override
        public void run() {
            this.carrier = Thread.currentThread();
            LoomSupport.unstarted("loom-on-netty-" + this.id + "-io", b -> PrivateLoomSupport.setScheduler(b, this::executeIo), () -> FastThreadLocalThread.runWithFastThreadLocal(this::runIo)).start();
            assert (this.ioContinuationScheduled);
            while (!this.delegate.isTerminated()) {
                boolean ioContinuationScheduled = this.ioContinuationScheduled;
                if (!ioContinuationScheduled) {
                    LockSupport.park();
                    ioContinuationScheduled = this.ioContinuationScheduled;
                }
                if (ioContinuationScheduled) {
                    this.ioContinuationScheduled = false;
                    this.ioContinuation.run();
                }
                this.tick(3);
                this.globalToLocal();
                boolean bl = this.throughputMode = this.localLoomQueue.size() > this.factory.configuration.throughputModeThreshold();
                if (!this.runContinuations(null, System.nanoTime() + this.timeSlice()) && !this.expediteWrite) continue;
                this.block = false;
            }
        }

        private void runIo() {
            this.delegate.setOwningThread(Thread.currentThread());
            ThreadExecutorMap.setCurrentExecutor(this.delegate);
            this.factory.holder.targetScheduler.set(this);
            while (!this.delegate.isShuttingDown()) {
                long waitNanos;
                if (this.block) {
                    waitNanos = this.factory.configuration.blockTime().toNanos();
                    this.idle = true;
                    this.tick(1);
                } else {
                    waitNanos = -1L;
                    this.tick(2);
                }
                this.block = this.delegate.run(waitNanos, this.timeSlice()) == 0;
                this.idle = false;
                this.expediteWrite = false;
                Thread.yield();
                this.tick(4);
                if (this.delegate.runNonBlockingTasks(this.timeSlice()) == 0) continue;
                this.block = false;
            }
            while (!this.delegate.isTerminated()) {
                this.delegate.runNow(-1L);
                Thread.yield();
            }
        }

        private void globalToLocal() {
            Runnable task;
            while ((task = this.globalLoomQueue.poll()) != null) {
                this.localLoomQueue.addFirst(new ScheduledTask(System.nanoTime(), task));
            }
        }

        private long timeSlice() {
            return (this.throughputMode ? this.factory.configuration.timeSliceThroughput() : this.factory.configuration.timeSliceLatency()).toNanos();
        }

        private boolean runContinuations(@Nullable Runnable immediateTask, long deadline) {
            long now;
            assert (!this.loomNested);
            boolean ranAny = false;
            this.loomNested = true;
            do {
                ScheduledTask last;
                Runnable task;
                now = System.nanoTime();
                if (immediateTask == null) {
                    if (this.localLoomQueue.isEmpty()) break;
                    task = this.continuationsFifo ? this.localLoomQueue.pollLast().task() : this.localLoomQueue.pollFirst().task();
                } else {
                    task = immediateTask;
                    immediateTask = null;
                }
                ranAny = true;
                task.run();
                --this.activeThreadsLocal;
                long end = System.nanoTime();
                this.continuationTime += end - now;
                now = end;
                if (this.continuationTime <= this.factory.configuration.fifoSwitchTime().toNanos()) continue;
                this.continuationsFifo = this.continuationsFifo ? false : (last = this.localLoomQueue.peekLast()) != null && last.scheduleTime > now + this.factory.configuration.taskFifoThreshold().toNanos();
                this.continuationTime = 0L;
            } while (now < deadline && !this.expediteWrite);
            this.loomNested = false;
            return ranAny;
        }

        private void executeIo(Runnable command) {
            Runnable ioContinuation = this.ioContinuation;
            if (ioContinuation == null) {
                ioContinuation = command;
                this.ioContinuation = command;
            }
            if (ioContinuation == command) {
                Thread t2 = Thread.currentThread();
                this.ioContinuationScheduled = true;
                if (t2 != this.carrier && !this.isOnRunner(t2)) {
                    LockSupport.unpark(this.carrier);
                }
                return;
            }
            PrivateLoomSupport.getDefaultScheduler().execute(command);
        }

        @Override
        public void execute(Runnable command) {
            ContinuationScheduled scheduled;
            if (this.delegate.isShuttingDown()) {
                PrivateLoomSupport.getDefaultScheduler().execute(command);
                return;
            }
            if (ContinuationScheduled.INSTANCE.isEnabled()) {
                long hash;
                scheduled = new ContinuationScheduled();
                scheduled.hashCode = hash = (long)System.identityHashCode(command);
                Runnable r = command;
                command = () -> {
                    ContinuationStarted started = new ContinuationStarted();
                    started.begin();
                    r.run();
                    started.end();
                    started.hashCode = hash;
                    started.commit();
                };
            } else {
                scheduled = null;
            }
            if (Thread.currentThread() == this.carrier) {
                ++this.activeThreadsLocal;
                long time = System.nanoTime();
                if (this.idle && !this.loomNested && !this.expediteWrite) {
                    if (scheduled != null) {
                        scheduled.scheduleMode = 2;
                        scheduled.queueDepth = -1;
                        scheduled.commit();
                    }
                    this.runContinuations(command, time + this.factory.configuration.timeSliceLatency().toNanos());
                } else {
                    if (scheduled != null) {
                        scheduled.scheduleMode = 1;
                        scheduled.queueDepth = this.localLoomQueue.size();
                        scheduled.commit();
                    }
                    this.localLoomQueue.addFirst(new ScheduledTask(time, command));
                }
            } else {
                this.activeThreadsExternal.incrementAndGet();
                if (scheduled != null) {
                    scheduled.scheduleMode = 3;
                    scheduled.queueDepth = this.globalLoomQueue.size();
                    scheduled.commit();
                }
                this.globalLoomQueue.add(command);
                if (this.isOnRunner(Thread.currentThread())) {
                    if (!this.throughputMode && !this.expediteWrite) {
                        Thread.yield();
                    }
                } else {
                    this.backingHandler.wakeup();
                }
            }
        }

        private void tick(int type) {
            if (LoopTick.INSTANCE.isEnabled()) {
                LoopTick tick = new LoopTick();
                tick.loopIndex = this.id;
                tick.type = type;
                tick.activeThreads = this.activeThreads();
                tick.commit();
            }
        }
    }

    @Singleton
    @Requirements(value={@Requires(condition=LoomSupport.LoomCondition.class), @Requires(condition=PrivateLoomSupport.PrivateLoomCondition.class)})
    public static final class Factory {
        final EventLoopLoomFactory holder;
        final LoomCarrierConfiguration configuration;

        Factory(EventLoopLoomFactory holder, LoomCarrierConfiguration configuration) {
            this.holder = holder;
            this.configuration = configuration;
        }

        public EventLoopGroup create(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory) {
            return new LoomCarrierGroup(this, nThreads, executor, ioHandlerFactory);
        }
    }

    @StackTrace(value=false)
    @Enabled(value=false)
    static class LoopTick
    extends Event {
        static final LoopTick INSTANCE = new LoopTick();
        int loopIndex;
        int type;
        int activeThreads;

        LoopTick() {
        }
    }

    @StackTrace(value=false)
    @Enabled(value=false)
    static class ContinuationStarted
    extends Event {
        long hashCode;
        int taskQueueDepth;

        ContinuationStarted() {
        }
    }

    @StackTrace(value=false)
    @Enabled(value=false)
    static class ContinuationScheduled
    extends Event {
        static final ContinuationScheduled INSTANCE = new ContinuationScheduled();
        long hashCode;
        int scheduleMode;
        int queueDepth;

        ContinuationScheduled() {
        }
    }

    private record ScheduledTask(long scheduleTime, Runnable task) {
    }

    record StickyScheduler(Runner io) implements Executor,
    EventLoopVirtualThreadScheduler
    {
        @Override
        public void execute(Runnable command) {
            ForkJoinWorkerThread fjwt;
            Thread currentThread = Thread.currentThread();
            Executor dst = currentThread instanceof ForkJoinWorkerThread && (fjwt = (ForkJoinWorkerThread)currentThread).getPool() == PrivateLoomSupport.getDefaultScheduler() ? PrivateLoomSupport.getDefaultScheduler() : (LoomSupport.isVirtual(currentThread) && PrivateLoomSupport.getScheduler(currentThread) == PrivateLoomSupport.getDefaultScheduler() ? PrivateLoomSupport.getDefaultScheduler() : this.io);
            dst.execute(command);
        }

        @Override
        @NonNull
        public AttributeMap attributeMap() {
            return this.io.attributeMap();
        }

        @Override
        @NonNull
        public EventExecutor eventLoop() {
            return this.io.eventLoop();
        }
    }
}

