/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.reactive.execution.ReactorExecutionFlowImpl;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public interface ReactiveExecutionFlow<T>
extends ExecutionFlow<T> {
    @NonNull
    public static <K> ReactiveExecutionFlow<K> fromPublisher(@NonNull Publisher<K> publisher) {
        return new ReactorExecutionFlowImpl(publisher);
    }

    @NonNull
    public static <K> ExecutionFlow<K> fromPublisherEager(@NonNull Publisher<K> publisher, @NonNull PropagatedContext propagatedContext) {
        return ReactorExecutionFlowImpl.defuse(publisher, propagatedContext);
    }

    @NonNull
    public static <K> ReactiveExecutionFlow<K> async(@NonNull Executor executor, @NonNull Supplier<ExecutionFlow<K>> supplier) {
        Scheduler scheduler = Schedulers.fromExecutor(executor);
        return new ReactorExecutionFlowImpl(Mono.fromSupplier(supplier).flatMap(ReactorExecutionFlowImpl::toMono).subscribeOn(scheduler));
    }

    @NonNull
    public static <K> ReactiveExecutionFlow<K> fromFlow(@NonNull ExecutionFlow<K> flow) {
        if (flow instanceof ReactiveExecutionFlow) {
            ReactiveExecutionFlow executionFlow = (ReactiveExecutionFlow)flow;
            return executionFlow;
        }
        return new ReactorExecutionFlowImpl(ReactorExecutionFlowImpl.toMono(flow));
    }

    @NonNull
    public Publisher<T> toPublisher();

    @NonNull
    @SingleResult
    public static <K> Publisher<K> toPublisher(@NonNull @NonNull Supplier<@NonNull ExecutionFlow<K>> flowSupplier) {
        return ReactorExecutionFlowImpl.toMono(flowSupplier);
    }

    @NonNull
    @SingleResult
    public static <K> Publisher<K> toPublisher(@NonNull ExecutionFlow<K> flow) {
        return ReactorExecutionFlowImpl.toMono(flow);
    }
}

