/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.reactive.execution.FlowAsMono;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

@Internal
final class ReactorExecutionFlowImpl
implements ReactiveExecutionFlow<Object> {
    private Mono<Object> value;
    private List<Subscription> subscriptionsToCancel;

    <K> ReactorExecutionFlowImpl(Publisher<K> value) {
        Mono<Object> mono;
        if (value instanceof Flux) {
            Flux flux = (Flux)value;
            mono = flux.next();
        } else {
            mono = Mono.from(value);
        }
        this(mono);
    }

    <K> ReactorExecutionFlowImpl(Mono<K> value) {
        this.subscriptionsToCancel = new ArrayList<Subscription>(1);
        this.value = value;
    }

    public static <T> ExecutionFlow<T> defuse(Publisher<T> publisher, final PropagatedContext propagatedContext) {
        if (publisher instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable sc = (Fuseable.ScalarCallable)((Object)publisher);
            try {
                return ExecutionFlow.just(sc.call());
            }
            catch (Throwable t2) {
                return ExecutionFlow.error(t2);
            }
        }
        if (publisher instanceof FlowAsMono) {
            FlowAsMono flowAsMono = (FlowAsMono)publisher;
            return flowAsMono.flow;
        }
        var s2 = new CoreSubscriber<T>(){
            final AtomicReference<ExecutionFlow<T>> flow = new AtomicReference();
            boolean complete = false;

            @Override
            public Context currentContext() {
                return ReactorPropagation.addPropagatedContext(Context.empty(), propagatedContext);
            }

            @Override
            public void onSubscribe(Subscription s2) {
                Fuseable.QueueSubscription qs;
                if (s2 instanceof Fuseable.QueueSubscription && (qs = (Fuseable.QueueSubscription)s2).requestFusion(1) == 1) {
                    Object result;
                    try {
                        result = qs.poll();
                    }
                    catch (Throwable t2) {
                        this.completeError(t2);
                        return;
                    }
                    this.complete(result);
                    return;
                }
                s2.request(Long.MAX_VALUE);
            }

            private void complete(T result) {
                if (!this.flow.compareAndSet(null, ExecutionFlow.just(result))) {
                    ((DelayedExecutionFlow)this.flow.get()).complete(result);
                }
                this.complete = true;
            }

            private void completeError(Throwable t2) {
                if (!this.flow.compareAndSet(null, ExecutionFlow.error(t2))) {
                    ((DelayedExecutionFlow)this.flow.get()).completeExceptionally(t2);
                }
                this.complete = true;
            }

            @Override
            public void onNext(T t2) {
                if (this.complete) {
                    Operators.onNextDropped(t2, Context.empty());
                    return;
                }
                this.complete(t2);
            }

            @Override
            public void onError(Throwable t2) {
                if (this.complete) {
                    Operators.onErrorDropped(t2, Context.empty());
                    return;
                }
                this.completeError(t2);
            }

            @Override
            public void onComplete() {
                if (!this.complete) {
                    this.complete(null);
                }
            }
        };
        try (PropagatedContext.Scope ignored = propagatedContext.propagate();){
            publisher.subscribe(s2);
        }
        ExecutionFlow immediate = s2.flow.getPlain();
        if (immediate != null) {
            return immediate;
        }
        DelayedExecutionFlow flow = DelayedExecutionFlow.create();
        if (s2.flow.compareAndSet(null, flow)) {
            return flow;
        }
        return s2.flow.getPlain();
    }

    @Override
    public <R> ExecutionFlow<R> flatMap(Function<? super Object, ? extends ExecutionFlow<? extends R>> transformer) {
        this.value = this.value.flatMap((? super T value) -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)transformer.apply(value)));
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        this.value = this.value.then(Mono.fromSupplier(supplier).flatMap(ReactorExecutionFlowImpl::toMono));
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> map(Function<? super Object, ? extends R> function) {
        this.value = this.value.map(function);
        return this;
    }

    @Override
    public ExecutionFlow<Object> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<?>> fallback) {
        this.value = this.value.onErrorResume((? super Throwable throwable) -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)fallback.apply((Throwable)throwable)));
        return this;
    }

    @Override
    public ExecutionFlow<Object> putInContext(String key, Object value) {
        this.value = this.value.contextWrite(context -> context.put(key, value));
        return this;
    }

    @Override
    @NonNull
    public ExecutionFlow<Object> putInContextIfAbsent(@NonNull String key, @NonNull Object value) {
        this.value = this.value.contextWrite(context -> {
            if (!context.hasKey(key)) {
                return context.put(key, value);
            }
            return context;
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        List<Subscription> stc;
        ReactorExecutionFlowImpl reactorExecutionFlowImpl = this;
        synchronized (reactorExecutionFlowImpl) {
            stc = this.subscriptionsToCancel;
            this.subscriptionsToCancel = null;
        }
        if (stc != null) {
            for (Subscription subscription : stc) {
                subscription.cancel();
            }
        }
    }

    @Override
    public void onComplete(final BiConsumer<? super Object, Throwable> fn) {
        Mono<Object> mono = this.value;
        if (mono instanceof Fuseable.ScalarCallable) {
            Object value;
            Fuseable.ScalarCallable callable = (Fuseable.ScalarCallable)((Object)mono);
            try {
                value = callable.call();
            }
            catch (Exception e) {
                fn.accept(null, e);
                return;
            }
            fn.accept(value, null);
            return;
        }
        this.value.subscribe(new CoreSubscriber<Object>(){
            Subscription subscription;
            Object value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscribe(Subscription s2) {
                boolean cancel;
                this.subscription = s2;
                ReactorExecutionFlowImpl reactorExecutionFlowImpl = ReactorExecutionFlowImpl.this;
                synchronized (reactorExecutionFlowImpl) {
                    if (ReactorExecutionFlowImpl.this.subscriptionsToCancel == null) {
                        cancel = true;
                    } else {
                        ReactorExecutionFlowImpl.this.subscriptionsToCancel.add(this.subscription);
                        cancel = false;
                    }
                }
                if (cancel) {
                    s2.cancel();
                } else {
                    s2.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(Object v) {
                this.value = v;
            }

            @Override
            public void onError(Throwable t2) {
                fn.accept(null, t2);
            }

            @Override
            public void onComplete() {
                fn.accept(this.value, null);
            }
        });
    }

    @Override
    public void completeTo(final CompletableFuture<Object> completableFuture) {
        Mono<Object> mono = this.value;
        if (mono instanceof Fuseable.ScalarCallable) {
            Object value;
            Fuseable.ScalarCallable callable = (Fuseable.ScalarCallable)((Object)mono);
            try {
                value = callable.call();
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                return;
            }
            completableFuture.complete(value);
            return;
        }
        this.value.subscribe(new CoreSubscriber<Object>(){
            Subscription subscription;
            Object value;

            @Override
            public void onSubscribe(Subscription s2) {
                this.subscription = s2;
                s2.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Object v) {
                this.value = v;
            }

            @Override
            public void onError(Throwable t2) {
                completableFuture.completeExceptionally(t2);
            }

            @Override
            public void onComplete() {
                completableFuture.complete(this.value);
            }
        });
    }

    @Override
    @Nullable
    public ImperativeExecutionFlow<Object> tryComplete() {
        Mono<Object> mono = this.value;
        if (mono instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable callable = (Fuseable.ScalarCallable)((Object)mono);
            try {
                return (ImperativeExecutionFlow)ExecutionFlow.just(callable.call());
            }
            catch (Exception e) {
                return (ImperativeExecutionFlow)ExecutionFlow.error(e);
            }
        }
        return null;
    }

    static <R> Mono<Object> toMono(ExecutionFlow<R> next) {
        if (next instanceof ReactorExecutionFlowImpl) {
            ReactorExecutionFlowImpl reactiveFlowImpl = (ReactorExecutionFlowImpl)next;
            return reactiveFlowImpl.value;
        }
        ImperativeExecutionFlow<R> imperativeFlow = next.tryComplete();
        if (imperativeFlow != null) {
            Mono<Object> m4 = imperativeFlow.getError() != null ? Mono.error(imperativeFlow.getError()) : (imperativeFlow.getValue() != null ? Mono.just(imperativeFlow.getValue()) : Mono.empty());
            Map<String, Object> context = imperativeFlow.getContext();
            if (!context.isEmpty()) {
                m4 = m4.contextWrite(ctx -> {
                    for (Map.Entry e : context.entrySet()) {
                        ctx = ctx.put(e.getKey(), e.getValue());
                    }
                    return ctx;
                });
            }
            return m4;
        }
        return new FlowAsMono<Object>(next);
    }

    static <R> Mono<Object> toMono(Supplier<ExecutionFlow<R>> next) {
        return Mono.defer(() -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)next.get()));
    }

    @Override
    public Publisher<Object> toPublisher() {
        return this.value;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.value.toFuture();
    }
}

