/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.LazySendingSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.type.Argument;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ConcatenatingSubscriber;
import io.micronaut.http.body.MediaTypeProvider;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.web.router.DefaultUrlRouteInfo;
import io.micronaut.web.router.RouteAttributes;
import io.micronaut.web.router.RouteInfo;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public abstract class ResponseLifecycle {
    private final RouteExecutor routeExecutor;
    private final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    private final ConversionService conversionService;
    private final ByteBodyFactory byteBodyFactory;

    public ResponseLifecycle(RouteExecutor routeExecutor, MessageBodyHandlerRegistry messageBodyHandlerRegistry, ConversionService conversionService, ByteBodyFactory byteBodyFactory) {
        this.routeExecutor = routeExecutor;
        this.messageBodyHandlerRegistry = messageBodyHandlerRegistry;
        this.conversionService = conversionService;
        this.byteBodyFactory = byteBodyFactory;
    }

    @NonNull
    protected abstract Executor ioExecutor();

    @NonNull
    protected <T> ResponseBodyWriter<T> wrap(@NonNull MessageBodyWriter<T> messageBodyWriter) {
        return ResponseBodyWriter.wrap(messageBodyWriter);
    }

    @NonNull
    public final ExecutionFlow<? extends ByteBodyHttpResponse<?>> encodeHttpResponseSafe(@NonNull HttpRequest<?> httpRequest, @NonNull HttpResponse<?> response) {
        try {
            return this.encodeHttpResponse(httpRequest, response, response.body());
        }
        catch (Throwable e) {
            try {
                response = this.routeExecutor.createDefaultErrorResponse(httpRequest, e);
                return this.encodeHttpResponse(httpRequest, response, response.body());
            }
            catch (Throwable f) {
                f.addSuppressed(e);
                return ExecutionFlow.error(f);
            }
        }
    }

    private ExecutionFlow<? extends ByteBodyHttpResponse<?>> encodeHttpResponse(HttpRequest<?> nettyRequest, HttpResponse<?> httpResponse, Object body) {
        MutableHttpResponse<?> response = httpResponse.toMutableResponse();
        if (nettyRequest.getMethod() != HttpMethod.HEAD && body != null) {
            MessageBodyWriter<?> messageBodyWriter;
            RouteInfo routeInfo;
            Object routeInfoO = RouteAttributes.getRouteInfo(response).orElse(null);
            if (routeInfoO instanceof DefaultUrlRouteInfo) {
                DefaultUrlRouteInfo uri = routeInfoO;
                v0 = uri;
            } else {
                v0 = routeInfo = (RouteInfo)routeInfoO;
            }
            if (Publishers.isConvertibleToPublisher(body)) {
                response.body((Object)null);
                return this.mapToHttpContent(nettyRequest, response, body, routeInfo);
            }
            Object o = response.getBodyWriter().orElse(null);
            if (o instanceof ResponseBodyWriter) {
                ResponseBodyWriter rbw = o;
                messageBodyWriter = rbw;
            } else {
                messageBodyWriter = o;
            }
            MessageBodyWriter<?> messageBodyWriter2 = messageBodyWriter;
            MediaType responseMediaType = response.getContentType().orElse(null);
            Argument<Object> responseBodyType = routeInfo != null ? routeInfo.getResponseBodyType() : Argument.of(body.getClass());
            if (responseMediaType == null) {
                if (!(body instanceof String) && !(body instanceof byte[]) && body instanceof MediaTypeProvider) {
                    MediaTypeProvider mediaTypeProvider = (MediaTypeProvider)body;
                    responseMediaType = mediaTypeProvider.getMediaType();
                } else {
                    responseMediaType = routeInfo != null ? this.routeExecutor.resolveDefaultResponseContentType(nettyRequest, routeInfo) : MediaType.APPLICATION_JSON_TYPE;
                }
            }
            if (messageBodyWriter2 == null) {
                messageBodyWriter2 = this.messageBodyHandlerRegistry.findWriter(responseBodyType, Collections.singletonList(responseMediaType)).orElse(null);
            }
            if (messageBodyWriter2 == null || !responseBodyType.isInstance(body) || !messageBodyWriter2.isWriteable(responseBodyType, responseMediaType)) {
                responseBodyType = Argument.ofInstance(body);
                messageBodyWriter2 = this.messageBodyHandlerRegistry.getWriter(responseBodyType, List.of(responseMediaType));
            }
            return this.buildFinalResponse(nettyRequest, response, responseBodyType, responseMediaType, body, messageBodyWriter2, false);
        }
        response.body((Object)null);
        return this.encodeNoBody(response);
    }

    protected ExecutionFlow<? extends ByteBodyHttpResponse<?>> encodeNoBody(HttpResponse<?> response) {
        if (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            return this.encodeNoBody((HttpResponse<?>)wrapper.getDelegate());
        }
        return ExecutionFlow.just(ByteBodyHttpResponseWrapper.wrap(response, this.byteBodyFactory.createEmpty()));
    }

    private ExecutionFlow<? extends ByteBodyHttpResponse<?>> mapToHttpContent(HttpRequest<?> request, MutableHttpResponse<?> response, Object body, RouteInfo<Object> routeInfo) {
        Flux httpContentPublisher;
        boolean isJson;
        MediaType mediaType = response.getContentType().orElse(null);
        Flux<Object> bodyPublisher = Flux.from(Publishers.convertToPublisher(this.conversionService, body));
        if (routeInfo != null) {
            if (mediaType == null) {
                mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
            }
            isJson = mediaType != null && mediaType.getExtension().equals("json") && routeInfo.isResponseBodyJsonFormattable();
            MediaType finalMediaType = mediaType;
            httpContentPublisher = bodyPublisher.concatMap(message -> {
                MessageBodyWriter messageBodyWriter = routeInfo.getMessageBodyWriter();
                Argument<Object> responseBodyType = routeInfo.getResponseBodyType();
                if (messageBodyWriter == null || !responseBodyType.isInstance(message) || !messageBodyWriter.isWriteable(responseBodyType, finalMediaType)) {
                    responseBodyType = Argument.ofInstance(message);
                    messageBodyWriter = this.wrap(this.messageBodyHandlerRegistry.getWriter(responseBodyType, List.of(finalMediaType)));
                }
                ExecutionFlow<CloseableByteBody> flow = this.writePieceAsync(messageBodyWriter, request, response, responseBodyType, finalMediaType, message);
                return ReactiveExecutionFlow.toPublisher(() -> flow);
            });
        } else {
            isJson = false;
            MediaType finalMediaType = mediaType;
            httpContentPublisher = bodyPublisher.concatMap(message -> {
                Argument<Object> type = Argument.ofInstance(message);
                MessageBodyWriter<Object> messageBodyWriter = this.messageBodyHandlerRegistry.getWriter(type, finalMediaType == null ? List.of() : List.of(finalMediaType));
                ExecutionFlow<CloseableByteBody> flow = this.writePieceAsync(messageBodyWriter, request, response, type, finalMediaType, message);
                return ReactiveExecutionFlow.toPublisher(() -> flow);
            });
        }
        httpContentPublisher = httpContentPublisher.doOnDiscard(CloseableByteBody.class, CloseableByteBody::close);
        return LazySendingSubscriber.create(httpContentPublisher).map(items -> {
            CloseableByteBody byteBody = isJson ? this.concatenateJson((Publisher<ByteBody>)items) : this.concatenate((Publisher<ByteBody>)items);
            return ByteBodyHttpResponseWrapper.wrap(response, byteBody);
        }).onErrorResume(t2 -> this.handleStreamingError(request, (Throwable)t2));
    }

    @NonNull
    protected CloseableByteBody concatenate(@NonNull Publisher<ByteBody> items) {
        return ConcatenatingSubscriber.ByteBufferConcatenatingSubscriber.concatenate(items);
    }

    @NonNull
    protected CloseableByteBody concatenateJson(@NonNull Publisher<ByteBody> items) {
        return ConcatenatingSubscriber.JsonByteBufferConcatenatingSubscriber.concatenateJson(items);
    }

    @NonNull
    protected final ExecutionFlow<? extends ByteBodyHttpResponse<?>> handleStreamingError(@NonNull HttpRequest<?> request, @NonNull Throwable t2) {
        MutableHttpResponse<Object> errorResponse;
        if (t2 instanceof HttpStatusException) {
            HttpStatusException hse = (HttpStatusException)t2;
            errorResponse = HttpResponse.status(hse.getStatus());
            if (hse.getBody().isPresent()) {
                errorResponse.body(hse.getBody().get());
            } else if (hse.getMessage() != null) {
                errorResponse.body(hse.getMessage());
            }
        } else {
            errorResponse = this.routeExecutor.createDefaultErrorResponse(request, t2);
        }
        return this.encodeHttpResponse(request, errorResponse, errorResponse.body());
    }

    private <T> ExecutionFlow<CloseableByteBody> writePieceAsync(@NonNull MessageBodyWriter<T> messageBodyWriter, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        if (messageBodyWriter.isBlocking()) {
            return ExecutionFlow.async(this.ioExecutor(), () -> ExecutionFlow.just(this.writePieceSync(messageBodyWriter, request, response, type, mediaType, object)));
        }
        return ExecutionFlow.just(this.writePieceSync(messageBodyWriter, request, response, type, mediaType, object));
    }

    private <T> CloseableByteBody writePieceSync(@NonNull MessageBodyWriter<T> messageBodyWriter, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return this.wrap(messageBodyWriter).writePiece(this.byteBodyFactory, request, response, type, mediaType, object);
    }

    private <T> ExecutionFlow<ByteBodyHttpResponse<?>> buildFinalResponse(HttpRequest<?> nettyRequest, MutableHttpResponse<T> response, Argument<T> responseBodyType, MediaType mediaType, T body, MessageBodyWriter<T> messageBodyWriter, boolean onIoExecutor) {
        if (!onIoExecutor && messageBodyWriter.isBlocking()) {
            return ExecutionFlow.async(this.ioExecutor(), () -> this.buildFinalResponse(nettyRequest, response, responseBodyType, mediaType, body, messageBodyWriter, true));
        }
        try {
            return ExecutionFlow.just(this.wrap(messageBodyWriter).write(this.byteBodyFactory, nettyRequest, response, responseBodyType, mediaType, body));
        }
        catch (CodecException e) {
            MutableHttpResponse<?> errorResponse = this.routeExecutor.createDefaultErrorResponse(nettyRequest, e);
            Object errorBody = errorResponse.body();
            Argument type = Argument.ofInstance(errorBody);
            MediaType errorContentType = errorResponse.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            MessageBodyWriter errorBodyWriter = this.messageBodyHandlerRegistry.getWriter(type, List.of(errorContentType));
            if (!onIoExecutor && errorBodyWriter.isBlocking()) {
                return ExecutionFlow.async(this.ioExecutor(), () -> ExecutionFlow.just(this.wrap(errorBodyWriter).write(this.byteBodyFactory, nettyRequest, errorResponse, type, errorContentType, errorBody)));
            }
            return ExecutionFlow.just(this.wrap(errorBodyWriter).write(this.byteBodyFactory, nettyRequest, errorResponse, type, errorContentType, errorBody));
        }
    }
}

