/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.server.exceptions.ErrorResponseProcessorExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
@Produces
public class HttpStatusHandler
extends ErrorResponseProcessorExceptionHandler<HttpStatusException> {
    public HttpStatusHandler(ErrorResponseProcessor<?> responseProcessor) {
        super(responseProcessor);
    }

    @Override
    protected MutableHttpResponse<?> createResponse(HttpStatusException exception) {
        return HttpResponse.status(exception.getStatus());
    }

    @Override
    public HttpResponse<?> handle(HttpRequest request, HttpStatusException exception) {
        MutableHttpResponse<?> response = this.createResponse(exception);
        Optional<Object> body = exception.getBody();
        if (body.isPresent()) {
            return response.body(body.get());
        }
        return this.responseProcessor.processResponse(ErrorContext.builder(request).cause(exception).errorMessage(exception.getMessage()).build(), response);
    }
}

