/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Internal
@Singleton
public final class DefaultHttpCompressionStrategy
implements HttpCompressionStrategy {
    private final int compressionThreshold;
    private final int compressionLevel;
    private final int maxZstdEncodeSize;

    @Inject
    DefaultHttpCompressionStrategy(NettyHttpServerConfiguration serverConfiguration) {
        this.compressionThreshold = serverConfiguration.getCompressionThreshold();
        this.compressionLevel = serverConfiguration.getCompressionLevel();
        this.maxZstdEncodeSize = serverConfiguration.getMaxZstdEncodeSize();
    }

    DefaultHttpCompressionStrategy(int compressionThreshold, int compressionLevel, int maxZstdEncodeSize) {
        this.compressionThreshold = compressionThreshold;
        this.compressionLevel = compressionLevel;
        this.maxZstdEncodeSize = maxZstdEncodeSize;
    }

    @Override
    public boolean isEnabled() {
        return this.compressionThreshold >= 0;
    }

    @Override
    public boolean shouldCompress(HttpResponse response) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.shouldCompress(response, HttpUtil.getContentLength((HttpMessage)response, -1));
    }

    public boolean shouldCompress(HttpResponse response, long contentLength) {
        if (!this.isEnabled()) {
            return false;
        }
        HttpHeaders headers = response.headers();
        String contentType = headers.get(HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && (contentLength == -1L || contentLength >= (long)this.compressionThreshold) && MediaType.isTextBased(contentType);
    }

    @Override
    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    @Override
    public int getMaxZstdEncodeSize() {
        return this.maxZstdEncodeSize;
    }
}

