/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

@Internal
public final class FormDataHttpContentProcessor {
    protected final NettyHttpRequest<?> nettyHttpRequest;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();
    protected final NettyHttpServerConfiguration configuration;
    private final InterfaceHttpPostRequestDecoder decoder;
    private final long partMaxSize;
    private volatile boolean pleaseDestroy = false;
    private volatile boolean inFlight = false;
    private boolean destroyed = false;
    private boolean receivedLast = false;

    public FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.configuration = configuration;
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        MicronautHttpData.Factory factory = new MicronautHttpData.Factory(multipart, characterEncoding);
        HttpRequest nativeRequest = nettyHttpRequest.toHttpRequestWithoutBody();
        this.decoder = HttpPostRequestDecoder.isMultipart(nativeRequest) ? new HttpPostMultipartRequestDecoder(factory, nativeRequest, characterEncoding, configuration.getFormMaxFields(), configuration.getFormMaxBufferedBytes()) : new HttpPostStandardRequestDecoder(factory, nativeRequest, characterEncoding, configuration.getFormMaxFields(), configuration.getFormMaxBufferedBytes());
        this.partMaxSize = multipart.getMaxFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void onData(ByteBufHolder message, Collection<? super InterfaceHttpData> out) {
        boolean skip;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        // MONITORENTER : formDataHttpContentProcessor
        if (this.destroyed) {
            skip = true;
        } else {
            skip = false;
            this.inFlight = true;
        }
        // MONITOREXIT : formDataHttpContentProcessor
        if (skip) {
            message.release();
            return;
        }
        try {
            if (message instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)message;
                try {
                    InterfaceHttpPostRequestDecoder postRequestDecoder = this.decoder;
                    postRequestDecoder.offer(httpContent);
                    block18: while (postRequestDecoder.hasNext()) {
                        InterfaceHttpData data = postRequestDecoder.next();
                        data.touch();
                        switch (data.getHttpDataType()) {
                            case Attribute: {
                                Attribute attribute = (Attribute)data;
                                out.add(attribute.retain());
                                postRequestDecoder.removeHttpDataFromClean(attribute);
                                break;
                            }
                            case FileUpload: {
                                FileUpload fileUpload = (FileUpload)data;
                                if (!fileUpload.isCompleted()) continue block18;
                                out.add(fileUpload.retain());
                                postRequestDecoder.removeHttpDataFromClean(fileUpload);
                                break;
                            }
                        }
                    }
                    InterfaceHttpData currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                    if (currentPartialHttpData == null) return;
                    out.add(currentPartialHttpData);
                    postRequestDecoder.removeHttpDataFromClean(currentPartialHttpData);
                    return;
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException postRequestDecoder) {
                    httpContent.release();
                    return;
                    catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof IOException)) throw e;
                        if (!cause.getMessage().equals("Size exceed allowed maximum capacity")) throw e;
                        String partName = this.decoder.currentPartialHttpData().getName();
                        throw new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]");
                        catch (HttpPostRequestDecoder.TooManyFormFieldsException e2) {
                            throw new ContentLengthExceededException("Number of form fields exceeds configured limit of [" + this.configuration.getFormMaxFields() + "]");
                        }
                        catch (HttpPostRequestDecoder.TooLongFormFieldException e3) {
                            throw new ContentLengthExceededException("Length of buffered form field exceeds configured limit of [" + this.configuration.getFormMaxBufferedBytes() + "]");
                        }
                    }
                }
                finally {
                    httpContent.release();
                }
            }
            message.release();
            return;
        }
        finally {
            this.inFlight = false;
            this.destroyIfRequested();
        }
    }

    public void add(ByteBufHolder message, Collection<? super InterfaceHttpData> out) throws Throwable {
        try {
            this.receivedLast |= message instanceof LastHttpContent;
            long receivedLength1 = this.receivedLength.addAndGet(message.content().readableBytes());
            ReferenceCountUtil.touch(message);
            if (this.advertisedLength > this.requestMaxSize) {
                this.fireExceedsLength(this.advertisedLength, this.requestMaxSize, message);
            } else if (receivedLength1 > this.requestMaxSize) {
                this.fireExceedsLength(receivedLength1, this.requestMaxSize, message);
            } else {
                this.onData(message, out);
            }
        }
        catch (Throwable e) {
            this.cancel();
            throw e;
        }
    }

    public void complete(Collection<? super InterfaceHttpData> out) throws Throwable {
        if (!this.receivedLast) {
            this.add(LastHttpContent.EMPTY_LAST_CONTENT, out);
        }
        this.cancel();
    }

    public void cancel() {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfRequested() {
        boolean destroy;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        synchronized (formDataHttpContentProcessor) {
            if (this.pleaseDestroy && !this.destroyed && !this.inFlight) {
                destroy = true;
                this.destroyed = true;
            } else {
                destroy = false;
            }
        }
        if (destroy) {
            this.decoder.destroy();
        }
    }

    protected void fireExceedsLength(long receivedLength, long expected, ByteBufHolder message) {
        message.release();
        throw new ContentLengthExceededException(expected, receivedLength);
    }
}

