/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyCompletedFileUploadBinder;
import io.micronaut.http.server.netty.binders.NettyPublisherPartUploadBinder;
import io.micronaut.http.server.netty.converters.NettyConverters;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

final class NettyPartUploadAnnotationBinder<T>
implements AnnotatedRequestArgumentBinder<Part, T>,
RequestArgumentBinder<T> {
    private final ConversionService conversionService;
    private final NettyCompletedFileUploadBinder completedFileUploadBinder;
    private final NettyPublisherPartUploadBinder publisherPartUploadBinder;

    NettyPartUploadAnnotationBinder(ConversionService conversionService, NettyCompletedFileUploadBinder completedFileUploadBinder, NettyPublisherPartUploadBinder publisherPartUploadBinder) {
        this.conversionService = conversionService;
        this.completedFileUploadBinder = completedFileUploadBinder;
        this.publisherPartUploadBinder = publisherPartUploadBinder;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> request) {
        NettyHttpRequest nettyRequest;
        if (!(request instanceof NettyHttpRequest) || !(nettyRequest = (NettyHttpRequest)request).isFormOrMultipartData()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        if (this.completedFileUploadBinder.matches(context.getArgument().getType())) {
            return this.completedFileUploadBinder.bind(context, request);
        }
        if (this.publisherPartUploadBinder.matches(context.getArgument().getType())) {
            return this.publisherPartUploadBinder.bind(context, request);
        }
        Argument<T> argument = context.getArgument();
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(argument.getName());
        return NettyPartUploadAnnotationBinder.bindPart(this.conversionService, context, nettyRequest, inputName, false);
    }

    @NonNull
    static <T> ArgumentBinder.BindingResult<T> bindPart(ConversionService conversionService, final ArgumentConversionContext<T> context, NettyHttpRequest<?> nettyRequest, String inputName, boolean skipClaimed) {
        if (skipClaimed && nettyRequest.formRouteCompleter().isClaimed(inputName)) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        final CompletableFuture<Optional> completableFuture = Mono.from(nettyRequest.formRouteCompleter().claimFieldsComplete(inputName)).map(d -> NettyConverters.refCountAwareConvert(conversionService, d, context)).toFuture();
        return new PendingRequestBindingResult<T>(){

            @Override
            public boolean isPending() {
                return !completableFuture.isDone();
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return context.getLastError().map(List::of).orElseGet(List::of);
            }

            @Override
            public Optional<T> getValue() {
                Optional res = completableFuture.getNow(Optional.empty());
                if (res == null) {
                    res = Optional.empty();
                }
                return res;
            }
        };
    }

    @Override
    public Class<Part> getAnnotationType() {
        return Part.class;
    }
}

