/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.NativeImageUtils;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.ByteBufConsumer;
import io.micronaut.http.netty.body.NettyBodyAdapter;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.micronaut.http.server.netty.handler.Compressor;
import io.micronaut.http.server.netty.handler.Http2RequestEvent;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.PipeliningServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class MultiplexedServerHandler {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    ChannelHandlerContext ctx;
    BodySizeLimits bodySizeLimits = BodySizeLimits.UNLIMITED;
    private final RequestHandler requestHandler;
    @Nullable
    private Compressor compressor;

    MultiplexedServerHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    final void compressor(@Nullable Compressor compressor) {
        this.compressor = compressor;
    }

    abstract void flush();

    abstract class MultiplexedStream
    implements OutboundAccess {
        private final Http2RequestEvent jfrEvent;
        private HttpRequest request;
        private List<ByteBuf> bufferedContent;
        private BufferConsumer.Upstream writerUpstream;
        private InputStreamer streamer;
        private Object attachment;
        private boolean requestAccepted;
        private boolean responseDone;
        private Compressor.Session compressionSession;

        MultiplexedStream(int streamId) {
            if (NativeImageUtils.JFR_AVAILABLE && Http2RequestEvent.isTurnedOn()) {
                this.jfrEvent = new Http2RequestEvent();
                this.jfrEvent.streamId = streamId;
            } else {
                this.jfrEvent = null;
            }
        }

        abstract void notifyDataConsumed(int var1);

        abstract boolean reset(Throwable var1);

        abstract void closeInput();

        final void onHeadersRead(HttpRequest headers, boolean endOfStream) {
            if (this.requestAccepted) {
                throw new IllegalStateException("Request already accepted");
            }
            this.request = headers;
            if (endOfStream) {
                this.requestAccepted = true;
                MultiplexedServerHandler.this.requestHandler.accept(MultiplexedServerHandler.this.ctx, headers, AvailableNettyByteBody.empty(), this);
            }
        }

        final int onDataRead(ByteBuf data, boolean endOfStream) {
            if (this.streamer == null) {
                if (this.requestAccepted) {
                    throw new IllegalStateException("Request already accepted");
                }
                if (endOfStream) {
                    ByteBuf fullBody;
                    if (this.bufferedContent == null) {
                        fullBody = data;
                    } else {
                        CompositeByteBuf composite = MultiplexedServerHandler.this.ctx.alloc().compositeBuffer();
                        for (ByteBuf c : this.bufferedContent) {
                            composite.addComponent(true, c);
                        }
                        composite.addComponent(true, data);
                        fullBody = composite;
                    }
                    this.bufferedContent = null;
                    this.requestAccepted = true;
                    this.notifyDataConsumed(fullBody.readableBytes());
                    MultiplexedServerHandler.this.requestHandler.accept(MultiplexedServerHandler.this.ctx, this.request, AvailableNettyByteBody.createChecked(MultiplexedServerHandler.this.ctx.channel().eventLoop(), MultiplexedServerHandler.this.bodySizeLimits, fullBody), this);
                } else {
                    if (this.bufferedContent == null) {
                        this.bufferedContent = new ArrayList<ByteBuf>();
                    }
                    this.bufferedContent.add(data);
                }
            } else {
                this.streamer.add(data);
                if (endOfStream) {
                    this.streamer.complete();
                }
            }
            return 0;
        }

        final void devolveToStreaming() {
            if (this.requestAccepted || this.streamer != null || this.request == null) {
                return;
            }
            this.streamer = new InputStreamer(HttpUtil.is100ContinueExpected(this.request));
            if (this.bufferedContent != null) {
                for (ByteBuf buf : this.bufferedContent) {
                    this.streamer.add(buf);
                }
                this.bufferedContent = null;
            }
            this.requestAccepted = true;
            this.streamer.dest.setExpectedLengthFrom(this.request.headers());
            MultiplexedServerHandler.this.requestHandler.accept(MultiplexedServerHandler.this.ctx, this.request, new StreamingNettyByteBody(this.streamer.dest), this);
        }

        final void onGoAwayRead(Exception e) {
            this.onRstStreamRead(e);
        }

        final void onRstStreamRead(Exception e) {
            if (this.streamer != null) {
                this.streamer.error(e);
            }
            this.finish();
        }

        private boolean finish() {
            if (this.responseDone) {
                return false;
            }
            this.responseDone = true;
            if (this.writerUpstream != null) {
                this.writerUpstream.allowDiscard();
                this.writerUpstream.disregardBackpressure();
            }
            if (this.compressionSession != null) {
                this.compressionSession.discard();
            }
            MultiplexedServerHandler.this.requestHandler.responseWritten(this.attachment);
            return true;
        }

        @Override
        public void write(final @NonNull HttpResponse response, @NonNull ByteBody body) {
            if (this.responseDone) {
                return;
            }
            response.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            if (PipeliningServerHandler.canHaveBody(response.status())) {
                OptionalLong length = body.expectedLength();
                if (length.isPresent()) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length.getAsLong());
                }
            } else {
                response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
            }
            NettyByteBody nbb = NettyBodyAdapter.adapt(body, MultiplexedServerHandler.this.ctx.channel().eventLoop());
            if (nbb instanceof AvailableNettyByteBody) {
                AvailableNettyByteBody available = (AvailableNettyByteBody)nbb;
                this.writeFull(response, AvailableNettyByteBody.toByteBuf(available));
            } else {
                StreamingNettyByteBody snbb = (StreamingNettyByteBody)nbb;
                var consumer = new ByteBufConsumer(){
                    BufferConsumer.Upstream upstream;
                    final EventLoopFlow flow;
                    {
                        this.flow = new EventLoopFlow(MultiplexedServerHandler.this.ctx.channel().eventLoop());
                    }

                    @Override
                    public void add(ByteBuf buf) {
                        if (this.flow.executeNow(() -> this.add0(buf))) {
                            this.add0(buf);
                        }
                    }

                    private void add0(ByteBuf buf) {
                        int n = buf.readableBytes();
                        MultiplexedStream.this.writeData(buf, false, (ChannelPromise)MultiplexedServerHandler.this.ctx.newPromise().addListener(future -> {
                            if (future.isSuccess()) {
                                this.upstream.onBytesConsumed(n);
                            } else {
                                MultiplexedStream.this.logStreamWriteFailure(future.cause());
                                this.upstream.allowDiscard();
                            }
                        }));
                        MultiplexedServerHandler.this.flush();
                    }

                    @Override
                    public void complete() {
                        if (this.flow.executeNow(this::complete0)) {
                            this.complete0();
                        }
                    }

                    private void complete0() {
                        if (!MultiplexedStream.this.responseDone) {
                            MultiplexedStream.this.writeData(Unpooled.EMPTY_BUFFER, true, MultiplexedStream.this.endPromise(response));
                            if (MultiplexedStream.this.finish()) {
                                MultiplexedServerHandler.this.flush();
                            }
                        }
                    }

                    @Override
                    public void error(Throwable e) {
                        if (this.flow.executeNow(() -> this.error0(e))) {
                            this.error0(e);
                        }
                    }

                    private void error0(Throwable e) {
                        if (!MultiplexedStream.this.reset(e)) {
                            MultiplexedServerHandler.this.LOG.warn("Reactive response received an error after some data has already been written. This error cannot be forwarded to the client.", e);
                        }
                        MultiplexedStream.this.finish();
                        MultiplexedServerHandler.this.flush();
                    }
                };
                consumer.upstream = snbb.primary(consumer);
                this.writeStreaming(response, consumer.upstream, snbb.expectedLength().orElse(-1L));
            }
        }

        private void writeStreaming(HttpResponse response, BufferConsumer.Upstream upstream, long contentLength) {
            if (!MultiplexedServerHandler.this.ctx.executor().inEventLoop()) {
                MultiplexedServerHandler.this.ctx.executor().execute(() -> this.writeStreaming(response, upstream, contentLength));
                return;
            }
            if (this.responseDone) {
                this.writerUpstream.allowDiscard();
                this.writerUpstream.disregardBackpressure();
                return;
            }
            this.writerUpstream = upstream;
            this.prepareCompression(response, contentLength);
            this.writeHeaders(response, false, MultiplexedServerHandler.this.ctx.voidPromise());
            upstream.start();
        }

        @Override
        public void writeHeadResponse(@NonNull HttpResponse response) {
            response.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            this.writeFull(response, Unpooled.EMPTY_BUFFER);
        }

        private void writeFull(@NonNull HttpResponse response, @NonNull ByteBuf content) {
            boolean empty;
            if (this.responseDone) {
                content.release();
                return;
            }
            if (!MultiplexedServerHandler.this.ctx.executor().inEventLoop()) {
                ByteBuf finalContent = content;
                MultiplexedServerHandler.this.ctx.executor().execute(() -> this.writeFull(response, finalContent));
                return;
            }
            boolean bl = empty = !content.isReadable();
            if (!empty) {
                this.prepareCompression(response, content.readableBytes());
            }
            if (this.compressionSession != null) {
                this.compressionSession.push(content);
                this.compressionSession.finish();
                this.compressionSession.fixContentLength(response);
                content = this.compressionSession.poll();
                empty = content == null;
            }
            this.writeHeaders(response, empty, empty ? this.endPromise(response) : MultiplexedServerHandler.this.ctx.voidPromise());
            if (!empty) {
                this.writeData0(content, true, this.endPromise(response));
            } else if (content != null) {
                content.release();
            }
            if (!this.finish()) {
                throw new IllegalStateException("Response already written");
            }
            MultiplexedServerHandler.this.flush();
        }

        private ChannelPromise endPromise(@NonNull HttpResponse response) {
            if (this.jfrEvent == null) {
                return MultiplexedServerHandler.this.ctx.voidPromise();
            }
            return MultiplexedServerHandler.this.ctx.newPromise().addListener(future -> {
                this.jfrEvent.end();
                if (this.jfrEvent.shouldCommit()) {
                    this.jfrEvent.populateChannel(MultiplexedServerHandler.this.ctx.channel());
                    this.jfrEvent.populateRequest(this.request);
                    this.jfrEvent.populateResponse(response);
                    this.jfrEvent.commit();
                }
            }).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }

        private void logStreamWriteFailure(Throwable cause) {
            if (cause instanceof Http2Exception) {
                Http2Exception h2e = (Http2Exception)cause;
                if (MultiplexedServerHandler.this.LOG.isDebugEnabled()) {
                    MultiplexedServerHandler.this.LOG.debug("Stream shut down by client while sending data", h2e);
                }
            } else {
                MultiplexedServerHandler.this.LOG.debug("Stream shut down by client while sending data", cause);
            }
        }

        @Override
        public final void attachment(Object attachment) {
            this.attachment = attachment;
        }

        @Override
        public final void closeAfterWrite() {
        }

        private void prepareCompression(HttpResponse headers, long contentLength) {
            Compressor.Session session;
            if (MultiplexedServerHandler.this.compressor != null && (session = MultiplexedServerHandler.this.compressor.prepare(MultiplexedServerHandler.this.ctx, this.request, headers, contentLength)) != null) {
                headers.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                this.compressionSession = session;
            }
        }

        abstract void writeHeaders(HttpResponse var1, boolean var2, ChannelPromise var3);

        private void writeData(ByteBuf data, boolean endStream, ChannelPromise promise) {
            if (this.compressionSession == null) {
                this.writeData0(data, endStream, promise);
            } else {
                this.writeDataCompressing(data, endStream, promise);
            }
        }

        private void writeDataCompressing(ByteBuf data, boolean endStream, ChannelPromise promise) {
            ByteBuf compressed;
            Compressor.Session compressionChannel = this.compressionSession;
            compressionChannel.push(data);
            if (endStream) {
                compressionChannel.finish();
            }
            if ((compressed = compressionChannel.poll()) == null) {
                if (endStream) {
                    this.writeData0(Unpooled.EMPTY_BUFFER, true, promise);
                } else {
                    promise.trySuccess();
                }
            } else {
                this.writeData0(compressed, endStream, promise);
            }
        }

        abstract void writeData0(ByteBuf var1, boolean var2, ChannelPromise var3);

        private class InputStreamer
        implements BufferConsumer.Upstream,
        ByteBufConsumer {
            final StreamingNettyByteBody.SharedBuffer dest;
            long unacknowledged;
            boolean sendContinue;

            InputStreamer(boolean sendContinue) {
                this.dest = new StreamingNettyByteBody.SharedBuffer(MultiplexedServerHandler.this.ctx.channel().eventLoop(), MultiplexedServerHandler.this.bodySizeLimits, this);
                this.unacknowledged = 0L;
                this.sendContinue = sendContinue;
            }

            @Override
            public void start() {
                EventLoop eventLoop = MultiplexedServerHandler.this.ctx.channel().eventLoop();
                if (!eventLoop.inEventLoop()) {
                    eventLoop.execute(this::start);
                    return;
                }
                if (this.sendContinue) {
                    MultiplexedStream.this.writeHeaders(PipeliningServerHandler.ContinueOutboundHandler.CONTINUE_11, false, MultiplexedServerHandler.this.ctx.voidPromise());
                    this.sendContinue = false;
                }
            }

            @Override
            public void onBytesConsumed(long bytesConsumed) {
                long newUnacknowledged;
                if (bytesConsumed < 0L) {
                    throw new IllegalArgumentException("Negative bytes consumed");
                }
                EventLoop eventLoop = MultiplexedServerHandler.this.ctx.channel().eventLoop();
                if (!eventLoop.inEventLoop()) {
                    eventLoop.execute(() -> this.onBytesConsumed(bytesConsumed));
                    return;
                }
                long oldUnacknowledged = this.unacknowledged;
                if (oldUnacknowledged > 0L) {
                    this.notifyDataConsumedLong(Math.min(bytesConsumed, oldUnacknowledged));
                }
                if ((newUnacknowledged = oldUnacknowledged - bytesConsumed) > oldUnacknowledged) {
                    newUnacknowledged = Long.MIN_VALUE;
                }
                this.unacknowledged = newUnacknowledged;
            }

            private void notifyDataConsumedLong(long bytesConsumed) {
                if (bytesConsumed == 0L) {
                    return;
                }
                assert (bytesConsumed > 0L);
                for (int i = 0; bytesConsumed > Integer.MAX_VALUE && i < 100; bytesConsumed -= Integer.MAX_VALUE, ++i) {
                    MultiplexedStream.this.notifyDataConsumed(Integer.MAX_VALUE);
                }
                if (bytesConsumed > Integer.MAX_VALUE) {
                    MultiplexedServerHandler.this.LOG.debug("Clamping onBytesConsumed({})", (Object)bytesConsumed);
                    bytesConsumed = Integer.MAX_VALUE;
                }
                MultiplexedStream.this.notifyDataConsumed(Math.toIntExact(bytesConsumed));
                MultiplexedServerHandler.this.flush();
            }

            @Override
            public void allowDiscard() {
                EventLoop eventLoop = MultiplexedServerHandler.this.ctx.channel().eventLoop();
                if (!eventLoop.inEventLoop()) {
                    eventLoop.execute(this::allowDiscard);
                    return;
                }
                MultiplexedStream.this.closeInput();
                this.dest.discard();
            }

            @Override
            public void disregardBackpressure() {
                EventLoop eventLoop = MultiplexedServerHandler.this.ctx.channel().eventLoop();
                if (!eventLoop.inEventLoop()) {
                    eventLoop.execute(this::disregardBackpressure);
                    return;
                }
                this.unacknowledged = Long.MIN_VALUE;
            }

            @Override
            public void add(ByteBuf buf) {
                assert (MultiplexedServerHandler.this.ctx.channel().eventLoop().inEventLoop());
                if (this.unacknowledged < 0L) {
                    this.notifyDataConsumedLong(this.unacknowledged == Long.MIN_VALUE ? (long)buf.readableBytes() : Math.min((long)buf.readableBytes(), -this.unacknowledged));
                }
                this.unacknowledged += (long)buf.readableBytes();
                this.dest.add(buf);
            }

            @Override
            public void complete() {
                this.dest.complete();
            }

            @Override
            public void discard() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void error(Throwable e) {
                this.dest.error(e);
            }
        }
    }
}

