/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.NativeImageUtils;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.netty.body.ByteBufConsumer;
import io.micronaut.http.netty.body.NettyBodyAdapter;
import io.micronaut.http.netty.body.NettyByteBody;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.handler.Compressor;
import io.micronaut.http.server.netty.handler.Http1RequestEvent;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.EOFException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class PipeliningServerHandler
extends ChannelInboundHandlerAdapter
implements GracefulShutdownCapable {
    private static final Logger LOG = LoggerFactory.getLogger(PipeliningServerHandler.class);
    private final RequestHandler requestHandler;
    private final DroppingInboundHandler droppingInboundHandler = new DroppingInboundHandler();
    private final InboundHandler baseInboundHandler = new MessageInboundHandler();
    private final OptimisticBufferingInboundHandler optimisticBufferingInboundHandler = new OptimisticBufferingInboundHandler();
    private Compressor compressor;
    private BodySizeLimits bodySizeLimits = BodySizeLimits.UNLIMITED;
    private InboundHandler inboundHandler = this.baseInboundHandler;
    private final Deque<OutboundAccessImpl> outboundQueue = new ArrayDeque<OutboundAccessImpl>(1);
    @Nullable
    private OutboundHandler outboundHandler = null;
    private ChannelHandlerContext ctx;
    private boolean reading = false;
    private boolean readCalled = false;
    private boolean removed = false;
    private boolean flushPending = false;
    private boolean writing = false;
    private boolean shuttingDown = false;

    public PipeliningServerHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void setCompressionStrategy(HttpCompressionStrategy compressionStrategy) {
        this.compressor = compressionStrategy.isEnabled() ? new Compressor(compressionStrategy) : null;
    }

    public void setBodySizeLimits(BodySizeLimits bodySizeLimits) {
        this.bodySizeLimits = bodySizeLimits;
    }

    public static boolean canHaveBody(HttpResponseStatus status) {
        return status != HttpResponseStatus.CONTINUE && status != HttpResponseStatus.SWITCHING_PROTOCOLS && status != HttpResponseStatus.PROCESSING && status != HttpResponseStatus.NO_CONTENT && status != HttpResponseStatus.NOT_MODIFIED;
    }

    private static boolean hasBody(HttpRequest request) {
        int contentLength;
        if (request.decoderResult().isFailure()) {
            return false;
        }
        try {
            contentLength = HttpUtil.getContentLength((HttpMessage)request, 0);
        }
        catch (NumberFormatException e) {
            contentLength = 0;
        }
        return contentLength != 0 || HttpUtil.isTransferEncodingChunked(request);
    }

    private void refreshNeedMore() {
        if (!this.readCalled && this.outboundQueue.size() <= 1 && this.inboundHandler.needMore()) {
            this.readCalled = true;
            this.ctx.read();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        ctx.channel().config().setAutoRead(false);
        this.refreshNeedMore();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.removed = true;
        if (this.outboundHandler != null) {
            this.outboundHandler.discardOutbound();
        }
        for (OutboundAccessImpl queued : this.outboundQueue) {
            if (queued.handler == null) continue;
            queued.handler.discardOutbound();
        }
        this.inboundHandler.discard();
        this.outboundQueue.clear();
        this.requestHandler.removed();
    }

    @Override
    public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
        this.reading = true;
        this.inboundHandler.read(msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.inboundHandler.readComplete();
        this.reading = false;
        this.readCalled = false;
        if (this.flushPending) {
            ctx.flush();
            this.flushPending = false;
        }
        this.refreshNeedMore();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.inboundHandler.handleUpstreamError(cause);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeSome();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        IdleState state;
        if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
            ctx.close();
        }
        super.userEventTriggered(ctx, evt);
    }

    private ChannelFuture write(Object message, boolean flush, boolean close, boolean needsPromise) {
        ChannelPromise promise;
        if (close) {
            return this.ctx.writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        ChannelFuture channelFuture = promise = needsPromise ? this.ctx.newPromise().addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE) : this.ctx.voidPromise();
        if (flush) {
            if (this.reading) {
                this.ctx.write(message, promise);
                this.flushPending = true;
                return promise;
            }
            return this.ctx.writeAndFlush(message, promise);
        }
        return this.ctx.write(message, promise);
    }

    private void writeSome() {
        if (this.writing) {
            return;
        }
        this.writing = true;
        try {
            while (this.ctx.channel().isWritable()) {
                if (this.outboundHandler == null) {
                    OutboundAccessImpl next = this.outboundQueue.peek();
                    if (next != null && next.handler != null) {
                        this.outboundQueue.poll();
                        this.outboundHandler = next.handler;
                        this.refreshNeedMore();
                    } else {
                        return;
                    }
                }
                OutboundHandler oldHandler = this.outboundHandler;
                oldHandler.writeSome();
                if (this.outboundHandler != oldHandler) continue;
                break;
            }
        }
        finally {
            this.writing = false;
        }
    }

    @Override
    public OptionalLong reportActiveTasks() {
        return OptionalLong.of(1L);
    }

    @Override
    public CompletionStage<?> shutdownGracefully() {
        if (this.ctx.executor().inEventLoop()) {
            this.shutdownGracefully0();
        } else {
            this.ctx.executor().execute(this::shutdownGracefully0);
        }
        return NettyHttpServer.toCompletionStage(this.ctx.channel().closeFuture());
    }

    private void shutdownGracefully0() {
        this.shuttingDown = true;
        if (this.inboundHandler == this.baseInboundHandler && this.outboundHandler == null && this.outboundQueue.isEmpty()) {
            this.ctx.close();
        } else {
            OutboundAccessImpl lastResponse = this.outboundQueue.peekLast();
            if (lastResponse != null) {
                lastResponse.closeAfterWrite = true;
            }
        }
    }

    private final class DroppingInboundHandler
    extends InboundHandler {
        private DroppingInboundHandler() {
        }

        @Override
        void read(Object message) {
            if (message instanceof LastHttpContent) {
                LastHttpContent lhc = (LastHttpContent)message;
                lhc.release();
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            } else {
                ((HttpContent)message).release();
            }
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            PipeliningServerHandler.this.requestHandler.handleUnboundError(cause);
        }
    }

    private final class MessageInboundHandler
    extends InboundHandler {
        private MessageInboundHandler() {
        }

        @Override
        void read(Object message) {
            boolean full;
            HttpRequest request = (HttpRequest)message;
            OutboundAccessImpl outboundAccess = new OutboundAccessImpl(request);
            PipeliningServerHandler.this.outboundQueue.add(outboundAccess);
            HttpHeaders headers = request.headers();
            String contentEncoding = MessageInboundHandler.getContentEncoding(headers);
            EmbeddedChannel decompressionChannel = contentEncoding == null ? null : (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP)) : (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.ZLIB_OR_NONE)) : (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new BrotliDecoder()) : (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new SnappyFrameDecoder()) : null))));
            if (decompressionChannel != null) {
                headers.remove(HttpHeaderNames.CONTENT_LENGTH);
                headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            boolean bl = full = request.getClass() != DefaultHttpRequest.class && request instanceof FullHttpRequest;
            if (full && decompressionChannel == null) {
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, AvailableNettyByteBody.createChecked(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, ((FullHttpRequest)request).content()), outboundAccess);
            } else if (!PipeliningServerHandler.hasBody(request)) {
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                if (full) {
                    PipeliningServerHandler.this.inboundHandler.read(message);
                }
                if (decompressionChannel != null) {
                    decompressionChannel.finish();
                }
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, AvailableNettyByteBody.empty(), outboundAccess);
            } else {
                PipeliningServerHandler.this.optimisticBufferingInboundHandler.init(request, outboundAccess);
                PipeliningServerHandler.this.inboundHandler = decompressionChannel == null ? PipeliningServerHandler.this.optimisticBufferingInboundHandler : new DecompressingInboundHandler(decompressionChannel, PipeliningServerHandler.this.optimisticBufferingInboundHandler);
                if (full) {
                    PipeliningServerHandler.this.inboundHandler.read(new DefaultLastHttpContent(((FullHttpRequest)request).content()));
                }
            }
        }

        private static String getContentEncoding(HttpHeaders headers) {
            int idx;
            String transferEncoding;
            String contentEncoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : ((transferEncoding = headers.get(HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((idx = transferEncoding.indexOf(",")) != -1 ? transferEncoding.substring(0, idx).trim() : transferEncoding.trim()) : null);
            return contentEncoding;
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            PipeliningServerHandler.this.requestHandler.handleUnboundError(cause);
        }
    }

    private abstract class InboundHandler {
        private InboundHandler() {
        }

        boolean needMore() {
            return true;
        }

        abstract void read(Object var1);

        abstract void handleUpstreamError(Throwable var1);

        void readComplete() {
        }

        void discard() {
        }
    }

    private final class OptimisticBufferingInboundHandler
    extends InboundHandler {
        private HttpRequest request;
        private OutboundAccessImpl outboundAccess;
        private final List<HttpContent> buffer = new ArrayList<HttpContent>();

        private OptimisticBufferingInboundHandler() {
        }

        void init(HttpRequest request, OutboundAccessImpl outboundAccess) {
            assert (this.buffer.isEmpty());
            this.request = request;
            this.outboundAccess = outboundAccess;
        }

        @Override
        void read(Object message) {
            HttpContent content = (HttpContent)message;
            if (content.content().isReadable()) {
                this.buffer.add(content);
            } else {
                content.release();
            }
            if (message.getClass() == DefaultLastHttpContent.class || message instanceof LastHttpContent) {
                ByteBuf fullBody;
                if (this.buffer.size() == 0) {
                    fullBody = Unpooled.EMPTY_BUFFER;
                } else if (this.buffer.size() == 1) {
                    fullBody = this.buffer.get(0).content();
                } else {
                    CompositeByteBuf composite = PipeliningServerHandler.this.ctx.alloc().compositeBuffer();
                    for (HttpContent c : this.buffer) {
                        composite.addComponent(true, c.content());
                    }
                    fullBody = composite;
                }
                this.buffer.clear();
                HttpRequest request = this.request;
                this.request = null;
                OutboundAccessImpl outboundAccess = this.outboundAccess;
                this.outboundAccess = null;
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, AvailableNettyByteBody.createChecked(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, fullBody), outboundAccess);
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            }
        }

        @Override
        void readComplete() {
            this.devolveToStreaming();
            PipeliningServerHandler.this.inboundHandler.readComplete();
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            this.devolveToStreaming();
            PipeliningServerHandler.this.inboundHandler.handleUpstreamError(cause);
        }

        private void devolveToStreaming() {
            HttpRequest request = this.request;
            OutboundAccessImpl outboundAccess = this.outboundAccess;
            this.request = null;
            this.outboundAccess = null;
            StreamingInboundHandler streamingInboundHandler = new StreamingInboundHandler(outboundAccess, HttpUtil.is100ContinueExpected(request));
            for (HttpContent content : this.buffer) {
                streamingInboundHandler.read(content);
            }
            this.buffer.clear();
            if (PipeliningServerHandler.this.inboundHandler == this) {
                PipeliningServerHandler.this.inboundHandler = streamingInboundHandler;
            } else {
                ((DecompressingInboundHandler)PipeliningServerHandler.this.inboundHandler).delegate = streamingInboundHandler;
            }
            streamingInboundHandler.dest.setExpectedLengthFrom(request.headers());
            PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, new StreamingNettyByteBody(streamingInboundHandler.dest), outboundAccess);
        }

        @Override
        void discard() {
            for (HttpContent content : this.buffer) {
                content.release();
            }
            this.buffer.clear();
        }
    }

    private abstract class OutboundHandler {
        final OutboundAccessImpl outboundAccess;
        Compressor.Session compressionSession;

        private OutboundHandler(OutboundAccessImpl outboundAccess) {
            this.outboundAccess = outboundAccess;
        }

        private boolean shouldCloseAfterContent(boolean last) {
            return last && (this.outboundAccess.closeAfterWrite || PipeliningServerHandler.this.shuttingDown && PipeliningServerHandler.this.outboundQueue.isEmpty());
        }

        protected final void writeCompressing(HttpContent content, boolean flush, boolean last) {
            if (this.compressionSession == null) {
                this.writePotentialEnd(content, flush, this.shouldCloseAfterContent(last));
            } else {
                this.writeCompressing0(content, flush, last);
            }
        }

        void writePotentialEnd(Object content, boolean flush, boolean close) {
            boolean record = this.outboundAccess.jfrEvent != null && content instanceof LastHttpContent;
            ChannelFuture future = PipeliningServerHandler.this.write(content, flush, close, record);
            if (record) {
                future.addListener(f -> {
                    this.outboundAccess.jfrEvent.end();
                    if (this.outboundAccess.jfrEvent.shouldCommit()) {
                        this.outboundAccess.jfrEvent.populateChannel(PipeliningServerHandler.this.ctx.channel());
                        this.outboundAccess.jfrEvent.populateRequest(this.outboundAccess.request);
                        this.outboundAccess.jfrEvent.commit();
                    }
                });
            }
        }

        private void writeCompressing0(HttpContent content, boolean flush, boolean last) {
            Compressor.Session compressionSession = this.compressionSession;
            compressionSession.push(content.content());
            if (last) {
                compressionSession.finish();
            }
            if (content instanceof HttpResponse) {
                HttpResponse hr = (HttpResponse)((Object)content);
                assert (last);
                compressionSession.fixContentLength(hr);
                PipeliningServerHandler.this.write(new DefaultHttpResponse(hr.protocolVersion(), hr.status(), hr.headers()), false, false, false);
            }
            boolean close = this.shouldCloseAfterContent(last);
            ByteBuf toSend = compressionSession.poll();
            if (toSend == null) {
                if (last) {
                    HttpHeaders trailingHeaders = ((LastHttpContent)content).trailingHeaders();
                    this.writePotentialEnd(trailingHeaders.isEmpty() ? LastHttpContent.EMPTY_LAST_CONTENT : new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, trailingHeaders), flush, close);
                } else if (flush || close) {
                    PipeliningServerHandler.this.write(new DefaultHttpContent(Unpooled.EMPTY_BUFFER), flush, close, false);
                }
            } else if (last) {
                this.writePotentialEnd(new DefaultLastHttpContent(toSend, ((LastHttpContent)content).trailingHeaders()), flush, close);
            } else {
                PipeliningServerHandler.this.write(new DefaultHttpContent(toSend), flush, close, false);
            }
        }

        abstract void writeSome();

        void discardOutbound() {
            Compressor.Session compressionSession = this.compressionSession;
            if (compressionSession != null) {
                compressionSession.discard();
            }
        }
    }

    public final class OutboundAccessImpl
    implements OutboundAccess {
        private final HttpRequest request;
        private final Http1RequestEvent jfrEvent;
        private OutboundHandler handler;
        private Object attachment = null;
        private boolean closeAfterWrite = false;

        private OutboundAccessImpl(HttpRequest request) {
            this.request = request;
            if (NativeImageUtils.JFR_AVAILABLE && Http1RequestEvent.isTurnedOn()) {
                this.jfrEvent = new Http1RequestEvent();
                this.jfrEvent.begin();
            } else {
                this.jfrEvent = null;
            }
        }

        @Override
        public void attachment(Object attachment) {
            this.attachment = attachment;
        }

        @Override
        public void closeAfterWrite() {
            this.closeAfterWrite = true;
        }

        private void preprocess(HttpResponse message) {
            if (!message.protocolVersion().equals(this.request.protocolVersion())) {
                message.setProtocolVersion(this.request.protocolVersion());
            }
            if (this.request.protocolVersion().isKeepAliveDefault()) {
                if (this.request.headers().contains(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true)) {
                    this.closeAfterWrite();
                }
            } else if (!this.request.headers().contains(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true)) {
                this.closeAfterWrite();
            }
            if (message.protocolVersion().isKeepAliveDefault()) {
                if (message.headers().contains(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true)) {
                    this.closeAfterWrite();
                } else if (this.closeAfterWrite) {
                    message.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            } else if (!message.headers().contains(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true)) {
                this.closeAfterWrite();
            } else if (this.closeAfterWrite) {
                message.headers().remove(HttpHeaderNames.CONNECTION);
            }
            if (!HttpUtil.isContentLengthSet(message) && !HttpUtil.isTransferEncodingChunked(message) && PipeliningServerHandler.canHaveBody(message.status())) {
                HttpUtil.setKeepAlive(message, false);
                this.closeAfterWrite();
            }
            if (this.jfrEvent != null) {
                this.jfrEvent.populateResponse(message);
            }
        }

        private void writeContinue() {
            if (this.handler == null) {
                this.write(new ContinueOutboundHandler(this));
            }
        }

        private void write(OutboundHandler handler) {
            if (this.handler != null && !(this.handler instanceof ContinueOutboundHandler)) {
                throw new IllegalStateException("Only one response per request");
            }
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(() -> this.write(handler));
                return;
            }
            if (PipeliningServerHandler.this.removed) {
                handler.discardOutbound();
                return;
            }
            OutboundHandler outboundHandler = this.handler;
            if (outboundHandler instanceof ContinueOutboundHandler) {
                ContinueOutboundHandler cont = (ContinueOutboundHandler)outboundHandler;
                cont.next = handler;
                PipeliningServerHandler.this.writeSome();
            } else {
                this.handler = handler;
                if (PipeliningServerHandler.this.outboundQueue.peek() == this) {
                    PipeliningServerHandler.this.writeSome();
                }
            }
        }

        @Override
        public void writeHeadResponse(@NonNull HttpResponse response) {
            this.writeFull(new DefaultFullHttpResponse(response.protocolVersion(), response.status(), Unpooled.EMPTY_BUFFER, response.headers(), EmptyHttpHeaders.INSTANCE), true);
        }

        private void writeFull(FullHttpResponse response, boolean headResponse) {
            response.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            if (PipeliningServerHandler.canHaveBody(response.status())) {
                if (!headResponse) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                }
            } else {
                response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
            }
            this.preprocess(response);
            FullOutboundHandler oh = new FullOutboundHandler(this, response);
            if (response.content().isReadable()) {
                this.prepareCompression(response, oh, response.content().readableBytes());
            }
            this.write(oh);
        }

        @Override
        public void write(@NonNull HttpResponse response, @NonNull ByteBody body) {
            NettyByteBody nbb = NettyBodyAdapter.adapt(body, PipeliningServerHandler.this.ctx.channel().eventLoop());
            if (nbb instanceof AvailableNettyByteBody) {
                AvailableNettyByteBody available = (AvailableNettyByteBody)nbb;
                this.writeFull(new DefaultFullHttpResponse(response.protocolVersion(), response.status(), AvailableNettyByteBody.toByteBuf(available), response.headers(), EmptyHttpHeaders.INSTANCE), false);
            } else {
                OptionalLong expectedLength = body.expectedLength();
                if (expectedLength.isPresent()) {
                    response.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
                    if (PipeliningServerHandler.canHaveBody(response.status())) {
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)expectedLength.getAsLong());
                    } else {
                        response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                    }
                } else {
                    response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                    if (PipeliningServerHandler.canHaveBody(response.status())) {
                        response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                    } else {
                        response.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
                    }
                }
                this.preprocess(response);
                StreamingOutboundHandler oh = new StreamingOutboundHandler(this, response);
                this.prepareCompression(response, oh, expectedLength.orElse(-1L));
                oh.upstream = ((StreamingNettyByteBody)nbb).primary(oh);
                this.write(oh);
            }
        }

        private void prepareCompression(HttpResponse response, OutboundHandler outboundHandler, long contentLength) {
            if (PipeliningServerHandler.this.compressor == null) {
                return;
            }
            Compressor.Session compressionSession = PipeliningServerHandler.this.compressor.prepare(PipeliningServerHandler.this.ctx, this.request, response, contentLength);
            if (compressionSession != null) {
                if (!(response instanceof FullHttpResponse) && response.headers().contains(HttpHeaderNames.CONTENT_LENGTH)) {
                    response.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                    response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                outboundHandler.compressionSession = compressionSession;
            }
        }
    }

    private final class StreamingOutboundHandler
    extends OutboundHandler
    implements ByteBufConsumer {
        private final EventLoopFlow flow;
        private final OutboundAccessImpl outboundAccess;
        private HttpResponse initialMessage;
        private BufferConsumer.Upstream upstream;
        private boolean earlyComplete;
        private boolean writtenLast;
        private long incompleteWrittenBytes;

        StreamingOutboundHandler(OutboundAccessImpl outboundAccess, HttpResponse initialMessage) {
            super(outboundAccess);
            this.flow = new EventLoopFlow(PipeliningServerHandler.this.ctx.channel().eventLoop());
            this.earlyComplete = false;
            this.writtenLast = false;
            this.incompleteWrittenBytes = 0L;
            assert (initialMessage != null);
            if (initialMessage instanceof FullHttpResponse) {
                throw new IllegalArgumentException("Cannot have a full response as the initial message of a streaming response");
            }
            this.outboundAccess = outboundAccess;
            this.initialMessage = Objects.requireNonNull(initialMessage, "initialMessage");
        }

        @Override
        void writeSome() {
            if (this.initialMessage != null) {
                PipeliningServerHandler.this.write(this.initialMessage, false, false, false);
                this.initialMessage = null;
                this.upstream.start();
            }
            if (this.earlyComplete) {
                this.complete();
            } else {
                long written = this.incompleteWrittenBytes;
                if (written > 0L) {
                    this.incompleteWrittenBytes = 0L;
                    this.upstream.onBytesConsumed(written);
                }
            }
        }

        @Override
        public void add(ByteBuf buf) {
            if (this.flow.executeNow(() -> this.add0(buf))) {
                this.add0(buf);
            }
        }

        private void add0(ByteBuf buf) {
            if (PipeliningServerHandler.this.outboundHandler != this) {
                throw new IllegalStateException("onNext before request?");
            }
            if (this.writtenLast) {
                throw new IllegalStateException("Already written a LastHttpContent");
            }
            if (!PipeliningServerHandler.this.removed) {
                int n = buf.readableBytes();
                this.writeCompressing(new DefaultHttpContent(buf), true, false);
                this.incompleteWrittenBytes += (long)n;
                if (PipeliningServerHandler.this.ctx.channel().isWritable()) {
                    this.writeSome();
                }
            } else {
                buf.release();
            }
        }

        @Override
        public void error(Throwable t2) {
            if (this.flow.executeNow(() -> this.error0(t2))) {
                this.error0(t2);
            }
        }

        private void error0(Throwable t2) {
            if (!PipeliningServerHandler.this.removed) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Reactive response received an error after some data has already been written. This error cannot be forwarded to the client.", t2);
                }
                PipeliningServerHandler.this.ctx.close();
                PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            }
        }

        @Override
        public void complete() {
            if (this.flow.executeNow(this::complete0)) {
                this.complete0();
            }
        }

        private void complete0() {
            if (PipeliningServerHandler.this.outboundHandler != this) {
                this.earlyComplete = true;
                return;
            }
            PipeliningServerHandler.this.outboundHandler = null;
            if (!PipeliningServerHandler.this.removed) {
                if (this.initialMessage != null) {
                    this.writePotentialEnd(this.initialMessage, false, false);
                    this.initialMessage = null;
                }
                if (!this.writtenLast) {
                    this.writeCompressing(LastHttpContent.EMPTY_LAST_CONTENT, true, true);
                    this.writtenLast = true;
                }
                PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
                PipeliningServerHandler.this.writeSome();
            }
        }

        @Override
        void discardOutbound() {
            super.discardOutbound();
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            this.upstream.allowDiscard();
            PipeliningServerHandler.this.outboundHandler = null;
        }
    }

    private final class FullOutboundHandler
    extends OutboundHandler {
        private final FullHttpResponse message;

        FullOutboundHandler(OutboundAccessImpl outboundAccess, FullHttpResponse message) {
            super(outboundAccess);
            this.message = message;
        }

        @Override
        void writeSome() {
            this.writeCompressing(this.message, true, true);
            PipeliningServerHandler.this.outboundHandler = null;
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            PipeliningServerHandler.this.writeSome();
        }

        @Override
        void discardOutbound() {
            super.discardOutbound();
            PipeliningServerHandler.this.outboundHandler = null;
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            this.message.release();
        }
    }

    final class ContinueOutboundHandler
    extends OutboundHandler {
        static final FullHttpResponse CONTINUE_11 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        private static final FullHttpResponse CONTINUE_10 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        boolean written;
        OutboundHandler next;

        private ContinueOutboundHandler(OutboundAccessImpl outboundAccess) {
            super(outboundAccess);
            this.written = false;
        }

        @Override
        void writeSome() {
            if (!this.written) {
                PipeliningServerHandler.this.write(this.outboundAccess.request.protocolVersion().equals(HttpVersion.HTTP_1_0) ? CONTINUE_10 : CONTINUE_11, true, false, false);
                this.written = true;
            }
            if (this.next != null) {
                PipeliningServerHandler.this.outboundHandler = this.next;
            }
        }

        @Override
        void discardOutbound() {
            super.discardOutbound();
            if (this.next != null) {
                this.next.discardOutbound();
                this.next = null;
            }
        }
    }

    private class DecompressingInboundHandler
    extends InboundHandler {
        private final EmbeddedChannel channel;
        private InboundHandler delegate;

        public DecompressingInboundHandler(EmbeddedChannel channel, InboundHandler delegate) {
            this.channel = channel;
            this.delegate = delegate;
        }

        @Override
        void read(Object message) {
            ByteBuf decompressed;
            ByteBuf compressed = ((HttpContent)message).content();
            if (!compressed.isReadable()) {
                this.delegate.read(message);
                return;
            }
            boolean last = message instanceof LastHttpContent;
            try {
                this.channel.writeInbound(compressed);
                if (last) {
                    this.channel.finish();
                }
            }
            catch (DecompressionException e) {
                this.delegate.handleUpstreamError(e);
                this.channel.releaseInbound();
                if (last) {
                    PipeliningServerHandler.this.inboundHandler.read(LastHttpContent.EMPTY_LAST_CONTENT);
                }
                return;
            }
            while ((decompressed = (ByteBuf)this.channel.readInbound()) != null) {
                if (!decompressed.isReadable()) {
                    decompressed.release();
                    continue;
                }
                this.delegate.read(new DefaultHttpContent(decompressed));
            }
            if (last) {
                this.delegate.read(LastHttpContent.EMPTY_LAST_CONTENT);
            }
        }

        void dispose() {
            try {
                this.channel.finishAndReleaseAll();
            }
            catch (DecompressionException decompressionException) {
                // empty catch block
            }
        }

        @Override
        void readComplete() {
            this.delegate.readComplete();
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            this.delegate.handleUpstreamError(cause);
        }

        @Override
        void discard() {
            this.dispose();
            this.delegate.discard();
        }
    }

    private final class StreamingInboundHandler
    extends InboundHandler
    implements BufferConsumer.Upstream {
        final StreamingNettyByteBody.SharedBuffer dest;
        final OutboundAccessImpl outboundAccess;
        long requested = 65535L;
        boolean sendContinue;

        private StreamingInboundHandler(OutboundAccessImpl outboundAccess, boolean sendContinue) {
            this.outboundAccess = outboundAccess;
            this.sendContinue = sendContinue;
            this.dest = new StreamingNettyByteBody.SharedBuffer(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, this);
        }

        @Override
        void read(Object message) {
            HttpContent content = (HttpContent)message;
            this.requested -= (long)content.content().readableBytes();
            this.dest.add(content.content());
            if (message instanceof LastHttpContent) {
                this.dest.complete();
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            }
        }

        @Override
        void discard() {
            this.handleUpstreamError(new EOFException("Connection closed before full body was received"));
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            InboundHandler inboundHandler = PipeliningServerHandler.this.inboundHandler;
            if (inboundHandler instanceof DecompressingInboundHandler) {
                DecompressingInboundHandler dih = (DecompressingInboundHandler)inboundHandler;
                dih.dispose();
            }
            PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
            this.dest.error(cause);
        }

        @Override
        boolean needMore() {
            return this.requested > 0L;
        }

        @Override
        public void start() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::start);
                return;
            }
            if (this.sendContinue) {
                this.sendContinue = false;
                this.outboundAccess.writeContinue();
            }
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(() -> this.onBytesConsumed(bytesConsumed));
                return;
            }
            long newRequested = this.requested + bytesConsumed;
            if (newRequested < this.requested) {
                newRequested = Long.MAX_VALUE;
            }
            this.requested = newRequested;
            PipeliningServerHandler.this.refreshNeedMore();
        }

        @Override
        public void allowDiscard() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::allowDiscard);
                return;
            }
            this.sendContinue = false;
            if (PipeliningServerHandler.this.inboundHandler == this) {
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                PipeliningServerHandler.this.refreshNeedMore();
            } else {
                InboundHandler inboundHandler = PipeliningServerHandler.this.inboundHandler;
                if (inboundHandler instanceof DecompressingInboundHandler) {
                    DecompressingInboundHandler dec = (DecompressingInboundHandler)inboundHandler;
                    if (dec.delegate == this) {
                        dec.dispose();
                        PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                        PipeliningServerHandler.this.refreshNeedMore();
                    }
                }
            }
            this.dest.discard();
        }

        @Override
        public void disregardBackpressure() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::disregardBackpressure);
                return;
            }
            this.requested = Long.MAX_VALUE;
            PipeliningServerHandler.this.refreshNeedMore();
        }
    }
}

