/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLogFormatParser;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2Connection;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class Http2AccessLogManager {
    final Http2Connection connection;
    final Http2Connection.PropertyKey accessLogKey;
    final AccessLogFormatParser formatParser;
    final Logger logger;
    final Predicate<String> uriInclusion;
    AccessLog logForReuse;

    public Http2AccessLogManager(Factory factory, Http2Connection connection) {
        this.connection = connection;
        this.accessLogKey = connection.newKey();
        this.formatParser = new AccessLogFormatParser(factory.spec);
        this.logger = factory.logger == null ? LoggerFactory.getLogger("HTTP_ACCESS_LOGGER") : factory.logger;
        this.uriInclusion = factory.uriInclusion;
    }

    public void logHeaders(ChannelHandlerContext ctx, int streamId, HttpRequest request) {
        AccessLog accessLog;
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (this.uriInclusion != null && !this.uriInclusion.test(request.uri())) {
            return;
        }
        if (this.logForReuse != null) {
            accessLog = this.logForReuse;
            this.logForReuse = null;
        } else {
            accessLog = this.formatParser.newAccessLogger();
        }
        this.connection.stream(streamId).setProperty(this.accessLogKey, accessLog);
        accessLog.onRequestHeaders(ConnectionMetadata.ofNettyChannel(ctx.channel()), request.method().name(), request.headers(), request.uri(), "HTTP/2.0");
    }

    public record Factory(Logger logger, String spec, Predicate<String> uriInclusion) {
    }
}

