/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.handler.accesslog.element.ConnectionMetadata;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Locale;
import java.util.Set;

final class RemoteIpElement
implements LogElement {
    public static final String REMOTE_IP = "a";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    static final RemoteIpElement INSTANCE = new RemoteIpElement();

    private RemoteIpElement() {
    }

    @Override
    public LogElement copy() {
        return this;
    }

    @Override
    public Set<LogElement.Event> events() {
        return LogElement.Event.REQUEST_HEADERS_EVENTS;
    }

    @Override
    public String onRequestHeaders(@NonNull ConnectionMetadata metadata, @NonNull String method, @NonNull HttpHeaders headers, @NonNull String uri, @NonNull String protocol) {
        String xforwardedFor = headers.get(X_FORWARDED_FOR, null);
        if (xforwardedFor == null) {
            String inet;
            String forwarded = headers.get("Forwarded", null);
            if (forwarded != null && (inet = RemoteIpElement.processForwarded(forwarded)) != null) {
                return inet;
            }
        } else {
            return RemoteIpElement.processXForwardedFor(xforwardedFor);
        }
        return metadata.remoteAddress().flatMap(ConnectionMetadata::getHostAddress).orElse("-");
    }

    private static String processXForwardedFor(String xforwardedFor) {
        int firstComma = xforwardedFor.indexOf(44);
        if (firstComma >= 0) {
            return xforwardedFor.substring(0, firstComma);
        }
        return xforwardedFor;
    }

    private static String processForwarded(String forwarded) {
        int firstComma = forwarded.indexOf(44);
        String firstForward = (firstComma >= 0 ? forwarded.substring(0, firstComma) : forwarded).toLowerCase(Locale.US);
        int startIndex = firstForward.indexOf("for");
        if (startIndex == -1) {
            return null;
        }
        int semiColonIndex = firstForward.indexOf(59);
        int endIndex = semiColonIndex >= 0 ? semiColonIndex : firstForward.length();
        startIndex += 4;
        while (startIndex < endIndex) {
            char c = firstForward.charAt(startIndex);
            if (Character.isWhitespace(c) || c == '=') {
                ++startIndex;
                continue;
            }
            return firstForward.substring(startIndex, endIndex);
        }
        return null;
    }

    public String toString() {
        return "%a";
    }
}

