/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.ProxyHeaderParser;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class DefaultHttpHostResolver
implements HttpHostResolver {
    private static final String DEFAULT_HOST = "http://localhost";
    private final BeanProvider<EmbeddedServer> embeddedServer;
    private final HttpServerConfiguration serverConfiguration;

    @Inject
    public DefaultHttpHostResolver(HttpServerConfiguration serverConfiguration, @Nullable BeanProvider<EmbeddedServer> embeddedServer) {
        this.serverConfiguration = serverConfiguration;
        this.embeddedServer = embeddedServer;
    }

    @Override
    @NonNull
    public String resolve(@Nullable HttpRequest request) {
        HttpServerConfiguration.HostResolutionConfiguration configuration;
        String host = request != null ? ((configuration = this.serverConfiguration.getHostResolution()) != null && configuration.headersConfigured() ? this.getConfiguredHost(request, configuration) : this.getDefaultHost(request)) : this.getEmbeddedHost();
        return this.validateHost(host);
    }

    @NonNull
    protected String validateHost(@NonNull String host) {
        List<Pattern> allowedHosts;
        HttpServerConfiguration.HostResolutionConfiguration configuration;
        if (!host.equals(DEFAULT_HOST) && (configuration = this.serverConfiguration.getHostResolution()) != null && !(allowedHosts = configuration.getAllowedHosts()).isEmpty() && allowedHosts.stream().map(pattern -> pattern.matcher(host)).noneMatch(Matcher::matches)) {
            return DEFAULT_HOST;
        }
        return host;
    }

    protected String getEmbeddedHost() {
        if (this.embeddedServer != null) {
            EmbeddedServer server = this.embeddedServer.get();
            return this.createHost(server.getScheme(), server.getHost(), server.getPort());
        }
        return DEFAULT_HOST;
    }

    protected String getDefaultHost(HttpRequest request) {
        ProxyHeaderParser proxyHeaderParser = new ProxyHeaderParser(request);
        if (proxyHeaderParser.getHost() != null) {
            return this.createHost(proxyHeaderParser.getScheme(), proxyHeaderParser.getHost(), proxyHeaderParser.getPort());
        }
        String hostHeader = (String)request.getHeaders().get("Host");
        if (hostHeader != null) {
            return this.getConfiguredHost(request, null, "Host", null, true);
        }
        URI uri = request.getUri();
        if (uri.getHost() != null) {
            Integer port = uri.getPort();
            if (port < 0) {
                port = null;
            }
            return this.createHost(uri.getScheme(), uri.getHost(), port);
        }
        return this.getEmbeddedHost();
    }

    protected String getConfiguredHost(HttpRequest request, HttpServerConfiguration.HostResolutionConfiguration configuration) {
        return this.getConfiguredHost(request, configuration.getProtocolHeader(), configuration.getHostHeader(), configuration.getPortHeader(), configuration.isPortInHost());
    }

    protected String getConfiguredHost(HttpRequest request, String schemeHeader, String hostHeader, String portHeader, boolean isPortInHost) {
        Integer port;
        int separatorIndex;
        HttpHeaders headers = request.getHeaders();
        String scheme = null;
        if (schemeHeader != null) {
            scheme = (String)headers.get(schemeHeader);
        }
        if (scheme == null) {
            scheme = request.getUri().getScheme();
        }
        if (scheme == null && this.embeddedServer != null) {
            scheme = this.embeddedServer.get().getScheme();
        }
        String host = null;
        if (hostHeader != null) {
            host = (String)headers.get(hostHeader);
        }
        if (host == null) {
            host = request.getUri().getHost();
        }
        if (host == null && this.embeddedServer != null) {
            host = this.embeddedServer.get().getHost();
        }
        int n = separatorIndex = host == null ? -1 : host.indexOf(58);
        if (isPortInHost && separatorIndex != -1) {
            try {
                port = Integer.valueOf(host.substring(separatorIndex + 1).trim());
            }
            catch (NumberFormatException e) {
                port = null;
            }
            host = host.substring(0, separatorIndex).trim();
        } else if (portHeader != null) {
            port = headers.get(portHeader, Integer.class).orElse(null);
        } else {
            port = request.getUri().getPort();
            if (port < 0) {
                port = null;
            }
        }
        return this.createHost(scheme, host, port);
    }

    private String createHost(@Nullable String scheme, @Nullable String host, @Nullable Integer port) {
        scheme = scheme == null ? "http" : scheme;
        String string = host = host == null ? "localhost" : host;
        if (port != null && port != 80 && port != 443) {
            return scheme + "://" + host + ":" + port;
        }
        return scheme + "://" + host;
    }
}

