/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class HttpHeadersUtil {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Supplier<Pattern> HEADER_MASK_PATTERNS = SupplierUtil.memoized(() -> Pattern.compile(".*(password|cred|cert|key|secret|token|auth|signat).*", 2));

    private HttpHeadersUtil() {
    }

    public static void trace(@NonNull Logger log, @NonNull HttpHeaders httpHeaders) {
        if (log.isTraceEnabled()) {
            HttpHeadersUtil.trace(log, httpHeaders.names(), httpHeaders::getAll);
        }
    }

    public static void trace(@NonNull Logger log, @NonNull Set<String> names, @NonNull Function<String, List<String>> getAllHeaders) {
        if (log.isTraceEnabled()) {
            names.forEach(name -> HttpHeadersUtil.trace(log, name, getAllHeaders));
        }
    }

    public static void trace(@NonNull Logger log, @NonNull Supplier<Set<String>> namesSupplier, @NonNull Function<String, List<String>> getAllHeaders) {
        if (log.isTraceEnabled()) {
            HttpHeadersUtil.trace(log, namesSupplier.get(), getAllHeaders);
        }
    }

    public static void trace(@NonNull Logger log, @NonNull String name, @NonNull Function<String, List<String>> getAllHeaders) {
        boolean isMasked = HEADER_MASK_PATTERNS.get().matcher(name).matches();
        List<String> all = getAllHeaders.apply(name);
        if (all.size() > 1) {
            for (String value : all) {
                String maskedValue = isMasked ? HttpHeadersUtil.mask(value) : value;
                log.trace("{}: {}", (Object)name, (Object)maskedValue);
            }
        } else if (!all.isEmpty()) {
            String maskedValue = isMasked ? HttpHeadersUtil.mask(all.get(0)) : all.get(0);
            log.trace("{}: {}", (Object)name, (Object)maskedValue);
        }
    }

    @Nullable
    private static String mask(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return "*MASKED*";
    }

    @Internal
    @Nullable
    public static String splitAcceptHeader(@NonNull String text) {
        int len = text.length();
        if (len == 0 || len == 1 && text.charAt(0) == '*') {
            return null;
        }
        if (text.indexOf(59) > -1) {
            text = text.split(";")[0];
        }
        if (text.indexOf(44) > -1) {
            text = text.split(",")[0];
        }
        return text;
    }

    @NonNull
    public static Charset parseCharacterEncoding(@Nullable String contentTypeHeaderValue, @Nullable String acceptCharsetHeaderValue) {
        MediaType contentType = contentTypeHeaderValue == null ? null : MediaType.of(contentTypeHeaderValue);
        Charset charset = acceptCharsetHeaderValue != null ? HttpHeadersUtil.parseAcceptCharset(acceptCharsetHeaderValue) : StandardCharsets.UTF_8;
        return HttpHeadersUtil.parseCharacterEncoding(contentType, charset);
    }

    @NonNull
    public static Charset parseCharacterEncoding(@Nullable MediaType contentType, @NonNull Charset acceptCharset) {
        try {
            String charset;
            if (contentType != null && (charset = contentType.getParametersMap().get("charset")) != null) {
                try {
                    return Charset.forName(charset);
                }
                catch (Exception e) {
                    return DEFAULT_CHARSET;
                }
            }
        }
        catch (UnsupportedCharsetException e) {
            return DEFAULT_CHARSET;
        }
        return acceptCharset;
    }

    @NonNull
    public static Charset parseAcceptCharset(@NonNull String acceptCharsetHeaderValue) {
        String text = HttpHeadersUtil.splitAcceptHeader(acceptCharsetHeaderValue);
        if (text != null) {
            try {
                return Charset.forName(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DEFAULT_CHARSET;
    }
}

