/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.expressions.ConfigurableExpressionEvaluationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.expressions.EvaluatedExpression;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import io.micronaut.inject.annotation.EvaluatedConvertibleValuesMap;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class EvaluatedAnnotationValue<A extends Annotation>
extends AnnotationValue<A> {
    private final ConfigurableExpressionEvaluationContext evaluationContext;
    private final AnnotationValue<A> annotationValue;

    EvaluatedAnnotationValue(AnnotationValue<A> annotationValue, ConfigurableExpressionEvaluationContext evaluationContext) {
        super(annotationValue, annotationValue.getDefaultValues(), new EvaluatedConvertibleValuesMap<Object>(evaluationContext, annotationValue.getConvertibleValues()), (Object value) -> {
            EnvironmentAnnotationValue eav;
            Function<Object, Object> valueMapper;
            if (value instanceof EvaluatedExpression) {
                EvaluatedExpression expression = (EvaluatedExpression)value;
                return expression.evaluate(evaluationContext);
            }
            if (annotationValue instanceof EnvironmentAnnotationValue && (valueMapper = (eav = (EnvironmentAnnotationValue)annotationValue).getValueMapper()) != null) {
                return valueMapper.apply(value);
            }
            return value;
        });
        this.evaluationContext = evaluationContext;
        this.annotationValue = annotationValue;
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member, Class<T> type) {
        return super.getAnnotations(member, type).stream().map(av -> new EvaluatedAnnotationValue<A>(av, this.evaluationContext)).collect(Collectors.toList());
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member) {
        return super.getAnnotations(member).stream().map(av -> new EvaluatedAnnotationValue<A>(av, this.evaluationContext)).collect(Collectors.toList());
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(String member, Class<T> type) {
        return super.getAnnotation(member, type).map(av -> new EvaluatedAnnotationValue<A>(av, this.evaluationContext));
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(@NonNull String member) {
        return super.getAnnotation(member).map(av -> new EvaluatedAnnotationValue<A>(av, this.evaluationContext));
    }

    public EvaluatedAnnotationValue<A> withArguments(@Nullable Object thisObject, Object[] args) {
        return new EvaluatedAnnotationValue<A>(this.annotationValue, this.evaluationContext.withArguments(thisObject, args));
    }
}

