/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.management.health.indicator.annotation.Readiness;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import io.micronaut.runtime.graceful.GracefulShutdownManager;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
@Readiness
@Internal
final class GracefulShutdownHealthIndicator
implements HealthIndicator,
GracefulShutdownCapable {
    private static final String NAME = "gracefulShutdown";
    private final BeanProvider<GracefulShutdownManager> manager;
    private volatile boolean shuttingDown = false;

    GracefulShutdownHealthIndicator(BeanProvider<GracefulShutdownManager> manager) {
        this.manager = manager;
    }

    @Override
    public Publisher<HealthResult> getResult() {
        HealthResult.Builder builder = HealthResult.builder(NAME).status(this.shuttingDown ? HealthStatus.DOWN : HealthStatus.UP);
        this.manager.get().reportActiveTasks().ifPresent(n -> builder.details(Map.of("activeTasks", n)));
        return Mono.just(builder.build());
    }

    @Override
    public CompletionStage<?> shutdownGracefully() {
        this.shuttingDown = true;
        return CompletableFuture.completedFuture(null);
    }
}

