/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator.discovery;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.management.health.indicator.discovery.DiscoveryClientHealthIndicatorConfiguration;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Requirements(value={@Requires(beans={DiscoveryClient.class, DiscoveryClientHealthIndicatorConfiguration.class}), @Requires(property="endpoints.health.discovery-client-health.enabled", defaultValue="true", notEquals="false")})
@Singleton
public class DiscoveryClientHealthIndicator
implements HealthIndicator {
    private final DiscoveryClient discoveryClient;

    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public Publisher<HealthResult> getResult() {
        return Flux.from(this.discoveryClient.getServiceIds()).flatMap(ids -> {
            List serviceMap = ids.stream().map(id -> {
                Flux<List<ServiceInstance>> serviceList = Flux.from(this.discoveryClient.getInstances((String)id));
                return serviceList.map(serviceInstances -> Collections.singletonMap(id, serviceInstances));
            }).collect(Collectors.toList());
            Flux mergedServiceMap = Flux.merge(serviceMap);
            return mergedServiceMap.reduce(new LinkedHashMap(), (allServiceMap, service) -> {
                allServiceMap.putAll(service);
                return allServiceMap;
            }).map(details -> {
                HealthResult.Builder builder = HealthResult.builder(this.discoveryClient.getDescription(), HealthStatus.UP);
                Stream entryStream = details.entrySet().stream();
                Map<String, Object> value = entryStream.collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ServiceInstance::getURI).collect(Collectors.toList())));
                builder.details(Collections.singletonMap("services", value));
                return builder.build();
            }).flux();
        }).onErrorResume(throwable -> {
            HealthResult.Builder builder = HealthResult.builder(this.discoveryClient.getDescription(), HealthStatus.DOWN);
            builder.exception((Throwable)throwable);
            return Flux.just(builder.build());
        });
    }
}

