/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.banner.Banner;
import io.micronaut.context.banner.MicronautBanner;
import io.micronaut.context.banner.ResourceBanner;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Described;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Micronaut
extends DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    private static final String BANNER_NAME = "micronaut-banner.txt";
    private static final Logger LOG = LoggerFactory.getLogger(Micronaut.class);
    private static final String SHUTDOWN_MONITOR_THREAD = "micronaut-shutdown-monitor-thread";
    private final Map<Class<? extends Throwable>, Function<Throwable, Integer>> exitHandlers = new LinkedHashMap<Class<? extends Throwable>, Function<Throwable, Integer>>();

    protected Micronaut() {
    }

    @Override
    @NonNull
    public ApplicationContext start() {
        long start = System.nanoTime();
        this.printBanner();
        ApplicationContext applicationContext = super.build();
        try {
            applicationContext.start();
            EmbeddedApplication embeddedApplication = applicationContext.findBean(EmbeddedApplication.class).orElse(null);
            if (embeddedApplication != null) {
                try {
                    Object uri;
                    boolean keepAlive;
                    embeddedApplication.start();
                    if (embeddedApplication instanceof Described) {
                        Described described = (Described)((Object)embeddedApplication);
                        if (LOG.isInfoEnabled()) {
                            long took = Micronaut.elapsedMillis(start);
                            String desc = described.getDescription();
                            LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took, (Object)desc);
                        }
                        keepAlive = embeddedApplication.isServer();
                    } else if (embeddedApplication instanceof EmbeddedServer) {
                        EmbeddedServer embeddedServer = (EmbeddedServer)embeddedApplication;
                        if (LOG.isInfoEnabled()) {
                            took = Micronaut.elapsedMillis(start);
                            try {
                                uri = embeddedServer.getContextURI();
                            }
                            catch (UnsupportedOperationException e) {
                                uri = "<URI display not available: " + e.getMessage() + ">";
                            }
                            LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took, uri);
                        }
                        keepAlive = embeddedServer.isKeepAlive();
                    } else {
                        if (LOG.isInfoEnabled()) {
                            took = Micronaut.elapsedMillis(start);
                            LOG.info("Startup completed in {}ms.", (Object)took);
                        }
                        keepAlive = embeddedApplication.isServer();
                    }
                    Thread mainThread = Thread.currentThread();
                    boolean finalKeepAlive = keepAlive;
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    if (embeddedApplication.isShutdownHookNeeded()) {
                        try {
                            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("Embedded Application shutting down");
                                }
                                try (ApplicationContext applicationContext2 = applicationContext;){
                                    embeddedApplication.stop();
                                    countDownLatch.countDown();
                                    if (finalKeepAlive) {
                                        mainThread.interrupt();
                                    }
                                }
                            }));
                        }
                        catch (IllegalStateException e) {
                            try {
                                uri = applicationContext;
                                try {
                                    embeddedApplication.stop();
                                }
                                finally {
                                    if (uri != null) {
                                        uri.close();
                                    }
                                }
                            }
                            catch (Throwable stopError) {
                                LOG.error("Embedded Application shutting down", stopError);
                            }
                            LOG.warn("Failed to register shutdown hook", e);
                        }
                    }
                    if (keepAlive) {
                        new Thread(() -> {
                            try {
                                if (!embeddedApplication.isRunning()) {
                                    countDownLatch.countDown();
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }, SHUTDOWN_MONITOR_THREAD).start();
                        boolean interrupted = false;
                        while (true) {
                            try {
                                countDownLatch.await();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            break;
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Embedded Application shutting down");
                        }
                    }
                    if (embeddedApplication.isForceExit()) {
                        System.exit(0);
                    }
                }
                catch (Throwable e) {
                    this.handleStartupException(applicationContext.getEnvironment(), e);
                    Thread.currentThread().interrupt();
                }
            }
            if (LOG.isInfoEnabled() && embeddedApplication == null) {
                LOG.info("No embedded container found. Running as CLI application");
            }
            return applicationContext;
        }
        catch (Throwable e) {
            this.handleStartupException(applicationContext.getEnvironment(), e);
            Thread.currentThread().interrupt();
            return applicationContext;
        }
    }

    private static long elapsedMillis(long startNanos) {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    @NonNull
    public Micronaut include(String ... configurations) {
        return (Micronaut)super.include(configurations);
    }

    @Override
    @NonNull
    public Micronaut exclude(String ... configurations) {
        return (Micronaut)super.exclude(configurations);
    }

    @Override
    @NonNull
    public Micronaut banner(boolean isEnabled) {
        return (Micronaut)super.banner(isEnabled);
    }

    @NonNull
    public Micronaut classes(Class<?> ... classes) {
        if (classes != null) {
            for (Class<?> aClass : classes) {
                this.packages(aClass.getPackage().getName());
            }
        }
        return this;
    }

    @Override
    @NonNull
    public Micronaut properties(@Nullable Map<String, Object> properties) {
        return (Micronaut)super.properties(properties);
    }

    @Override
    @NonNull
    public Micronaut singletons(Object ... beans) {
        return (Micronaut)super.singletons(beans);
    }

    @Override
    public Micronaut beanDefinitions(RuntimeBeanDefinition<?> ... definitions) {
        return (Micronaut)super.beanDefinitions(definitions);
    }

    @Override
    @NonNull
    public Micronaut propertySources(PropertySource ... propertySources) {
        return (Micronaut)super.propertySources(propertySources);
    }

    @Override
    @NonNull
    public Micronaut environmentPropertySource(boolean environmentPropertySource) {
        return (Micronaut)super.environmentPropertySource(environmentPropertySource);
    }

    @Override
    @NonNull
    public Micronaut environmentVariableIncludes(String ... environmentVariables) {
        return (Micronaut)super.environmentVariableIncludes(environmentVariables);
    }

    @Override
    @NonNull
    public Micronaut environmentVariableExcludes(String ... environmentVariables) {
        return (Micronaut)super.environmentVariableExcludes(environmentVariables);
    }

    @Override
    @NonNull
    public Micronaut mainClass(Class<?> mainClass) {
        return (Micronaut)super.mainClass(mainClass);
    }

    @Override
    @NonNull
    public Micronaut classLoader(ClassLoader classLoader) {
        return (Micronaut)super.classLoader(classLoader);
    }

    @Override
    @NonNull
    public Micronaut args(String ... args) {
        return (Micronaut)super.args(args);
    }

    @Override
    @NonNull
    public Micronaut environments(String ... environments) {
        return (Micronaut)super.environments(environments);
    }

    @Override
    @NonNull
    public Micronaut defaultEnvironments(String ... environments) {
        return (Micronaut)super.defaultEnvironments(environments);
    }

    @Override
    @NonNull
    public Micronaut packages(String ... packages) {
        return (Micronaut)super.packages(packages);
    }

    public <T extends Throwable> Micronaut mapError(Class<T> exception, Function<T, Integer> mapper) {
        this.exitHandlers.put(exception, mapper);
        return this;
    }

    public static Micronaut build(String ... args) {
        return new Micronaut().args(args);
    }

    public static ApplicationContext run(String ... args) {
        return Micronaut.run(ReflectionUtils.EMPTY_CLASS_ARRAY, args);
    }

    public static ApplicationContext run(Class<?> cls, String ... args) {
        return Micronaut.run(new Class[]{cls}, args);
    }

    public static ApplicationContext run(Class<?>[] classes, String ... args) {
        return new Micronaut().classes(classes).args(args).start();
    }

    protected void handleStartupException(Environment environment, Throwable exception) {
        Function exitCodeMapper = this.exitHandlers.computeIfAbsent(exception.getClass(), exceptionType -> throwable -> 1);
        Integer code = (Integer)exitCodeMapper.apply(exception);
        if (code > 0 && !environment.getActiveNames().contains("test")) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error starting Micronaut server: {}", (Object)exception.getMessage(), (Object)exception);
            }
            System.exit(code);
        }
        throw new ApplicationStartupException("Error starting Micronaut server: " + exception.getMessage(), exception);
    }

    private void printBanner() {
        if (!this.isBannerEnabled()) {
            return;
        }
        PrintStream out = System.out;
        this.resolveBanner(out).print();
    }

    @NonNull
    private Banner resolveBanner(@NonNull PrintStream out) {
        return this.getResourceLoader().getResource(BANNER_NAME).map(resource -> new ResourceBanner((URL)resource, out)).orElseGet(() -> new MicronautBanner(out));
    }
}

