/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.beans;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Mapper;
import io.micronaut.context.expressions.ConfigurableExpressionEvaluationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.expressions.EvaluatedExpression;
import io.micronaut.core.expressions.ExpressionEvaluationContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

@InterceptorBean(value={Mapper.class})
@Internal
@BootstrapContextCompatible
final class MapperIntroduction
implements MethodInterceptor<Object, Object> {
    private final ApplicationContext applicationContext;
    private final ConversionService conversionService;
    private final Map<ExecutableMethod<?, ?>, MapInvocation> cachedInvocations = new ConcurrentHashMap();

    MapperIntroduction(ConversionService conversionService, ApplicationContext applicationContext) {
        this.conversionService = conversionService;
        this.applicationContext = applicationContext;
    }

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasDeclaredAnnotation(Mapper.class)) {
            ExecutableMethod<Object, Object> key = context.getExecutableMethod();
            MapInvocation invocation = this.cachedInvocations.get(key);
            if (invocation == null) {
                invocation = context.getArguments().length == 1 ? this.createMappingInvocation(context) : this.createMergingInvocation(context);
                this.cachedInvocations.put(key, invocation);
            }
            return invocation.map(context);
        }
        return context.proceed();
    }

    private MapInvocation createMappingInvocation(MethodInvocationContext<Object, Object> context) {
        Argument toType = context.getReturnType().asArgument();
        BeanIntrospection<Object> toIntrospection = BeanIntrospection.getIntrospection(toType.getType());
        Argument<Object> fromArgument = context.getArguments()[0];
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        Mapper.ConflictStrategy conflictStrategy = annotationMetadata.enumValue(Mapper.class, "conflictStrategy", Mapper.ConflictStrategy.class).orElse(null);
        return new DefaultMapInvocation(annotationMetadata, fromArgument, toIntrospection, 0, conflictStrategy);
    }

    private MapInvocation createMergingInvocation(MethodInvocationContext<Object, Object> context) {
        Argument toType = context.getReturnType().asArgument();
        BeanIntrospection<Object> toIntrospection = BeanIntrospection.getIntrospection(toType.getType());
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        Mapper.ConflictStrategy conflictStrategy = annotationMetadata.enumValue(Mapper.class, "conflictStrategy", Mapper.ConflictStrategy.class).orElse(null);
        Mapper.MergeStrategy mergeStrategy = this.createMergeStrategy(annotationMetadata, this.applicationContext);
        int nArguments = context.getArguments().length;
        DefaultMapInvocation[] innerInvocations = new DefaultMapInvocation[nArguments];
        for (int i = 0; i < nArguments; ++i) {
            Argument<Object> fromArgument = context.getArguments()[i];
            innerInvocations[i] = new DefaultMapInvocation(annotationMetadata, fromArgument, toIntrospection, i, conflictStrategy);
        }
        return callContext -> {
            MergeMappingBuilder<Object> builder = new MergeMappingBuilder<Object>(toIntrospection.builder(), mergeStrategy);
            for (int i = 0; i < innerInvocations.length; ++i) {
                builder.setArgIndex(i);
                innerInvocations[i].map(callContext, builder);
            }
            return builder.build(new Object[0]);
        };
    }

    @Nullable
    private List<Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> buildRootMappers(BeanIntrospection<Object> fromIntrospection, Mapper.ConflictStrategy conflictStrategy, List<AnnotationValue<Mapper.Mapping>> annotations, boolean isMap) {
        ArrayList<Function<Object, BiConsumer>> rootMappers = new ArrayList<Function<Object, BiConsumer>>(5);
        for (AnnotationValue<Mapper.Mapping> annotation : annotations) {
            EvaluatedExpression ee;
            EvaluatedExpression evaluatedCondition;
            if (annotation.contains("to") || !annotation.contains("from")) continue;
            Map<CharSequence, Object> values = annotation.getValues();
            Object from = values.get("from");
            Object condition = values.get("condition");
            EvaluatedExpression evaluatedExpression = evaluatedCondition = condition instanceof EvaluatedExpression ? (ee = (EvaluatedExpression)condition) : null;
            if (from instanceof EvaluatedExpression) {
                EvaluatedExpression evaluatedExpression2 = (EvaluatedExpression)from;
                if (evaluatedCondition != null) {
                    rootMappers.add(expressionEvaluationContext -> (object, builder) -> {
                        Object v;
                        ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                        if (ObjectUtils.coerceToBoolean(evaluatedCondition.evaluate(evaluationContext)) && (v = evaluatedExpression2.evaluate(evaluationContext)) != null) {
                            this.mapAllFromValue(conflictStrategy, (MappingBuilder<Object>)builder, v);
                        }
                    });
                    continue;
                }
                rootMappers.add(expressionEvaluationContext -> (object, builder) -> {
                    ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                    Object v = evaluatedExpression2.evaluate(evaluationContext);
                    if (v != null) {
                        this.mapAllFromValue(conflictStrategy, (MappingBuilder<Object>)builder, v);
                    }
                });
                continue;
            }
            if (from == null) continue;
            String propertyName = from.toString();
            if (fromIntrospection != null) {
                BeanProperty<Object, Object> fromProperty = fromIntrospection.getRequiredProperty(propertyName, Object.class);
                rootMappers.add(expressionEvaluationContext -> (object, builder) -> {
                    Object result = fromProperty.get(object);
                    if (result != null) {
                        this.mapAllFromValue(conflictStrategy, (MappingBuilder<Object>)builder, result);
                    }
                });
                continue;
            }
            if (!isMap) continue;
            rootMappers.add(expressionEvaluationContext -> (object, builder) -> {
                Object result = ((Map)object).get(propertyName);
                if (result != null) {
                    this.mapAllFromValue(conflictStrategy, (MappingBuilder<Object>)builder, result);
                }
            });
        }
        if (rootMappers.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(rootMappers);
    }

    private Map<String, Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> buildCustomMappers(Argument<Object> methodArgument, BeanIntrospection<Object> fromIntrospection, BeanIntrospection<Object> toIntrospection, Mapper.ConflictStrategy conflictStrategy, List<AnnotationValue<Mapper.Mapping>> annotations, boolean isMap) {
        HashMap<String, Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> customMappers = new HashMap<String, Function<Object, BiConsumer<Object, MappingBuilder<Object>>>>();
        BeanIntrospection.Builder<Object> builderMeta = toIntrospection.builder();
        @NonNull Argument<?>[] builderArguments = builderMeta.getBuilderArguments();
        for (AnnotationValue<Mapper.Mapping> mapping : annotations) {
            EvaluatedExpression ee;
            int i;
            String to = mapping.stringValue("to").orElse(null);
            String format = mapping.stringValue("format").orElse(null);
            if (!StringUtils.isNotEmpty(to) || (i = builderMeta.indexOf(to)) == -1) continue;
            Argument<?> argument = builderArguments[i];
            ArgumentConversionContext<?> conversionContext = null;
            if (format != null) {
                conversionContext = ConversionContext.of(argument);
                MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
                annotationMetadata.addAnnotation(Format.class.getName(), Map.of("value", format));
                conversionContext = conversionContext.with(new AnnotationMetadataHierarchy(argument.getAnnotationMetadata(), annotationMetadata));
            } else if (conflictStrategy == Mapper.ConflictStrategy.CONVERT || conflictStrategy == null) {
                conversionContext = ConversionContext.of(argument);
            }
            Map<CharSequence, Object> values = mapping.getValues();
            Object defaultValue = mapping.contains("defaultValue") ? mapping.stringValue("defaultValue").flatMap(v -> this.conversionService.convert(v, argument)).orElseThrow(() -> new IllegalStateException("Invalid defaultValue [" + String.valueOf(values.get("defaultValue")) + "] specified to @Mapping annotation for type " + String.valueOf(argument))) : null;
            Object from = values.get("from");
            Object condition = values.get("condition");
            EvaluatedExpression evaluatedCondition = condition instanceof EvaluatedExpression ? (ee = (EvaluatedExpression)condition) : null;
            ArgumentConversionContext<?> finalConversionContext = conversionContext;
            if (from instanceof EvaluatedExpression) {
                EvaluatedExpression evaluatedExpression = (EvaluatedExpression)from;
                if (evaluatedCondition != null) {
                    customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                        ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                        if (ObjectUtils.coerceToBoolean(evaluatedCondition.evaluate(evaluationContext))) {
                            Object v = evaluatedExpression.evaluate(evaluationContext);
                            this.handleValue(i, argument, defaultValue, finalConversionContext, (MappingBuilder<Object>)builder, v, null, object);
                        } else if (defaultValue != null) {
                            builder.with(i, argument, defaultValue, to, object);
                        }
                    });
                    continue;
                }
                customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                    ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                    Object v = evaluatedExpression.evaluate(evaluationContext);
                    this.handleValue(i, argument, defaultValue, finalConversionContext, (MappingBuilder<Object>)builder, v, null, object);
                });
                continue;
            }
            if (from == null) continue;
            String propertyName = from.toString();
            String methodArgumentName = null;
            if (propertyName.contains(".")) {
                int index = propertyName.indexOf(46);
                methodArgumentName = propertyName.substring(0, index);
                propertyName = propertyName.substring(index + 1);
            }
            String finalPropertyName = propertyName;
            if (methodArgumentName != null && !methodArgumentName.equals(methodArgument.getName())) continue;
            if (fromIntrospection != null) {
                BeanProperty<Object, Object> fromProperty = fromIntrospection.getRequiredProperty(propertyName, Object.class);
                customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                    Object result = fromProperty.get(object);
                    this.handleValue(i, argument, defaultValue, finalConversionContext, (MappingBuilder<Object>)builder, result, finalPropertyName, object);
                });
                continue;
            }
            if (!isMap) continue;
            customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                Object result = ((Map)object).get(finalPropertyName);
                this.handleValue(i, argument, defaultValue, finalConversionContext, (MappingBuilder<Object>)builder, result, finalPropertyName, object);
            });
        }
        return customMappers;
    }

    private Mapper.MergeStrategy createMergeStrategy(AnnotationMetadata annotationMetadata, ApplicationContext applicationContext) {
        return annotationMetadata.stringValue(Mapper.class, "mergeStrategy").map(name -> {
            if ("NOT_NULL_OVERRIDE".equals(name)) {
                return new NotNullOverrideMergeStrategy();
            }
            if ("ALWAYS_OVERRIDE".equals(name)) {
                return new AlwaysOverrideMergeStrategy();
            }
            return applicationContext.getBean(Mapper.MergeStrategy.class, Qualifiers.byName(name));
        }).orElse(new NotNullOverrideMergeStrategy());
    }

    private void mapAllFromValue(Mapper.ConflictStrategy conflictStrategy, MappingBuilder<Object> builder, Object object) {
        BeanIntrospection<?> nestedFrom;
        try {
            nestedFrom = BeanIntrospection.getIntrospection(object.getClass());
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Invalid @Mapping(from=..) declaration. The source property must declared @Introspected: " + e.getMessage(), e);
        }
        @NonNull Collection<BeanProperty<?, Object>> propertyNames = nestedFrom.getBeanProperties();
        for (BeanProperty<?, Object> property : propertyNames) {
            Object propertyValue;
            int i;
            if (property.isWriteOnly() || (i = builder.indexOf(property.getName())) <= -1) continue;
            Argument<?> argument = builder.getBuilderArguments()[i];
            if (argument.isInstance(propertyValue = property.get(object))) {
                builder.with(i, argument, propertyValue, property.getName(), object);
                continue;
            }
            if (conflictStrategy == Mapper.ConflictStrategy.CONVERT) {
                builder.convert(i, ConversionContext.of(argument), propertyValue, this.conversionService, property.getName(), object);
                continue;
            }
            throw new IllegalArgumentException("Cannot map invalid value [" + String.valueOf(propertyValue) + "] to type: " + String.valueOf(argument));
        }
    }

    private static MapStrategy buildMapStrategy(Mapper.ConflictStrategy conflictStrategy, Map<String, Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> customMappers, @Nullable List<Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> rootMappers, MethodInvocationContext<Object, Object> callContext) {
        MapStrategy mapStrategy;
        block4: {
            block3: {
                mapStrategy = new MapStrategy(conflictStrategy);
                AnnotationMetadata callAnnotationMetadata = callContext.getAnnotationMetadata();
                if (!(callAnnotationMetadata instanceof EvaluatedAnnotationMetadata)) break block3;
                EvaluatedAnnotationMetadata evaluatedAnnotationMetadata = (EvaluatedAnnotationMetadata)callAnnotationMetadata;
                ConfigurableExpressionEvaluationContext evaluationContext = evaluatedAnnotationMetadata.getEvaluationContext();
                customMappers.forEach((name, mapperSupplier) -> mapStrategy.customMappers.put((String)name, (BiConsumer)mapperSupplier.apply(evaluationContext)));
                if (rootMappers == null) break block4;
                for (Function<Object, BiConsumer<Object, MappingBuilder<Object>>> mapSupplier : rootMappers) {
                    mapStrategy.rootMappers.add(mapSupplier.apply(evaluationContext));
                }
                break block4;
            }
            customMappers.forEach((name, mapperSupplier) -> mapStrategy.customMappers.put((String)name, (BiConsumer)mapperSupplier.apply(null)));
            if (rootMappers != null) {
                for (Function<Object, BiConsumer<Object, MappingBuilder<Object>>> mapSupplier : rootMappers) {
                    mapStrategy.rootMappers.add(mapSupplier.apply(null));
                }
            }
        }
        return mapStrategy;
    }

    private void handleValue(int index, Argument<Object> argument, Object defaultValue, ArgumentConversionContext<Object> conversionContext, MappingBuilder<Object> builder, Object value, String mappedPropertyName, Object owner) {
        if (value == null) {
            if (defaultValue != null) {
                builder.with(index, argument, defaultValue, mappedPropertyName, owner);
            } else {
                builder.with(index, argument, null, mappedPropertyName, owner);
            }
        } else if (argument.isInstance(value)) {
            builder.with(index, argument, value, mappedPropertyName, owner);
        } else if (conversionContext != null) {
            builder.convert(index, conversionContext, value, this.conversionService, mappedPropertyName, owner);
        } else {
            throw new IllegalArgumentException("Cannot map invalid value [" + String.valueOf(value) + "] to type: " + String.valueOf(argument));
        }
    }

    private <I, O> void processCustomMappers(I input, MapStrategy mapStrategy, MappingBuilder<O> builder) {
        Map<String, BiConsumer<Object, MappingBuilder<Object>>> customMappers = mapStrategy.customMappers();
        customMappers.forEach((name, func) -> {
            int i = builder.indexOf((String)name);
            if (i > -1) {
                func.accept(input, builder);
            }
        });
        List<BiConsumer<Object, MappingBuilder<Object>>> rootMappers = mapStrategy.rootMappers();
        for (BiConsumer<Object, MappingBuilder<Object>> rootMapper : rootMappers) {
            rootMapper.accept(input, builder);
        }
    }

    @FunctionalInterface
    private static interface MapInvocation {
        public Object map(MethodInvocationContext<Object, Object> var1);
    }

    private final class DefaultMapInvocation
    implements MapInvocation {
        private final Map<String, Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> customMapperSuppliers;
        private final List<Function<Object, BiConsumer<Object, MappingBuilder<Object>>>> rootMapperSuppliers;
        private final boolean isMap;
        private final boolean needsCustom;
        private final BeanIntrospection<Object> fromIntrospection;
        private final BeanIntrospection<Object> toIntrospection;
        private final int argIndex;
        private final Mapper.ConflictStrategy conflictStrategy;

        public DefaultMapInvocation(AnnotationMetadata annotationMetadata, Argument<Object> fromArgument, BeanIntrospection<Object> toIntrospection, int argIndex, Mapper.ConflictStrategy conflictStrategy) {
            Class fromClass = fromArgument.getType();
            this.isMap = Map.class.isAssignableFrom(fromClass);
            this.fromIntrospection = this.isMap ? null : BeanIntrospection.getIntrospection(fromClass);
            this.toIntrospection = toIntrospection;
            if (annotationMetadata.isPresent(Mapper.class, "value")) {
                List<AnnotationValue<Mapper.Mapping>> annotations = annotationMetadata.getAnnotationValuesByType(Mapper.Mapping.class);
                this.customMapperSuppliers = MapperIntroduction.this.buildCustomMappers(fromArgument, this.fromIntrospection, toIntrospection, conflictStrategy, annotations, this.isMap);
                this.rootMapperSuppliers = MapperIntroduction.this.buildRootMappers(this.fromIntrospection, conflictStrategy, annotations, this.isMap);
            } else {
                this.customMapperSuppliers = null;
                this.rootMapperSuppliers = null;
            }
            this.needsCustom = this.customMapperSuppliers != null && !this.customMapperSuppliers.isEmpty() || this.rootMapperSuppliers != null && !this.rootMapperSuppliers.isEmpty();
            this.argIndex = argIndex;
            this.conflictStrategy = conflictStrategy;
        }

        public void map(MethodInvocationContext<Object, Object> callContext, MappingBuilder<Object> builder) {
            if (this.needsCustom) {
                MapStrategy mapStrategy = MapperIntroduction.buildMapStrategy(this.conflictStrategy, this.customMapperSuppliers, this.rootMapperSuppliers, callContext);
                if (this.isMap) {
                    this.mapMap((Map)callContext.getParameterValues()[this.argIndex], mapStrategy, builder);
                } else {
                    this.mapBean(callContext.getParameterValues()[this.argIndex], mapStrategy, this.fromIntrospection, builder);
                }
            } else if (this.isMap) {
                this.mapMap((Map)callContext.getParameterValues()[this.argIndex], MapStrategy.DEFAULT, builder);
            } else {
                this.mapBean(callContext.getParameterValues()[this.argIndex], MapStrategy.DEFAULT, this.fromIntrospection, builder);
            }
        }

        @Override
        public Object map(MethodInvocationContext<Object, Object> invocationContext) {
            DefaultMappingBuilder<Object> builder = new DefaultMappingBuilder<Object>(this.toIntrospection.builder());
            this.map(invocationContext, builder);
            return builder.build(new Object[0]);
        }

        private <I, O> void mapBean(I input, MapStrategy mapStrategy, BeanIntrospection<I> inputIntrospection, MappingBuilder<O> builder) {
            boolean isDefault = mapStrategy == MapStrategy.DEFAULT;
            Mapper.ConflictStrategy conflictStrategy = mapStrategy.conflictStrategy();
            @NonNull Argument<?>[] arguments = builder.getBuilderArguments();
            if (!isDefault) {
                MapperIntroduction.this.processCustomMappers(input, mapStrategy, builder);
            }
            for (BeanProperty<I, Object> beanProperty : inputIntrospection.getBeanProperties()) {
                int i;
                if (beanProperty.isWriteOnly()) continue;
                String propertyName = beanProperty.getName();
                if (!isDefault && mapStrategy.customMappers().containsKey(propertyName) || (i = builder.indexOf(propertyName)) <= -1) continue;
                Argument<?> argument = arguments[i];
                Object value = beanProperty.get(input);
                if (value == null || argument.isInstance(value)) {
                    builder.with(i, argument, value, propertyName, input);
                    continue;
                }
                if (conflictStrategy == Mapper.ConflictStrategy.CONVERT) {
                    ArgumentConversionContext<?> conversionContext = ConversionContext.of(argument);
                    builder.convert(i, conversionContext, value, MapperIntroduction.this.conversionService, propertyName, input);
                    continue;
                }
                builder.with(i, argument, value, propertyName, input);
            }
        }

        private <O> void mapMap(Map<String, Object> input, MapStrategy mapStrategy, MappingBuilder<O> builder) {
            boolean isDefault;
            @NonNull Argument[] arguments = builder.getBuilderArguments();
            Mapper.ConflictStrategy conflictStrategy = mapStrategy.conflictStrategy();
            boolean bl = isDefault = mapStrategy == MapStrategy.DEFAULT;
            if (!isDefault) {
                MapperIntroduction.this.processCustomMappers(input, mapStrategy, builder);
            }
            input.forEach((key, value) -> {
                int i = builder.indexOf((String)key);
                if (!isDefault && mapStrategy.customMappers().containsKey(key)) {
                    return;
                }
                if (i > -1) {
                    Argument argument = arguments[i];
                    if (conflictStrategy == Mapper.ConflictStrategy.CONVERT) {
                        builder.convert(i, ConversionContext.of(argument), value, MapperIntroduction.this.conversionService, (String)key, input);
                    } else {
                        builder.with(i, argument, value, (String)key, input);
                    }
                }
            });
        }
    }

    private static final class NotNullOverrideMergeStrategy
    implements Mapper.MergeStrategy {
        private NotNullOverrideMergeStrategy() {
        }

        @Override
        @Nullable
        public Object merge(Object currentValue, Object value, Object valueOwner, String propertyName, String mappedPropertyName) {
            return value != null ? value : currentValue;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface MappingBuilder<B> {
        @NonNull
        public Argument<?>[] getBuilderArguments();

        public int indexOf(String var1);

        @NonNull
        public <A> MappingBuilder<B> with(int var1, Argument<A> var2, A var3, String var4, Object var5);

        public <A> MappingBuilder<B> convert(int var1, ArgumentConversionContext<A> var2, A var3, ConversionService var4, String var5, Object var6);

        public B build(Object ... var1);
    }

    private record MapStrategy(Mapper.ConflictStrategy conflictStrategy, Map<String, BiConsumer<Object, MappingBuilder<Object>>> customMappers, List<BiConsumer<Object, MappingBuilder<Object>>> rootMappers) {
        static final MapStrategy DEFAULT = new MapStrategy(Mapper.ConflictStrategy.CONVERT, Collections.emptyMap(), List.of());

        private MapStrategy {
            if (conflictStrategy == null) {
                conflictStrategy = Mapper.ConflictStrategy.CONVERT;
            }
            if (customMappers == null) {
                customMappers = new HashMap<String, BiConsumer<Object, MappingBuilder<Object>>>(10);
            }
            if (rootMappers == null) {
                rootMappers = new ArrayList<BiConsumer<Object, MappingBuilder<Object>>>(3);
            }
        }

        public MapStrategy(Mapper.ConflictStrategy conflictStrategy) {
            this(conflictStrategy, new HashMap<String, BiConsumer<Object, MappingBuilder<Object>>>(10), new ArrayList<BiConsumer<Object, MappingBuilder<Object>>>(3));
        }
    }

    private static final class AlwaysOverrideMergeStrategy
    implements Mapper.MergeStrategy {
        private AlwaysOverrideMergeStrategy() {
        }

        @Override
        @Nullable
        public Object merge(Object currentValue, Object value, Object valueOwner, String propertyName, String mappedPropertyName) {
            return value;
        }
    }

    private static final class MergeMappingBuilder<B>
    implements MappingBuilder<B> {
        private final BeanIntrospection.Builder<B> builder;
        private final Mapper.MergeStrategy mergeStrategy;
        private final Argument<?>[] arguments;
        private final Object[] params;
        private int argIndex = 0;

        public MergeMappingBuilder(BeanIntrospection.Builder<B> builder, Mapper.MergeStrategy mergeStrategy) {
            this.builder = builder;
            this.arguments = builder.getBuilderArguments();
            this.params = new Object[this.arguments.length];
            this.mergeStrategy = mergeStrategy;
        }

        public MergeMappingBuilder<B> setArgIndex(int argIndex) {
            this.argIndex = argIndex;
            return this;
        }

        @Override
        public <A> MappingBuilder<B> with(int index, Argument<A> argument, A value, String mappedPropertyName, Object owner) {
            this.params[index] = this.argIndex == 0 ? value : this.mergeStrategy.merge(this.params[index], value, owner, argument.getName(), mappedPropertyName);
            return this;
        }

        @Override
        @NonNull
        public Argument<?>[] getBuilderArguments() {
            return this.arguments;
        }

        @Override
        public int indexOf(String name) {
            return this.builder.indexOf(name);
        }

        @Override
        public B build(Object ... builderParams) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null) continue;
                this.builder.with(i, this.arguments[i], this.params[i]);
            }
            return this.builder.build(builderParams);
        }

        @Override
        public <A> MappingBuilder<B> convert(int index, ArgumentConversionContext<A> conversionContext, A value, ConversionService conversionService, String mappedPropertyName, Object owner) {
            Argument<A> argument = conversionContext.getArgument();
            if (value != null) {
                if (!argument.isInstance(value)) {
                    value = conversionService.convertRequired(value, conversionContext);
                }
                this.with(index, argument, value, mappedPropertyName, owner);
            }
            return this;
        }
    }

    private record DefaultMappingBuilder<B>(BeanIntrospection.Builder<B> builder) implements MappingBuilder<B>
    {
        @Override
        public <A> MappingBuilder<B> with(int index, Argument<A> argument, A value, String mappedPropertyName, Object owner) {
            this.builder.with(index, argument, value);
            return this;
        }

        @Override
        @NonNull
        public Argument<?>[] getBuilderArguments() {
            return this.builder.getBuilderArguments();
        }

        @Override
        public int indexOf(String name) {
            return this.builder.indexOf(name);
        }

        @Override
        public B build(Object ... params) {
            return this.builder.build(params);
        }

        @Override
        public <A> MappingBuilder<B> convert(int index, ArgumentConversionContext<A> of, A value, ConversionService conversionService, String mappedPropertyName, Object owner) {
            this.builder.convert(index, of, value, conversionService);
            return this;
        }
    }
}

