/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.graceful;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.runtime.graceful.LogHolder;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;

public interface GracefulShutdownCapable {
    @NonNull
    public CompletionStage<?> shutdownGracefully();

    default public OptionalLong reportActiveTasks() {
        return OptionalLong.empty();
    }

    @NonNull
    public static CompletionStage<?> allOf(@NonNull Stream<CompletionStage<?>> stages) {
        return CompletableFuture.allOf((CompletableFuture[])stages.map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @NonNull
    public static CompletionStage<?> shutdownAll(@NonNull Stream<? extends GracefulShutdownCapable> stages) {
        return CompletableFuture.allOf((CompletableFuture[])stages.map(l -> {
            CompletionStage<?> s2;
            try {
                s2 = l.shutdownGracefully();
            }
            catch (Exception e) {
                LogHolder.LOG.warn("Exception when attempting graceful shutdown", e);
                return CompletableFuture.completedFuture(null);
            }
            return s2.toCompletableFuture();
        }).toArray(CompletableFuture[]::new));
    }

    @NonNull
    public static OptionalLong combineActiveTasks(@NonNull Iterable<? extends GracefulShutdownCapable> delegates) {
        long sum = 0L;
        boolean anyPresent = false;
        for (GracefulShutdownCapable gracefulShutdownCapable : delegates) {
            OptionalLong r = gracefulShutdownCapable.reportActiveTasks();
            if (!r.isPresent()) continue;
            anyPresent = true;
            sum += r.getAsLong();
        }
        return anyPresent ? OptionalLong.of(sum) : OptionalLong.empty();
    }
}

