/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.graceful;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.core.order.Ordered;
import io.micronaut.runtime.graceful.GracefulShutdownConfiguration;
import io.micronaut.runtime.graceful.GracefulShutdownManager;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(bean=GracefulShutdownManager.class), @Requires(property="micronaut.lifecycle.graceful-shutdown.enabled", value="true", defaultValue="false")})
public final class GracefulShutdownListener
implements ApplicationEventListener<ShutdownEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownListener.class);
    private final GracefulShutdownManager manager;
    private final GracefulShutdownConfiguration config;

    GracefulShutdownListener(GracefulShutdownManager manager, GracefulShutdownConfiguration config) {
        this.manager = manager;
        this.config = config;
    }

    @Override
    public void onApplicationEvent(ShutdownEvent event) {
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.nanoTime();
            LOG.debug("Starting graceful shutdown...");
        }
        Duration gracePeriod = this.config.getGracePeriod();
        try {
            this.manager.shutdownGracefully().toCompletableFuture().get(gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                long end = System.nanoTime();
                LOG.debug("Graceful shutdown complete in {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.warn("Error in graceful shutdown. This is against the GracefulShutdownCapable contract!", e);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout hit in graceful shutdown, forcing stop");
        }
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

