/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

@Internal
public final class LoomSupport {
    private static final boolean SUPPORTED;
    private static Throwable failure;
    private static final MethodHandle MH_NEW_THREAD_PER_TASK_EXECUTOR;
    private static final MethodHandle MH_OF_VIRTUAL;
    private static final MethodHandle MH_NAME;
    private static final MethodHandle MH_NAME_COUNT;
    private static final MethodHandle MH_FACTORY;
    private static final MethodHandle MH_UNSTARTED;
    private static final MethodHandle MH_IS_VIRTUAL;

    private LoomSupport() {
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static void checkSupported() {
        if (!LoomSupport.isSupported()) {
            throw new UnsupportedOperationException("Virtual threads are not supported on this JVM, you may have to pass --enable-preview", failure);
        }
    }

    public static ThreadFactory newVirtualThreadFactory(String namePrefix, Consumer<Object> builderModifier) {
        LoomSupport.checkSupported();
        try {
            Object builder = MH_OF_VIRTUAL.invoke();
            builder = MH_NAME_COUNT.invoke(builder, namePrefix, 1L);
            if (builderModifier != null) {
                builderModifier.accept(builder);
            }
            return MH_FACTORY.invoke(builder);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Thread unstarted(String name, Consumer<Object> builderModifier, Runnable task) {
        LoomSupport.checkSupported();
        try {
            Object builder = MH_OF_VIRTUAL.invoke();
            builder = MH_NAME.invoke(builder, name);
            if (builderModifier != null) {
                builderModifier.accept(builder);
            }
            return MH_UNSTARTED.invoke(builder, task);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        LoomSupport.checkSupported();
        try {
            return MH_NEW_THREAD_PER_TASK_EXECUTOR.invokeExact(threadFactory);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory newVirtualThreadFactory(String namePrefix) {
        return LoomSupport.newVirtualThreadFactory(namePrefix, null);
    }

    public static boolean isVirtual(Thread thread) {
        if (!LoomSupport.isSupported()) {
            return false;
        }
        try {
            return MH_IS_VIRTUAL.invokeExact(thread);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        boolean sup;
        MethodHandle isVirtual;
        MethodHandle unstarted;
        MethodHandle factory;
        MethodHandle nameCount;
        MethodHandle name;
        MethodHandle ofVirtual;
        MethodHandle newThreadPerTaskExecutor;
        try {
            newThreadPerTaskExecutor = MethodHandles.lookup().findStatic(Executors.class, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class));
            Class<?> builderCl = Class.forName("java.lang.Thread$Builder");
            Class<?> ofVirtualCl = Class.forName("java.lang.Thread$Builder$OfVirtual");
            ofVirtual = MethodHandles.lookup().findStatic(Thread.class, "ofVirtual", MethodType.methodType(ofVirtualCl));
            name = MethodHandles.lookup().findVirtual(builderCl, "name", MethodType.methodType(builderCl, String.class));
            nameCount = MethodHandles.lookup().findVirtual(builderCl, "name", MethodType.methodType(builderCl, String.class, Long.TYPE));
            factory = MethodHandles.lookup().findVirtual(builderCl, "factory", MethodType.methodType(ThreadFactory.class));
            unstarted = MethodHandles.lookup().findVirtual(builderCl, "unstarted", MethodType.methodType(Thread.class, Runnable.class));
            isVirtual = MethodHandles.lookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
            Thread probe = unstarted.invoke(ofVirtual.invoke(), () -> {});
            sup = Class.forName("java.lang.VirtualThread").isInstance(probe);
            if (!sup) {
                failure = new Exception("This JVM doesn't fully implement virtual threads and produces regular platform threads instead.");
            }
        }
        catch (Throwable e) {
            newThreadPerTaskExecutor = null;
            ofVirtual = null;
            name = null;
            nameCount = null;
            factory = null;
            unstarted = null;
            isVirtual = null;
            sup = false;
            failure = e;
        }
        SUPPORTED = sup;
        MH_NEW_THREAD_PER_TASK_EXECUTOR = newThreadPerTaskExecutor;
        MH_OF_VIRTUAL = ofVirtual;
        MH_NAME = name;
        MH_NAME_COUNT = nameCount;
        MH_FACTORY = factory;
        MH_UNSTARTED = unstarted;
        MH_IS_VIRTUAL = isVirtual;
    }

    @Internal
    public static class LoomCondition
    implements Condition {
        @Override
        public boolean matches(ConditionContext context) {
            if (LoomSupport.isSupported()) {
                return true;
            }
            context.fail("Virtual threads support not available: " + failure.getMessage());
            return false;
        }
    }
}

