/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import io.micronaut.scheduling.LoomSupport;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorType;
import io.micronaut.scheduling.executor.FastThreadPerTaskExecutor;
import io.micronaut.scheduling.executor.GracefulShutdownCapableScheduledThreadPoolExecutor;
import io.micronaut.scheduling.executor.NamedThreadFactory;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;

@Factory
public class ExecutorFactory
implements GracefulShutdownCapable {
    private final BeanLocator beanLocator;
    private final ThreadFactory threadFactory;
    private List<GracefulShutdownCapable> gracefulShutdownCapable;

    @Inject
    public ExecutorFactory(BeanLocator beanLocator, ThreadFactory threadFactory) {
        this.beanLocator = beanLocator;
        this.threadFactory = threadFactory;
    }

    @EachBean(value=ExecutorConfiguration.class)
    protected ThreadFactory eventLoopGroupThreadFactory(ExecutorConfiguration configuration) {
        String name = configuration.getName();
        if (configuration.isVirtual()) {
            if (name == null) {
                name = "virtual";
            }
            String prefix = name + "-executor-";
            return r -> LoomSupport.unstarted(prefix + ThreadLocalRandom.current().nextInt(), null, r);
        }
        if (name != null) {
            return new NamedThreadFactory(name + "-executor");
        }
        return this.threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EachBean(value=ExecutorConfiguration.class)
    @Bean(preDestroy="shutdown")
    public ExecutorService executorService(ExecutorConfiguration executorConfiguration) {
        ExecutorType executorType = executorConfiguration.getType();
        switch (executorType) {
            case FIXED: {
                return Executors.newFixedThreadPool(executorConfiguration.getNumberOfThreads(), this.getThreadFactory(executorConfiguration));
            }
            case CACHED: {
                return Executors.newCachedThreadPool(this.getThreadFactory(executorConfiguration));
            }
            case SCHEDULED: {
                GracefulShutdownCapableScheduledThreadPoolExecutor exec = new GracefulShutdownCapableScheduledThreadPoolExecutor((int)executorConfiguration.getCorePoolSize(), this.getThreadFactory(executorConfiguration));
                ExecutorFactory executorFactory = this;
                synchronized (executorFactory) {
                    if (this.gracefulShutdownCapable == null) {
                        this.gracefulShutdownCapable = new ArrayList<GracefulShutdownCapable>();
                    }
                    this.gracefulShutdownCapable.add(exec);
                }
                return exec;
            }
            case WORK_STEALING: {
                return Executors.newWorkStealingPool(executorConfiguration.getParallelism());
            }
            case THREAD_PER_TASK: {
                if ("false".equals(System.getProperty("jdk.trackAllThreads"))) {
                    return new FastThreadPerTaskExecutor(this.getThreadFactory(executorConfiguration));
                }
                return LoomSupport.newThreadPerTaskExecutor(this.getThreadFactory(executorConfiguration));
            }
        }
        throw new IllegalStateException("Could not create Executor service for enum value: " + String.valueOf((Object)executorType));
    }

    private ThreadFactory getThreadFactory(ExecutorConfiguration executorConfiguration) {
        return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(ThreadFactory.class::cast).orElseGet(() -> {
            if (this.beanLocator != null) {
                if (executorConfiguration.getName() == null) {
                    return this.beanLocator.getBean(ThreadFactory.class);
                }
                return this.beanLocator.getBean(ThreadFactory.class, Qualifiers.byName(executorConfiguration.getName()));
            }
            throw new IllegalStateException("No bean factory configured");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CompletionStage<?> shutdownGracefully() {
        ArrayList<GracefulShutdownCapable> copy;
        ExecutorFactory executorFactory = this;
        synchronized (executorFactory) {
            if (this.gracefulShutdownCapable == null) {
                return CompletableFuture.completedFuture(null);
            }
            copy = new ArrayList<GracefulShutdownCapable>(this.gracefulShutdownCapable);
        }
        return GracefulShutdownCapable.shutdownAll(copy.stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalLong reportActiveTasks() {
        ArrayList<GracefulShutdownCapable> copy;
        ExecutorFactory executorFactory = this;
        synchronized (executorFactory) {
            if (this.gracefulShutdownCapable == null) {
                return OptionalLong.empty();
            }
            copy = new ArrayList<GracefulShutdownCapable>(this.gracefulShutdownCapable);
        }
        return GracefulShutdownCapable.combineActiveTasks(copy);
    }
}

