/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface Encoder
extends AutoCloseable {
    @NonNull
    public Encoder encodeArray(@NonNull Argument<?> var1) throws IOException;

    @NonNull
    public Encoder encodeObject(@NonNull Argument<?> var1) throws IOException;

    public void finishStructure() throws IOException;

    @Override
    default public void close() throws IOException {
        this.finishStructure();
    }

    public void encodeKey(@NonNull String var1) throws IOException;

    public void encodeString(@NonNull String var1) throws IOException;

    public void encodeBoolean(boolean var1) throws IOException;

    public void encodeByte(byte var1) throws IOException;

    public void encodeShort(short var1) throws IOException;

    public void encodeChar(char var1) throws IOException;

    public void encodeInt(int var1) throws IOException;

    public void encodeLong(long var1) throws IOException;

    public void encodeFloat(float var1) throws IOException;

    public void encodeDouble(double var1) throws IOException;

    public void encodeBigInteger(@NonNull BigInteger var1) throws IOException;

    public void encodeBigDecimal(@NonNull BigDecimal var1) throws IOException;

    default public void encodeBinary(byte @NonNull [] data) throws IOException {
        BinaryCodecUtil.encodeToArray(this, data);
    }

    public void encodeNull() throws IOException;

    @NonNull
    default public String currentPath() {
        return "";
    }
}

