/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.config;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

public interface SerdeConfiguration {
    public static final String PREFIX = "micronaut.serde";
    public static final boolean DEFAULT_INET_ADDRESS_AS_NUMERIC = false;

    public Optional<String> getDateFormat();

    default public boolean isInetAddressAsNumeric() {
        return false;
    }

    @Bindable(defaultValue="STRING")
    public TimeShape getTimeWriteShape();

    @Bindable(defaultValue="SECONDS")
    public NumericTimeUnit getNumericTimeUnit();

    @Bindable(defaultValue="true")
    public boolean isWriteBinaryAsArray();

    public Optional<Locale> getLocale();

    public Optional<TimeZone> getTimeZone();

    @Bindable(defaultValue="io.micronaut")
    public List<String> getIncludedIntrospectionPackages();

    @Bindable(defaultValue="1024")
    public int getMaximumNestingDepth();

    @Nullable
    default public String getPropertyNamingStrategyName() {
        return null;
    }

    @Nullable
    default public PropertyNamingStrategy getPropertyNamingStrategy() {
        return PropertyNamingStrategy.forName(this.getPropertyNamingStrategyName()).orElse(null);
    }

    default public boolean isJsonViewEnabled() {
        return false;
    }

    public static enum NumericTimeUnit {
        LEGACY,
        SECONDS,
        MILLISECONDS,
        NANOSECONDS;

    }

    public static enum TimeShape {
        STRING,
        INTEGER,
        DECIMAL;

    }
}

