/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public final class JacksonDecoder
extends LimitingStream
implements Decoder {
    private static final int INT_CANARY = -15584170;
    private static final long LONG_CANARY = -66933498462557235L;
    @Internal
    private final JsonParser parser;
    @Nullable
    private JsonToken peekedToken;
    private boolean currentlyUnwrappingArray;

    private JacksonDecoder(JsonParser parser, LimitingStream.RemainingLimits remainingLimits) throws IOException {
        super(remainingLimits);
        this.parser = parser;
        if (!parser.hasCurrentToken()) {
            this.peekedToken = parser.nextToken();
            if (!parser.hasCurrentToken()) {
                throw new EOFException("No JSON input to parse");
            }
        } else {
            this.peekedToken = parser.currentToken();
        }
    }

    public static Decoder create(JsonParser parser, LimitingStream.RemainingLimits remainingLimits) throws IOException {
        return new JacksonDecoder(parser, remainingLimits);
    }

    @Override
    public IOException createDeserializationException(String message, Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message + " \n at " + String.valueOf(this.parser.getCurrentLocation()), null, invalidValue);
        }
        return new SerdeException(message + " \n at " + String.valueOf(this.parser.getCurrentLocation()));
    }

    private IOException unexpectedToken(JsonToken expected, JsonToken actual) {
        return this.createDeserializationException("Unexpected token " + String.valueOf((Object)actual) + ", expected " + String.valueOf((Object)expected), null);
    }

    @Override
    public void finishStructure(boolean consumeLeftElements) throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 != JsonToken.END_ARRAY && t2 != JsonToken.END_OBJECT) {
            if (!consumeLeftElements) {
                throw new IllegalStateException("Not all elements have been consumed yet");
            }
            do {
                if ((t2 = this.nextToken()) != JsonToken.START_ARRAY && t2 != JsonToken.START_OBJECT) continue;
                this.parser.skipChildren();
            } while (t2 != JsonToken.END_OBJECT && t2 != JsonToken.END_ARRAY && t2 != null);
        }
        this.decreaseDepth();
    }

    @Override
    public void finishStructure() throws IOException {
        JsonToken token = this.nextToken();
        if (token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT) {
            throw new IllegalStateException("Not all elements have been consumed yet");
        }
        this.decreaseDepth();
    }

    @Override
    public boolean hasNextArrayValue() throws IOException {
        return this.peekToken() != JsonToken.END_ARRAY;
    }

    @Override
    @Nullable
    public String decodeKey() throws IOException {
        if (this.peekedToken != null) {
            if (this.peekedToken == JsonToken.END_OBJECT) {
                return null;
            }
            String fieldName = this.parser.currentName();
            if (fieldName != null) {
                this.peekedToken = null;
            }
            return fieldName;
        }
        String fieldName = this.parser.nextFieldName();
        if (fieldName == null) {
            this.peekedToken = this.parser.currentToken();
        }
        return fieldName;
    }

    @Override
    @NonNull
    public JacksonDecoder decodeArray(Argument<?> type) throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 != JsonToken.START_ARRAY) {
            throw this.unexpectedToken(JsonToken.START_ARRAY, t2);
        }
        this.increaseDepth();
        return this;
    }

    @Override
    public JacksonDecoder decodeArray() throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 != JsonToken.START_ARRAY) {
            throw this.unexpectedToken(JsonToken.START_ARRAY, t2);
        }
        this.increaseDepth();
        return this;
    }

    @Override
    @NonNull
    public JacksonDecoder decodeObject(Argument<?> type) throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 != JsonToken.START_OBJECT) {
            throw this.unexpectedToken(JsonToken.START_OBJECT, t2);
        }
        this.increaseDepth();
        return this;
    }

    @Override
    public JacksonDecoder decodeObject() throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 != JsonToken.START_OBJECT) {
            throw this.unexpectedToken(JsonToken.START_OBJECT, t2);
        }
        this.increaseDepth();
        return this;
    }

    @Override
    @NonNull
    public String decodeString() throws IOException {
        String s2 = this.decodeStringNullable();
        if (s2 == null) {
            throw this.unexpectedToken(JsonToken.VALUE_STRING, this.parser.currentToken());
        }
        return s2;
    }

    @Override
    @Nullable
    public String decodeStringNullable() throws IOException {
        JsonToken t2;
        if (this.peekedToken == null) {
            String value = this.parser.nextTextValue();
            if (value != null) {
                return value;
            }
            t2 = this.parser.currentToken();
        } else {
            t2 = this.nextToken();
            if (t2 == JsonToken.VALUE_STRING) {
                return this.parser.getText();
            }
        }
        switch (t2) {
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    String unwrapped = this.decodeString();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_STRING, t2);
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_STRING, t2);
            }
        }
        return this.parser.getValueAsString();
    }

    @Override
    public boolean decodeBoolean() throws IOException {
        Boolean v = this.decodeBooleanNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_TRUE, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Boolean decodeBooleanNullable() throws IOException {
        Boolean value;
        if (this.peekedToken == null && (value = this.parser.nextBooleanValue()) != null) {
            return value;
        }
        return this.decodeBooleanSlow();
    }

    @Nullable
    private Boolean decodeBooleanSlow() throws IOException {
        JsonToken t2 = this.peekedToken == null ? this.parser.currentToken() : this.nextToken();
        switch (t2) {
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_NUMBER_FLOAT: {
                return (double)this.parser.getFloatValue() != 0.0;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    boolean unwrapped = this.decodeBoolean();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_TRUE, t2);
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_TRUE, t2);
            }
        }
        return this.parser.getValueAsBoolean();
    }

    @Override
    public byte decodeByte() throws IOException {
        Byte v = this.decodeByteNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Byte decodeByteNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case VALUE_TRUE: {
                return (byte)1;
            }
            case VALUE_FALSE: {
                return (byte)0;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    byte unwrapped = this.decodeByte();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        return this.parser.getByteValue();
    }

    @Override
    public short decodeShort() throws IOException {
        Short v = this.decodeShortNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Short decodeShortNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case VALUE_TRUE: {
                return (short)1;
            }
            case VALUE_FALSE: {
                return (short)0;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    short unwrapped = this.decodeShort();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        return this.parser.getShortValue();
    }

    @Override
    public char decodeChar() throws IOException {
        Character v = this.decodeCharNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v.charValue();
    }

    @Override
    @Nullable
    public Character decodeCharNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    char unwrapped = this.decodeChar();
                    if (this.endUnwrapArray()) {
                        return Character.valueOf(unwrapped);
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_STRING: {
                String string = this.parser.getText();
                if (string.length() != 1) {
                    throw this.createDeserializationException("When decoding char value, must give a single character", string);
                }
                return Character.valueOf(string.charAt(0));
            }
            case VALUE_NUMBER_INT: {
                return Character.valueOf((char)this.parser.getIntValue());
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        String text = this.parser.getText();
        if (text.length() == 0) {
            throw this.createDeserializationException("No characters found", text);
        }
        return Character.valueOf(text.charAt(0));
    }

    @Override
    public int decodeInt() throws IOException {
        Integer v = this.decodeIntNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Integer decodeIntNullable() throws IOException {
        int value;
        if (this.peekedToken == null && (value = this.parser.nextIntValue(-15584170)) != -15584170) {
            return value;
        }
        return this.decodeIntSlow();
    }

    @Nullable
    private Integer decodeIntSlow() throws IOException {
        JsonToken t2 = this.peekedToken == null ? this.parser.currentToken() : this.nextToken();
        switch (t2) {
            case VALUE_NUMBER_INT: {
                return this.parser.getIntValue();
            }
            case VALUE_STRING: {
                String string = this.parser.getText();
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    int unwrapped = this.decodeInt();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_FALSE: {
                return 0;
            }
            case VALUE_TRUE: {
                return 1;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        return this.parser.getValueAsInt();
    }

    @Override
    public long decodeLong() throws IOException {
        Long v = this.decodeLongNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Long decodeLongNullable() throws IOException {
        long value;
        if (this.peekedToken == null && (value = this.parser.nextLongValue(-66933498462557235L)) != -66933498462557235L) {
            return value;
        }
        return this.decodeLongSlow();
    }

    @Nullable
    private Long decodeLongSlow() throws IOException {
        JsonToken t2 = this.peekedToken == null ? this.parser.currentToken() : this.nextToken();
        switch (t2) {
            case VALUE_NUMBER_INT: {
                return this.parser.getLongValue();
            }
            case VALUE_STRING: {
                long value;
                String string = this.parser.getText();
                try {
                    value = Long.parseLong(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
                return value;
            }
            case VALUE_FALSE: {
                return 0L;
            }
            case VALUE_TRUE: {
                return 1L;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    long unwrapped = this.decodeLong();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        return this.parser.getValueAsLong();
    }

    @Override
    public float decodeFloat() throws IOException {
        Float v = this.decodeFloatNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, this.parser.currentToken());
        }
        return v.floatValue();
    }

    @Override
    @Nullable
    public Float decodeFloatNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case VALUE_STRING: {
                float value;
                String string = this.parser.getText();
                try {
                    value = Float.parseFloat(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to float", string);
                }
                return Float.valueOf(value);
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    float unwrapped = this.decodeFloat();
                    if (this.endUnwrapArray()) {
                        return Float.valueOf(unwrapped);
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, t2);
            }
            case VALUE_FALSE: {
                return Float.valueOf(0.0f);
            }
            case VALUE_TRUE: {
                return Float.valueOf(1.0f);
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, t2);
            }
        }
        return Float.valueOf(this.parser.getFloatValue());
    }

    @Override
    public double decodeDouble() throws IOException {
        Double v = this.decodeDoubleNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public Double decodeDoubleNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getDoubleValue();
        }
        return this.decodeDoubleSlow(t2);
    }

    @Nullable
    private Double decodeDoubleSlow(JsonToken t2) throws IOException {
        switch (t2) {
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.parser.getDoubleValue();
            }
            case VALUE_STRING: {
                String string = this.parser.getText();
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to double", string);
                }
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    double unwrapped = this.decodeDouble();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_FALSE: {
                return 0.0;
            }
            case VALUE_TRUE: {
                return 1.0;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, t2);
            }
        }
        return this.parser.getValueAsDouble();
    }

    @Override
    @NonNull
    public BigInteger decodeBigInteger() throws IOException {
        BigInteger v = this.decodeBigIntegerNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public BigInteger decodeBigIntegerNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case VALUE_STRING: {
                String string = this.parser.getText();
                try {
                    return new BigInteger(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    BigInteger unwrapped = this.decodeBigInteger();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
            case VALUE_FALSE: {
                return BigInteger.ZERO;
            }
            case VALUE_TRUE: {
                return BigInteger.ONE;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, t2);
            }
        }
        return this.parser.getBigIntegerValue();
    }

    @Override
    @NonNull
    public BigDecimal decodeBigDecimal() throws IOException {
        BigDecimal v = this.decodeBigDecimalNullable();
        if (v == null) {
            throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, this.parser.currentToken());
        }
        return v;
    }

    @Override
    @Nullable
    public BigDecimal decodeBigDecimalNullable() throws IOException {
        JsonToken t2 = this.nextToken();
        switch (t2) {
            case VALUE_STRING: {
                String string = this.parser.getText();
                try {
                    return new BigDecimal(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to BigDecimal", string);
                }
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(t2)) {
                    BigDecimal unwrapped = this.decodeBigDecimal();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, t2);
            }
            case VALUE_FALSE: {
                return BigDecimal.ZERO;
            }
            case VALUE_TRUE: {
                return BigDecimal.ONE;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: 
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.unexpectedToken(JsonToken.VALUE_NUMBER_FLOAT, t2);
            }
        }
        return this.parser.getDecimalValue();
    }

    private Number doDecodeNumber() throws IOException {
        this.nextToken();
        return this.parser.getNumberValue();
    }

    @Override
    public Number decodeNumber() throws IOException {
        return switch (this.peekToken()) {
            case JsonToken.VALUE_STRING -> this.decodeBigDecimal();
            case JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT -> this.doDecodeNumber();
            default -> throw this.unexpectedToken(JsonToken.VALUE_NUMBER_INT, this.nextToken());
        };
    }

    @Override
    public byte @NonNull [] decodeBinary() throws IOException {
        return switch (this.peekToken()) {
            case JsonToken.VALUE_STRING -> {
                this.nextToken();
                yield this.parser.getBinaryValue();
            }
            case JsonToken.START_ARRAY -> BinaryCodecUtil.decodeFromArray(this);
            default -> throw this.unexpectedToken(JsonToken.START_ARRAY, this.nextToken());
        };
    }

    @Override
    public boolean decodeNull() throws IOException {
        if (this.peekToken() == JsonToken.VALUE_NULL) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean beginUnwrapArray(JsonToken currentToken) throws IOException {
        if (this.currentlyUnwrappingArray) {
            return false;
        }
        if (currentToken != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        this.currentlyUnwrappingArray = true;
        return true;
    }

    private JsonToken nextToken() throws IOException {
        JsonToken peekedToken = this.peekedToken;
        if (peekedToken == null) {
            return this.parser.nextToken();
        }
        this.peekedToken = null;
        return peekedToken;
    }

    private JsonToken peekToken() throws IOException {
        if (this.peekedToken == null) {
            this.peekedToken = this.parser.nextToken();
        }
        return this.peekedToken;
    }

    private boolean endUnwrapArray() throws IOException {
        this.currentlyUnwrappingArray = false;
        if (this.peekToken() == JsonToken.END_ARRAY) {
            this.nextToken();
            return true;
        }
        return false;
    }

    @Override
    public Decoder decodeBuffer() throws IOException {
        JsonNode node = this.decodeNode();
        return JsonNodeDecoder.create(node, this.ourLimits());
    }

    @Override
    @NonNull
    public JsonNode decodeNode() throws IOException {
        JsonToken t2 = this.peekToken();
        return switch (t2) {
            case JsonToken.START_OBJECT -> JacksonDecoder.decodeObjectNode(this.decodeObject());
            case JsonToken.START_ARRAY -> JacksonDecoder.decodeArrayNode(this.decodeArray());
            case JsonToken.VALUE_STRING -> JsonNode.createStringNode(this.decodeString());
            case JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT -> {
                this.nextToken();
                yield this.getBestNumberNode();
            }
            case JsonToken.VALUE_TRUE, JsonToken.VALUE_FALSE -> JsonNode.createBooleanNode(this.decodeBoolean());
            case JsonToken.VALUE_NULL -> {
                this.decodeNull();
                yield JsonNode.nullNode();
            }
            default -> throw this.createDeserializationException("Unexpected token " + String.valueOf((Object)t2) + ", expected value", null);
        };
    }

    private JsonNode getBestNumberNode() throws IOException {
        Number number = this.parser.getNumberValue();
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return JsonNode.createNumberNode(number.intValue());
        }
        if (number instanceof Long) {
            return JsonNode.createNumberNode(number.longValue());
        }
        if (number instanceof Float) {
            return JsonNode.createNumberNode(number.floatValue());
        }
        if (number instanceof Double) {
            return JsonNode.createNumberNode(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return JsonNode.createNumberNode((BigInteger)number);
        }
        if (number instanceof BigDecimal) {
            return JsonNode.createNumberNode((BigDecimal)number);
        }
        return JsonNode.createNumberNode(this.parser.getDecimalValue());
    }

    private static JsonNode decodeObjectNode(JacksonDecoder elementDecoder) throws IOException {
        String key;
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        while ((key = elementDecoder.decodeKey()) != null) {
            result.put(key, elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createObjectNode(result);
    }

    private static JsonNode decodeArrayNode(JacksonDecoder elementDecoder) throws IOException {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        while (elementDecoder.hasNextArrayValue()) {
            result.add(elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createArrayNode(result);
    }

    @Override
    @Nullable
    public Object decodeArbitrary() throws IOException {
        RootBuilder root;
        for (ArbitraryBuilder currentStructure = root = new RootBuilder(this); currentStructure != null; currentStructure = currentStructure.proceed()) {
        }
        return root.result;
    }

    @Override
    public void skipValue() throws IOException {
        this.nextToken();
        this.parser.skipChildren();
    }

    private static final class RootBuilder
    extends ArbitraryBuilder {
        boolean done = false;
        Object result;

        RootBuilder(JacksonDecoder decoder) {
            super(null, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.result = value;
            this.done = true;
        }

        @Override
        String decodeKey() {
            return !this.done ? "" : null;
        }
    }

    private static abstract class ArbitraryBuilder {
        final ArbitraryBuilder parent;
        final JacksonDecoder elementDecoder;

        ArbitraryBuilder(ArbitraryBuilder parent, JacksonDecoder elementDecoder) {
            this.parent = parent;
            this.elementDecoder = elementDecoder;
        }

        abstract String decodeKey() throws IOException;

        abstract void put(String var1, Object var2);

        ArbitraryBuilder proceed() throws IOException {
            String key = this.decodeKey();
            if (key != null) {
                JsonToken t2 = this.elementDecoder.peekToken();
                switch (t2) {
                    case START_OBJECT: {
                        MapBuilder map = new MapBuilder(this, this.elementDecoder.decodeObject());
                        this.put(key, map.items);
                        return map;
                    }
                    case START_ARRAY: {
                        ListBuilder list = new ListBuilder(this, this.elementDecoder.decodeArray());
                        this.put(key, list.items);
                        return list;
                    }
                    case VALUE_STRING: {
                        this.put(key, this.elementDecoder.decodeString());
                        return this;
                    }
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: {
                        this.put(key, this.elementDecoder.doDecodeNumber());
                        return this;
                    }
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        this.put(key, this.elementDecoder.decodeBoolean());
                        return this;
                    }
                    case VALUE_NULL: {
                        this.elementDecoder.decodeNull();
                        this.put(key, null);
                        return this;
                    }
                }
                throw this.elementDecoder.createDeserializationException("Unexpected token " + String.valueOf((Object)t2) + ", expected value", null);
            }
            return this.parent;
        }
    }

    private static final class MapBuilder
    extends ArbitraryBuilder {
        private final Map<String, Object> items = new LinkedHashMap<String, Object>();

        MapBuilder(ArbitraryBuilder parent, JacksonDecoder elementDecoder) {
            super(parent, elementDecoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.put(key, value);
        }

        @Override
        String decodeKey() throws IOException {
            String key = this.elementDecoder.decodeKey();
            if (key == null) {
                this.elementDecoder.finishStructure();
            }
            return key;
        }
    }

    private static final class ListBuilder
    extends ArbitraryBuilder {
        private final List<Object> items = new ArrayList<Object>();

        ListBuilder(ArbitraryBuilder parent, JacksonDecoder decoder) {
            super(parent, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.add(value);
        }

        @Override
        String decodeKey() throws IOException {
            if (this.elementDecoder.hasNextArrayValue()) {
                return "";
            }
            this.elementDecoder.finishStructure();
            return null;
        }
    }
}

