/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
@BootstrapContextCompatible
public class DefaultSerdeIntrospections
implements SerdeIntrospections {
    private final Set<String> serdePackages;

    @Inject
    public DefaultSerdeIntrospections(SerdeConfiguration configuration) {
        List<String> introspectionPackages = configuration.getIncludedIntrospectionPackages();
        this.serdePackages = new HashSet<String>(introspectionPackages);
    }

    public DefaultSerdeIntrospections() {
        this.serdePackages = Collections.singleton("io.micronaut");
    }

    @Override
    public <T> Collection<BeanIntrospection<? extends T>> findSubtypeDeserializables(Class<T> type) {
        return this.getBeanIntrospector().findIntrospections(ref -> {
            if (ref.isPresent()) {
                Class bt = ref.getBeanType();
                return bt != type && type.isAssignableFrom(bt);
            }
            return false;
        }).stream().filter(bi -> this.isEnabledForDeserialization((AnnotationMetadataProvider)bi, bi.getGenericBeanType())).collect(Collectors.toList());
    }

    @Override
    public <T> BeanIntrospection<T> getSerializableIntrospection(Argument<T> type) {
        Collection<BeanIntrospection<Object>> candidates;
        BeanIntrospection i;
        BeanIntrospector beanIntrospector = this.getBeanIntrospector();
        Optional introspection = beanIntrospector.findIntrospection(type.getType());
        BeanIntrospection<Object> result = null;
        if (introspection.isPresent() && this.isEnabledForSerialization(i = introspection.get(), type)) {
            result = i;
        }
        if (result == null && CollectionUtils.isNotEmpty(candidates = beanIntrospector.findIntrospections(reference -> reference.isPresent() && reference.getBeanType().isAssignableFrom(type.getType()) && this.isEnabledForSerialization((AnnotationMetadataProvider)reference, type)))) {
            result = candidates.size() == 1 ? candidates.iterator().next() : (BeanIntrospection<Object>)OrderUtil.sort(candidates.stream()).findFirst().orElse(null);
        }
        if (result != null) {
            return this.resolveIntrospectionForSerialization(type, result);
        }
        throw new IntrospectionException("No serializable introspection present for type " + String.valueOf(type) + ". Consider adding Serdeable. Serializable annotate to type " + String.valueOf(type) + ". Alternatively if you are not in control of the project's source code, you can use @SerdeImport(" + type.getSimpleName() + ".class) to enable serialization of this type.");
    }

    @NonNull
    protected <T> BeanIntrospection<T> resolveIntrospectionForSerialization(@NonNull Argument<T> type, @NonNull BeanIntrospection<T> introspection) {
        AnnotationMetadata declaredMetadata = introspection.getDeclaredMetadata();
        AnnotationValue<SerdeConfig> serdeConfig = declaredMetadata.getDeclaredAnnotation(SerdeConfig.class);
        Class beanType = type.getType();
        Class<?> serializeType = this.resolveDeserAsType(beanType, serdeConfig, "serAs");
        if (serializeType != null && !serializeType.equals(beanType)) {
            Argument<?> resolved = Argument.of(serializeType, type.getName(), type.getAnnotationMetadata(), type.getTypeParameters());
            return this.getSerializableIntrospection(resolved);
        }
        return introspection;
    }

    @Override
    public <T> BeanIntrospection<T> getDeserializableIntrospection(Argument<T> type) {
        Class rawType = type.getType();
        BeanIntrospector beanIntrospector = this.getBeanIntrospector();
        BeanIntrospection introspection = beanIntrospector.findIntrospection(rawType).orElseGet(() -> {
            Class<?> as;
            Serdeable.Deserializable ann = rawType.getAnnotation(Serdeable.Deserializable.class);
            if (ann != null && (as = ann.as()) != Void.TYPE) {
                return beanIntrospector.getIntrospection(as);
            }
            return beanIntrospector.getIntrospection(rawType);
        });
        return this.resolveIntrospectionForDeserialization(type, introspection);
    }

    @NonNull
    protected <T> BeanIntrospection<T> resolveIntrospectionForDeserialization(@NonNull Argument<T> type, @NonNull BeanIntrospection<T> introspection) {
        if (this.isEnabledForDeserialization(introspection, type)) {
            AnnotationMetadata declaredMetadata = introspection.getDeclaredMetadata();
            AnnotationValue<SerdeConfig> serdeConfig = declaredMetadata.getDeclaredAnnotation(SerdeConfig.class);
            Class deserializeType = this.resolveDeserAsType(introspection.getBeanType(), serdeConfig, "deserAs");
            if (deserializeType == null && !declaredMetadata.hasAnnotation(SerdeConfig.SerSubtyped.class) && declaredMetadata.hasDeclaredAnnotation(DefaultImplementation.class)) {
                deserializeType = introspection.classValue(DefaultImplementation.class).orElse(null);
            }
            if (deserializeType != null && !deserializeType.equals(type.getType())) {
                Argument resolved = Argument.of(deserializeType, type.getName(), type.getAnnotationMetadata(), type.getTypeParameters());
                return this.getDeserializableIntrospection(resolved);
            }
            return introspection;
        }
        throw new IntrospectionException("No deserializable introspection present for type: " + String.valueOf(type) + ". Consider adding Serdeable.Deserializable annotate to type " + String.valueOf(type) + ". Alternatively if you are not in control of the project's source code, you can use @SerdeImport(" + type.getSimpleName() + ".class) to enable deserialization of this type.");
    }

    private Class<?> resolveDeserAsType(Class<?> beanType, AnnotationValue<SerdeConfig> serdeConfig, String configMember) {
        Class deserializeType = null;
        if (serdeConfig != null && (deserializeType = (Class)serdeConfig.classValue(configMember).orElse(null)) == null) {
            deserializeType = serdeConfig.stringValue(configMember).flatMap(n -> ClassUtils.forName(n, beanType.getClassLoader())).orElse(null);
        }
        return deserializeType;
    }

    private boolean isEnabledForDeserialization(AnnotationMetadataProvider reference, Argument<?> type) {
        AnnotationMetadata annotationMetadata = reference.getAnnotationMetadata();
        return this.isWithinSerdePackage(type) || annotationMetadata.hasStereotype((Class<? extends Annotation>)Serdeable.Deserializable.class) && annotationMetadata.booleanValue(Serdeable.Deserializable.class, "enabled").orElse(true) != false || annotationMetadata.hasAnnotation(SerdeImport.class) && this.isMixinEnabledForDeserialization(annotationMetadata.getAnnotationValuesByType(SerdeImport.class), type);
    }

    private boolean isEnabledForSerialization(AnnotationMetadataProvider reference, Argument<?> type) {
        AnnotationMetadata annotationMetadata = reference.getAnnotationMetadata();
        return this.isWithinSerdePackage(type) || annotationMetadata.hasStereotype((Class<? extends Annotation>)Serdeable.Serializable.class) && annotationMetadata.booleanValue(Serdeable.Serializable.class, "enabled").orElse(true) != false || annotationMetadata.hasAnnotation(SerdeImport.class) && this.isMixinEnabledForSerialization(annotationMetadata.getAnnotationValuesByType(SerdeImport.class), type);
    }

    private boolean isWithinSerdePackage(Argument<?> type) {
        return this.serdePackages.stream().anyMatch(p -> type.getTypeName().startsWith(p + "."));
    }

    private <T extends Annotation> boolean isMixinEnabledForDeserialization(List<AnnotationValue<T>> mixinsValues, Argument<?> type) {
        return this.isEnabledForMixin(mixinsValues, type, "deserializable");
    }

    private <T extends Annotation> boolean isMixinEnabledForSerialization(List<AnnotationValue<T>> mixinsValues, Argument<?> type) {
        return this.isEnabledForMixin(mixinsValues, type, "serializable");
    }

    private <T extends Annotation> Boolean isEnabledForMixin(List<AnnotationValue<T>> mixinsValues, Argument<?> type, String member) {
        return mixinsValues.stream().filter(av -> av.classValue().orElse(Object.class).equals(type.getType())).findFirst().flatMap(av -> av.booleanValue(member)).orElse(true);
    }
}

