/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.StringIntMap;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
final class PropertiesBag<T> {
    private final BeanIntrospection<T> beanIntrospection;
    private final int[] originalNameToPropertiesMapping;
    private final DeserBean.DerProperty<T, Object>[] properties;
    @Nullable
    private final Map<String, Integer> nameToPropertiesMapping;
    private final long propertiesMask;
    private final StringIntMap nameToPosition;

    private PropertiesBag(BeanIntrospection<T> beanIntrospection, int[] originalNameToPropertiesMapping, DeserBean.DerProperty<T, Object>[] properties, Map<String, Integer> nameToPropertiesMapping) {
        this.beanIntrospection = beanIntrospection;
        this.originalNameToPropertiesMapping = originalNameToPropertiesMapping;
        this.properties = properties;
        this.nameToPropertiesMapping = nameToPropertiesMapping;
        this.propertiesMask = properties.length > 0 && properties.length <= 64 ? -1L >>> 64 - properties.length : 0L;
        Stream<String> propStream = beanIntrospection.getBeanProperties().stream().map(Named::getName);
        if (nameToPropertiesMapping != null) {
            propStream = Stream.concat(propStream, nameToPropertiesMapping.keySet().stream());
        }
        Set props = propStream.collect(Collectors.toSet());
        this.nameToPosition = new StringIntMap(props.size());
        for (String prop : props) {
            this.nameToPosition.put(prop, this.propertyIndexOfSlow(prop));
        }
    }

    List<DeserBean.DerProperty<T, Object>> getProperties() {
        Stream<DeserBean.DerProperty> originalProperties = Arrays.stream(this.originalNameToPropertiesMapping).filter(index -> index != -1).mapToObj(index -> {
            DeserBean.DerProperty<T, Object> prop = this.properties[index];
            if (prop.beanProperty == null) {
                return null;
            }
            return prop;
        });
        Stream mappedByName = this.nameToPropertiesMapping == null ? Stream.empty() : this.nameToPropertiesMapping.values().stream().map(index -> this.properties[index]);
        return Stream.concat(originalProperties, mappedByName).toList();
    }

    List<DeserBean.DerProperty<T, Object>> getDerProperties() {
        return Collections.unmodifiableList(Arrays.asList(this.properties));
    }

    DeserBean.DerProperty<T, Object>[] getPropertiesArray() {
        return this.properties;
    }

    int propertyIndexOf(@NonNull String name) {
        return this.nameToPosition.get(name, -1);
    }

    private int propertyIndexOfSlow(@NonNull String name) {
        int propertyIndex = -1;
        int beanPropertyIndex = this.beanIntrospection.propertyIndexOf(name);
        if (beanPropertyIndex != -1) {
            propertyIndex = this.originalNameToPropertiesMapping[beanPropertyIndex];
        }
        if (propertyIndex != -1) {
            return propertyIndex;
        }
        return this.nameToPropertiesMapping == null ? -1 : this.nameToPropertiesMapping.getOrDefault(name, -1);
    }

    Consumer newConsumer() {
        return this.propertiesMask == 0L ? new ConsumerBig() : new ConsumerSmall();
    }

    private final class ConsumerBig
    extends Consumer {
        private final BitSet consumed;
        private int remaining;

        private ConsumerBig() {
            this.consumed = new BitSet(PropertiesBag.this.properties.length);
            this.remaining = PropertiesBag.this.properties.length;
        }

        @Override
        boolean isConsumed(int index) {
            return this.consumed.get(index);
        }

        @Override
        public boolean isAllConsumed() {
            return this.remaining == 0;
        }

        @Override
        void setConsumed(int index) {
            this.consumed.set(index);
            --this.remaining;
        }
    }

    private final class ConsumerSmall
    extends Consumer {
        private long consumed;

        private ConsumerSmall() {
            this.consumed = PropertiesBag.this.propertiesMask ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        boolean isConsumed(int index) {
            return (this.consumed & 1L << index) != 0L;
        }

        @Override
        void setConsumed(int index) {
            this.consumed |= 1L << index;
        }

        @Override
        public boolean isAllConsumed() {
            return this.consumed == -1L;
        }
    }

    static class Builder<T> {
        private final BeanIntrospection<T> beanIntrospection;
        private final int[] originalNameToPropertiesMapping;
        @Nullable
        private Map<String, Integer> nameToPropertiesMapping;
        private final List<DeserBean.DerProperty<T, Object>> mutableProperties;

        Builder(BeanIntrospection<T> beanIntrospection) {
            this(beanIntrospection, beanIntrospection.getBeanProperties().size());
        }

        Builder(BeanIntrospection<T> beanIntrospection, int expectedPropertiesSize) {
            this.beanIntrospection = beanIntrospection;
            int beanPropertiesSize = beanIntrospection.getBeanProperties().size();
            this.originalNameToPropertiesMapping = new int[beanPropertiesSize];
            Arrays.fill(this.originalNameToPropertiesMapping, -1);
            this.mutableProperties = new ArrayList<DeserBean.DerProperty<T, Object>>(expectedPropertiesSize);
        }

        void register(String name, DeserBean.DerProperty<T, Object> derProperty, boolean addAliases) {
            int newPropertyIndex = this.mutableProperties.size();
            if (derProperty.beanProperty != null && derProperty.beanProperty.getDeclaringBean() == this.beanIntrospection && name.equals(derProperty.beanProperty.getName())) {
                this.originalNameToPropertiesMapping[this.beanIntrospection.propertyIndexOf((String)name)] = newPropertyIndex;
            } else {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                this.nameToPropertiesMapping.put(name, newPropertyIndex);
            }
            if (addAliases && derProperty.aliases != null && derProperty.aliases.length > 0) {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                for (String alias : derProperty.aliases) {
                    this.nameToPropertiesMapping.put(alias, newPropertyIndex);
                }
            }
            this.mutableProperties.add(derProperty);
        }

        @Nullable
        PropertiesBag<T> build() {
            if (this.mutableProperties.isEmpty()) {
                return null;
            }
            return new PropertiesBag<T>(this.beanIntrospection, this.originalNameToPropertiesMapping, (DeserBean.DerProperty[])this.mutableProperties.toArray(DeserBean.DerProperty[]::new), this.nameToPropertiesMapping);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    abstract class Consumer {
        private Consumer() {
        }

        public boolean contains(String name) {
            return PropertiesBag.this.nameToPosition.get(name, -1) != -1;
        }

        public DeserBean.DerProperty<T, Object> consume(String name) {
            int propertyIndex = PropertiesBag.this.nameToPosition.get(name, -1);
            if (propertyIndex == -1 || this.isConsumed(propertyIndex)) {
                return null;
            }
            this.setConsumed(propertyIndex);
            return PropertiesBag.this.properties[propertyIndex];
        }

        public void consume(int propertyIndex) {
            if (propertyIndex == -1 || this.isConsumed(propertyIndex)) {
                return;
            }
            this.setConsumed(propertyIndex);
        }

        public List<DeserBean.DerProperty<T, Object>> getNotConsumed() {
            ArrayList list = new ArrayList(PropertiesBag.this.properties.length);
            int bound = PropertiesBag.this.properties.length;
            for (int index = 0; index < bound; ++index) {
                if (this.isConsumed(index)) continue;
                list.add(PropertiesBag.this.properties[index]);
            }
            return list;
        }

        abstract boolean isConsumed(int var1);

        abstract void setConsumed(int var1);

        public abstract boolean isAllConsumed();
    }
}

