/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import java.io.IOException;

@Internal
final class SimpleRecordLikeObjectDeserializer
implements Deserializer<Object>,
UpdatingDeserializer<Object> {
    private final BeanIntrospection<Object> introspection;
    private final PropertiesBag<Object> constructorParameters;
    private final int valuesSize;
    private final boolean ignoreUnknown;
    private final boolean strictNullable;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;

    SimpleRecordLikeObjectDeserializer(boolean strictNullable, DeserBean<? super Object> deserBean, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.introspection = deserBean.introspection;
        this.constructorParameters = deserBean.creatorParams;
        this.valuesSize = deserBean.creatorSize;
        this.preInstantiateCallback = preInstantiateCallback;
        this.ignoreUnknown = deserBean.ignoreUnknown;
        this.strictNullable = strictNullable;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType) throws IOException {
        Object obj;
        Object propertyName;
        Decoder objectDecoder = decoder.decodeObject(beanType);
        PropertiesBag.Consumer creatorParameters = this.constructorParameters.newConsumer();
        Object[] params = new Object[this.valuesSize];
        boolean allConsumed = this.valuesSize == 0;
        boolean finished = false;
        while (!allConsumed) {
            propertyName = objectDecoder.decodeKey();
            if (propertyName == null) {
                finished = true;
                break;
            }
            DeserBean.DerProperty derProperty = creatorParameters.consume((String)propertyName);
            if (derProperty != null) {
                derProperty.deserializeAndSetConstructorValue(objectDecoder, decoderContext, params);
                allConsumed = creatorParameters.isAllConsumed();
                continue;
            }
            if (this.ignoreUnknown) {
                objectDecoder.skipValue();
                continue;
            }
            throw this.unexpectedProperty(beanType, creatorParameters, (String)propertyName);
        }
        if (!allConsumed) {
            propertyName = creatorParameters.getNotConsumed().iterator();
            while (propertyName.hasNext()) {
                DeserBean.DerProperty sp = (DeserBean.DerProperty)propertyName.next();
                sp.setDefaultConstructorValue(decoderContext, params);
            }
        }
        if (!finished && !this.ignoreUnknown && (propertyName = objectDecoder.decodeKey()) != null) {
            throw this.unexpectedProperty(beanType, creatorParameters, (String)propertyName);
        }
        try {
            if (this.preInstantiateCallback != null) {
                this.preInstantiateCallback.preInstantiate(this.introspection, params);
            }
            obj = this.introspection.instantiate(this.strictNullable, params);
        }
        catch (InstantiationException e) {
            throw new SerdeException("Unable to deserialize type [" + String.valueOf(beanType) + "]: " + e.getMessage(), e);
        }
        objectDecoder.finishStructure(true);
        return obj;
    }

    private SerdeException unexpectedProperty(Argument<? super Object> beanType, PropertiesBag.Consumer creatorParameters, String propertyName) {
        if (creatorParameters.contains(propertyName)) {
            return SimpleRecordLikeObjectDeserializer.duplicateProperty(beanType, propertyName);
        }
        return SimpleRecordLikeObjectDeserializer.unknownProperty(beanType, propertyName);
    }

    private static SerdeException unknownProperty(Argument<? super Object> beanType, String propertyName) {
        SerdeException serdeException = new SerdeException("Unknown property [" + propertyName + "] encountered during deserialization of type: " + String.valueOf(beanType));
        serdeException.getPath().add(ReferencePath.ofProperty(beanType.getType(), Argument.OBJECT_ARGUMENT.withName(propertyName)));
        return serdeException;
    }

    private static SerdeException duplicateProperty(Argument<? super Object> beanType, String propertyName) {
        SerdeException serdeException = new SerdeException("Duplicate property [" + propertyName + "] encountered during deserialization of type: " + String.valueOf(beanType));
        serdeException.getPath().add(ReferencePath.ofProperty(beanType.getType(), Argument.OBJECT_ARGUMENT.withName(propertyName)));
        return serdeException;
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType, Object value) throws IOException {
        throw new SerdeException("Unsupported deserialize into immutable [" + String.valueOf(beanType) + "]");
    }
}

