/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserializerSubtypeInfo;
import java.io.IOException;

@Internal
final class WrappedArraySubtypedDeserializer
implements Deserializer<Object> {
    private final DeserializerSubtypeInfo<? super Object> subtypeInfo;
    private final boolean ignoreUnknown;

    WrappedArraySubtypedDeserializer(DeserializerSubtypeInfo<? super Object> subtypeInfo, boolean ignoreUnknown) {
        this.subtypeInfo = subtypeInfo;
        this.ignoreUnknown = ignoreUnknown;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        return this.deserialize(decoder, context, type, false);
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type, boolean isNullable) throws IOException {
        Decoder unwrappedDecoder = decoder.decodeArray();
        String discriminator = unwrappedDecoder.decodeStringNullable();
        if (discriminator == null) {
            if (!isNullable) throw new SerdeException("Wrapper property is null encountered during deserialization of type: " + String.valueOf(type));
            return null;
        }
        Deserializer<? super Object> deserializer = this.subtypeInfo.findDeserializer(discriminator);
        if (!unwrappedDecoder.hasNextArrayValue()) {
            throw new SerdeException("Missing wrapper value for deserialization of type: " + String.valueOf(type));
        }
        Object result = isNullable ? deserializer.deserializeNullable(unwrappedDecoder, context, type) : deserializer.deserialize(unwrappedDecoder, context, type);
        if (unwrappedDecoder.hasNextArrayValue()) {
            if (!this.ignoreUnknown) throw new SerdeException("Unknown array item encountered during deserialization of type: " + String.valueOf(type));
            unwrappedDecoder.finishStructure(true);
            return result;
        } else {
            unwrappedDecoder.finishStructure();
        }
        return result;
    }
}

