/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserializerSubtypeInfo;
import java.io.IOException;

@Internal
final class WrappedObjectSubtypedDeserializer
implements Deserializer<Object> {
    private final DeserializerSubtypeInfo<? super Object> subtypeInfo;
    private final boolean ignoreUnknown;

    WrappedObjectSubtypedDeserializer(DeserializerSubtypeInfo<? super Object> subtypeInfo, boolean ignoreUnknown) {
        this.subtypeInfo = subtypeInfo;
        this.ignoreUnknown = ignoreUnknown;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        return this.deserialize(decoder, context, type, false);
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type, true);
    }

    private Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type, boolean isNullable) throws IOException {
        Decoder unwrappedDecoder = decoder.decodeObject();
        String discriminatorValue = unwrappedDecoder.decodeKey();
        if (discriminatorValue == null) {
            if (isNullable) {
                return null;
            }
            throw new SerdeException("Wrapper property is null encountered during deserialization of type: " + String.valueOf(type));
        }
        Deserializer<? super Object> deserializer = this.subtypeInfo.findDeserializer(discriminatorValue);
        Object result = isNullable ? deserializer.deserializeNullable(unwrappedDecoder, context, type) : deserializer.deserialize(unwrappedDecoder, context, type);
        if (this.ignoreUnknown) {
            unwrappedDecoder.finishStructure(true);
        } else {
            String unknownProp = unwrappedDecoder.decodeKey();
            if (unknownProp != null) {
                throw this.unknownProperty(type, unknownProp);
            }
            unwrappedDecoder.finishStructure();
        }
        return result;
    }

    private SerdeException unknownProperty(Argument<? super Object> beanType, String prop) {
        return new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + String.valueOf(beanType));
    }
}

