/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.ArrayDeque;

@Internal
final class ArrayDequeDeserializer<E>
extends CollectionDeserializer<E, ArrayDeque<E>> {
    ArrayDequeDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    @Override
    public ArrayDeque<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ArrayDeque<E>> type) throws IOException {
        ArrayDeque collection = new ArrayDeque();
        this.doDeserialize(decoder, context, collection, type);
        return collection;
    }

    @Override
    public ArrayDeque<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ArrayDeque<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public ArrayDeque<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super ArrayDeque<E>> type) {
        return new ArrayDeque();
    }
}

