/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import java.io.IOException;
import java.util.Collection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class CollectionDeserializer<E, C extends Collection<E>>
implements Deserializer<C> {
    private final Deserializer<? extends E> valueDeser;
    private final Argument<E> collectionItemArgument;

    CollectionDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        this.valueDeser = valueDeser;
        this.collectionItemArgument = collectionItemArgument;
    }

    protected final void doDeserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Collection<E> collection, Argument<? super C> collectionArgument) throws IOException {
        int index = 0;
        try {
            Decoder arrayDecoder = decoder.decodeArray();
            while (arrayDecoder.hasNextArrayValue()) {
                E deserialize = this.valueDeser.deserializeNullable(arrayDecoder, decoderContext, this.collectionItemArgument);
                collection.add(deserialize);
                ++index;
            }
            arrayDecoder.finishStructure();
        }
        catch (SerdeException e) {
            e.getPath().add(ReferencePath.ofCollection(((Collection)this.getDefaultValue(decoderContext, collectionArgument)).getClass(), collectionArgument, index));
            throw e;
        }
    }
}

