/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.LinkedHashSet;

@Internal
final class LinkedHashSetDeserializer<E>
extends CollectionDeserializer<E, LinkedHashSet<E>> {
    LinkedHashSetDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    @Override
    public LinkedHashSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super LinkedHashSet<E>> type) throws IOException {
        LinkedHashSet collection = new LinkedHashSet();
        this.doDeserialize(decoder, context, collection, type);
        return collection;
    }

    @Override
    public LinkedHashSet<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super LinkedHashSet<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public LinkedHashSet<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super LinkedHashSet<E>> type) {
        return new LinkedHashSet();
    }
}

