/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

final class BooleanSerde
implements SerdeRegistrar<Boolean> {
    BooleanSerde() {
    }

    @Override
    public Boolean deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Boolean> type) throws IOException {
        return decoder.decodeBoolean();
    }

    @Override
    public Boolean deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Boolean> type) throws IOException {
        return decoder.decodeBooleanNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Boolean> type, Boolean value) throws IOException {
        encoder.encodeBoolean(value);
    }

    @Override
    public boolean isDefault(Serializer.EncoderContext context, Boolean value) {
        return value == false;
    }

    @Override
    public Argument<Boolean> getType() {
        return Argument.of(Boolean.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.BOOLEAN);
    }

    @Override
    @Nullable
    public Boolean getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Boolean> type) {
        return type.isPrimitive() ? Boolean.valueOf(false) : null;
    }
}

